/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.transport;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.action.ShieldActionMapper;
import org.elasticsearch.shield.authc.AuthenticationService;
import org.elasticsearch.shield.authz.AuthorizationService;
import org.elasticsearch.shield.support.Exceptions;
import org.elasticsearch.transport.DelegatingTransportChannel;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.netty.NettyTransportChannel;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.ssl.SslHandler;

public interface ServerTransportFilter {
    public void inbound(String var1, TransportRequest var2, TransportChannel var3) throws IOException;

    public static class ClientProfile
    extends NodeProfile {
        public ClientProfile(AuthenticationService authcService, AuthorizationService authzService, ShieldActionMapper actionMapper, boolean extractClientCert, DestructiveOperations destructiveOperations) {
            super(authcService, authzService, actionMapper, extractClientCert, destructiveOperations);
        }

        @Override
        public void inbound(String action, TransportRequest request, TransportChannel transportChannel) throws IOException {
            boolean isInternalOrShardAction;
            boolean bl = isInternalOrShardAction = action.startsWith("internal:") || action.endsWith("]");
            if (isInternalOrShardAction) {
                throw Exceptions.authenticationError("executing internal/shard actions is considered malicious and forbidden", new Object[0]);
            }
            super.inbound(action, request, transportChannel);
        }
    }

    public static class NodeProfile
    implements ServerTransportFilter {
        private static final ESLogger logger = Loggers.getLogger(NodeProfile.class);
        private final AuthenticationService authcService;
        private final AuthorizationService authzService;
        private final ShieldActionMapper actionMapper;
        private final boolean extractClientCert;
        private final DestructiveOperations destructiveOperations;

        public NodeProfile(AuthenticationService authcService, AuthorizationService authzService, ShieldActionMapper actionMapper, boolean extractClientCert, DestructiveOperations destructiveOperations) {
            this.authcService = authcService;
            this.authzService = authzService;
            this.actionMapper = actionMapper;
            this.extractClientCert = extractClientCert;
            this.destructiveOperations = destructiveOperations;
        }

        @Override
        public void inbound(String action, TransportRequest request, TransportChannel transportChannel) throws IOException {
            String shieldAction;
            block8: {
                if ("indices:admin/close".equals(action) || "indices:admin/open".equals(action) || "indices:admin/delete".equals(action)) {
                    IndicesRequest indicesRequest = (IndicesRequest)request;
                    this.destructiveOperations.failDestructive(indicesRequest.indices());
                }
                shieldAction = this.actionMapper.action(action, request);
                TransportChannel unwrappedChannel = transportChannel;
                while (unwrappedChannel instanceof DelegatingTransportChannel) {
                    unwrappedChannel = ((DelegatingTransportChannel)unwrappedChannel).getChannel();
                }
                if (this.extractClientCert && unwrappedChannel instanceof NettyTransportChannel) {
                    Channel channel = ((NettyTransportChannel)unwrappedChannel).getChannel();
                    SslHandler sslHandler = (SslHandler)channel.getPipeline().get(SslHandler.class);
                    assert (sslHandler != null);
                    try {
                        Certificate[] certs = sslHandler.getEngine().getSession().getPeerCertificates();
                        if (certs instanceof X509Certificate[]) {
                            request.putInContext((Object)"__SHIELD_CLIENT_CERTIFICATE", (Object)certs);
                        }
                    }
                    catch (SSLPeerUnverifiedException e) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("SSL Peer did not present a certificate on channel [{}]", (Throwable)e, new Object[]{channel});
                        }
                        if (!logger.isDebugEnabled()) break block8;
                        logger.debug("SSL Peer did not present a certificate on channel [{}]", new Object[]{channel});
                    }
                }
            }
            User user = this.authcService.authenticate(shieldAction, (TransportMessage)request, null);
            this.authzService.authorize(user, shieldAction, request);
        }
    }
}

