/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.rest.action.role;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;
import org.elasticsearch.shield.action.role.ClearRolesCacheRequest;
import org.elasticsearch.shield.action.role.ClearRolesCacheResponse;
import org.elasticsearch.shield.client.ShieldClient;

public class RestClearRolesCacheAction
extends BaseRestHandler {
    @Inject
    public RestClearRolesCacheAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.POST, "/_shield/role/{name}/_clear_cache", (RestHandler)this);
    }

    protected void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        String[] roles = request.paramAsStringArrayOrEmptyIfAll("name");
        ClearRolesCacheRequest req = new ClearRolesCacheRequest().roles(roles);
        new ShieldClient((ElasticsearchClient)client).clearRolesCache(req, (ActionListener<ClearRolesCacheResponse>)new RestBuilderListener<ClearRolesCacheResponse>(channel){

            public RestResponse buildResponse(ClearRolesCacheResponse response, XContentBuilder builder) throws Exception {
                response.toXContent(builder, ToXContent.EMPTY_PARAMS);
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

