/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.rest.action;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.shield.InternalSystemUser;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.authc.AuthenticationService;
import org.elasticsearch.shield.license.ShieldLicenseState;

public class RestAuthenticateAction
extends BaseRestHandler {
    private final AuthenticationService authenticationService;
    private final ShieldLicenseState shieldLicenseState;

    @Inject
    public RestAuthenticateAction(Settings settings, RestController controller, Client client, AuthenticationService authenticationService, ShieldLicenseState licenseState) {
        super(settings, controller, client);
        this.authenticationService = authenticationService;
        this.shieldLicenseState = licenseState;
        controller.registerHandler(RestRequest.Method.GET, "/_shield/authenticate", (RestHandler)this);
    }

    protected void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        if (!this.shieldLicenseState.securityEnabled()) {
            throw new ElasticsearchSecurityException("{} is not licensed", RestStatus.BAD_REQUEST, new Object[]{"shield"});
        }
        User user = this.authenticationService.authenticate(request);
        assert (user != null);
        if (InternalSystemUser.is(user)) {
            throw new ElasticsearchSecurityException("the authenticate API cannot be used for the internal system user", new Object[0]);
        }
        XContentBuilder builder = channel.newBuilder();
        user.toXContent(builder, ToXContent.EMPTY_PARAMS);
        channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
    }
}

