/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authz.store;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.LatchedActionListener;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.shield.InternalShieldUser;
import org.elasticsearch.shield.action.role.ClearRolesCacheRequest;
import org.elasticsearch.shield.action.role.ClearRolesCacheResponse;
import org.elasticsearch.shield.action.role.DeleteRoleRequest;
import org.elasticsearch.shield.action.role.PutRoleRequest;
import org.elasticsearch.shield.authc.AuthenticationService;
import org.elasticsearch.shield.authz.Permission;
import org.elasticsearch.shield.authz.RoleDescriptor;
import org.elasticsearch.shield.authz.store.RolesStore;
import org.elasticsearch.shield.client.ShieldClient;
import org.elasticsearch.shield.support.ClientWithUser;
import org.elasticsearch.threadpool.ThreadPool;

public class ESNativeRolesStore
extends AbstractComponent
implements RolesStore,
ClusterStateListener {
    public static final String ROLE_DOC_TYPE = "role";
    private static final String CACHE_MAX_SIZE_SETTING = "shield.authz.store.roles.index.cache.max_size";
    private static final long CACHE_MAX_SIZE_DEFAULT = 10000L;
    private static final String CACHE_TTL_SETTING = "shield.authz.store.roles.index.cache.ttl";
    private static final TimeValue CACHE_TTL_DEFAULT = TimeValue.timeValueMinutes((long)20L);
    private final Provider<Client> clientProvider;
    private final Provider<AuthenticationService> authProvider;
    private final ThreadPool threadPool;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INITIALIZED);
    private final Cache<String, RoleAndVersion> roleCache;
    private final boolean isTribeNode;
    private Client client;
    private ShieldClient shieldClient;
    private int scrollSize;
    private TimeValue scrollKeepAlive;
    private ThreadPool.Cancellable rolesPoller;
    private volatile boolean shieldIndexExists = false;

    @Inject
    public ESNativeRolesStore(Settings settings, Provider<Client> clientProvider, Provider<AuthenticationService> authProvider, ThreadPool threadPool) {
        super(settings);
        this.clientProvider = clientProvider;
        this.authProvider = authProvider;
        this.threadPool = threadPool;
        this.isTribeNode = !settings.getGroups("tribe", true).isEmpty();
        this.roleCache = CacheBuilder.newBuilder().expireAfterWrite(settings.getAsTime(CACHE_TTL_SETTING, CACHE_TTL_DEFAULT).getMillis(), TimeUnit.MILLISECONDS).maximumSize(settings.getAsLong(CACHE_MAX_SIZE_SETTING, Long.valueOf(10000L)).longValue()).build();
    }

    public boolean canStart(ClusterState clusterState, boolean master) {
        if (this.state() != State.INITIALIZED) {
            return false;
        }
        if (clusterState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            this.logger.debug("native roles store waiting until gateway has recovered from disk", new Object[0]);
            return false;
        }
        if (this.isTribeNode) {
            return true;
        }
        if (clusterState.metaData().templates().get((Object)"security-index-template") == null) {
            this.logger.debug("native roles template [{}] does not exist, so service cannot start", new Object[]{"security-index-template"});
            return false;
        }
        IndexMetaData metaData = clusterState.metaData().index(".security");
        if (metaData == null) {
            this.logger.debug("security index [{}] does not exist, so service can start", new Object[]{".security"});
            return true;
        }
        if (clusterState.routingTable().index(".security").allPrimaryShardsActive()) {
            this.logger.debug("security index [{}] all primary shards started, so service can start", new Object[]{".security"});
            return true;
        }
        return true;
    }

    public void start() {
        try {
            if (this.state.compareAndSet(State.INITIALIZED, State.STARTING)) {
                this.client = new ClientWithUser((Client)this.clientProvider.get(), (AuthenticationService)this.authProvider.get(), InternalShieldUser.INSTANCE);
                this.shieldClient = new ShieldClient((ElasticsearchClient)this.client);
                this.scrollSize = this.settings.getAsInt("shield.authc.native.scroll.size", Integer.valueOf(1000));
                this.scrollKeepAlive = this.settings.getAsTime("shield.authc.native.scroll.keep_alive", TimeValue.timeValueSeconds((long)10L));
                TimeValue pollInterval = this.settings.getAsTime("shield.authc.native.reload.interval", TimeValue.timeValueSeconds((long)30L));
                this.rolesPoller = this.threadPool.scheduleWithFixedDelay((Runnable)((Object)new RolesStorePoller()), pollInterval, "generic");
                this.state.set(State.STARTED);
            }
        }
        catch (Exception e) {
            this.logger.error("failed to start ESNativeRolesStore", (Throwable)e, new Object[0]);
            this.state.set(State.FAILED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            try {
                this.rolesPoller.cancel();
            }
            finally {
                this.state.set(State.STOPPED);
            }
        }
    }

    public void getRoleDescriptors(String[] names, final ActionListener<List<RoleDescriptor>> listener) {
        if (this.state() != State.STARTED) {
            this.logger.trace("attempted to get roles before service was started", new Object[0]);
            listener.onFailure((Throwable)new IllegalStateException("roles cannot be retrieved as native role service has not been started"));
            return;
        }
        try {
            final ArrayList roles = new ArrayList();
            Object query = names == null || names.length == 0 ? QueryBuilders.matchAllQuery() : QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.idsQuery((String[])new String[]{ROLE_DOC_TYPE}).addIds(names));
            SearchRequest request = this.client.prepareSearch(new String[]{".security"}).setTypes(new String[]{ROLE_DOC_TYPE}).setScroll(this.scrollKeepAlive).setQuery((QueryBuilder)query).setSize(this.scrollSize).setFetchSource(true).request();
            this.client.search(request, (ActionListener)new ActionListener<SearchResponse>(){
                private SearchResponse lastResponse = null;

                public void onResponse(SearchResponse resp) {
                    boolean hasHits;
                    this.lastResponse = resp;
                    boolean bl = hasHits = resp.getHits().getHits().length > 0;
                    if (hasHits) {
                        for (SearchHit hit : resp.getHits().getHits()) {
                            RoleDescriptor rd = ESNativeRolesStore.this.transformRole(hit.getId(), hit.getSourceRef());
                            if (rd == null) continue;
                            roles.add(rd);
                        }
                        SearchScrollRequest scrollRequest = (SearchScrollRequest)ESNativeRolesStore.this.client.prepareSearchScroll(resp.getScrollId()).setScroll(ESNativeRolesStore.this.scrollKeepAlive).request();
                        ESNativeRolesStore.this.client.searchScroll(scrollRequest, (ActionListener)this);
                    } else {
                        if (resp.getScrollId() != null) {
                            ESNativeRolesStore.this.clearScollRequest(resp.getScrollId());
                        }
                        listener.onResponse(Collections.unmodifiableList(roles));
                    }
                }

                public void onFailure(Throwable t) {
                    if (this.lastResponse != null && this.lastResponse.getScrollId() != null) {
                        ESNativeRolesStore.this.clearScollRequest(this.lastResponse.getScrollId());
                    }
                    if (t instanceof IndexNotFoundException) {
                        ESNativeRolesStore.this.logger.trace("could not retrieve roles because security index does not exist", new Object[0]);
                        listener.onResponse(Collections.emptyList());
                    } else {
                        listener.onFailure(t);
                    }
                }
            });
        }
        catch (Exception e) {
            this.logger.error("unable to retrieve roles {}", (Throwable)e, new Object[]{Arrays.toString(names)});
            listener.onFailure((Throwable)e);
        }
    }

    public void getRoleDescriptor(String role, ActionListener<RoleDescriptor> listener) {
        RoleAndVersion roleAndVersion;
        if (this.state() != State.STARTED) {
            this.logger.trace("attempted to get role [{}] before service was started", new Object[]{role});
            listener.onResponse(null);
        }
        listener.onResponse((Object)((roleAndVersion = this.getRoleAndVersion(role)) == null ? null : roleAndVersion.getRoleDescriptor()));
    }

    public void deleteRole(final DeleteRoleRequest deleteRoleRequest, final ActionListener<Boolean> listener) {
        if (this.state() != State.STARTED) {
            this.logger.trace("attempted to delete role [{}] before service was started", new Object[]{deleteRoleRequest.name()});
            listener.onResponse((Object)false);
        } else if (this.isTribeNode) {
            listener.onFailure((Throwable)new UnsupportedOperationException("roles may not be deleted using a tribe node"));
            return;
        }
        try {
            DeleteRequest request = (DeleteRequest)this.client.prepareDelete(".security", ROLE_DOC_TYPE, deleteRoleRequest.name()).request();
            request.refresh(deleteRoleRequest.refresh());
            this.client.delete(request, (ActionListener)new ActionListener<DeleteResponse>(){

                public void onResponse(DeleteResponse deleteResponse) {
                    ESNativeRolesStore.this.clearRoleCache(deleteRoleRequest.name(), listener, deleteResponse.isFound());
                }

                public void onFailure(Throwable e) {
                    ESNativeRolesStore.this.logger.error("failed to delete role from the index", e, new Object[0]);
                    listener.onFailure(e);
                }
            });
        }
        catch (IndexNotFoundException e) {
            this.logger.trace("security index does not exist", (Throwable)e, new Object[0]);
            listener.onResponse((Object)false);
        }
        catch (Exception e) {
            this.logger.error("unable to remove role", (Throwable)e, new Object[0]);
            listener.onFailure((Throwable)e);
        }
    }

    public void putRole(final PutRoleRequest request, final RoleDescriptor role, final ActionListener<Boolean> listener) {
        if (this.state() != State.STARTED) {
            this.logger.trace("attempted to put role [{}] before service was started", new Object[]{request.name()});
            listener.onResponse((Object)false);
        } else if (this.isTribeNode) {
            listener.onFailure((Throwable)new UnsupportedOperationException("roles may not be created or modified using a tribe node"));
            return;
        }
        try {
            this.client.prepareIndex(".security", ROLE_DOC_TYPE, role.getName()).setSource(role.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).setRefresh(request.refresh()).execute((ActionListener)new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse indexResponse) {
                    ESNativeRolesStore.this.clearRoleCache(role.getName(), listener, indexResponse.isCreated());
                }

                public void onFailure(Throwable e) {
                    ESNativeRolesStore.this.logger.error("failed to put role [{}]", e, new Object[]{request.name()});
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            this.logger.error("unable to put role [{}]", (Throwable)e, new Object[]{request.name()});
            listener.onFailure((Throwable)e);
        }
    }

    @Override
    public Permission.Global.Role role(String roleName) {
        if (this.state() != State.STARTED) {
            return null;
        }
        RoleAndVersion roleAndVersion = this.getRoleAndVersion(roleName);
        return roleAndVersion == null ? null : roleAndVersion.getRole();
    }

    private RoleAndVersion getRoleAndVersion(final String roleId) {
        final AtomicReference<Object> getRef = new AtomicReference<Object>(null);
        final CountDownLatch latch = new CountDownLatch(1);
        try {
            RoleAndVersion roleAndVersion = (RoleAndVersion)this.roleCache.get((Object)roleId, (Callable)new Callable<RoleAndVersion>(){

                @Override
                public RoleAndVersion call() throws Exception {
                    ESNativeRolesStore.this.logger.debug("attempting to load role [{}] from index", new Object[]{roleId});
                    ESNativeRolesStore.this.executeGetRoleRequest(roleId, (ActionListener<GetResponse>)new LatchedActionListener((ActionListener)new ActionListener<GetResponse>(){

                        public void onResponse(GetResponse role) {
                            getRef.set(role);
                        }

                        public void onFailure(Throwable t) {
                            if (t instanceof IndexNotFoundException) {
                                ESNativeRolesStore.this.logger.trace("failed to retrieve role [{}] since security index does not exist", t, new Object[]{roleId});
                            } else {
                                ESNativeRolesStore.this.logger.error("failed to retrieve role [{}]", t, new Object[]{roleId});
                            }
                        }
                    }, latch));
                    try {
                        latch.await(30L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        ESNativeRolesStore.this.logger.error("timed out retrieving role [{}]", new Object[]{roleId});
                    }
                    RoleDescriptor descriptor = null;
                    GetResponse response = (GetResponse)getRef.get();
                    if (response != null) {
                        descriptor = ESNativeRolesStore.this.transformRole(response);
                    }
                    if (descriptor == null) {
                        return RoleAndVersion.NON_EXISTENT;
                    }
                    ESNativeRolesStore.this.logger.debug("loaded role [{}] from index with version [{}]", new Object[]{roleId, response.getVersion()});
                    return new RoleAndVersion(descriptor, response.getVersion());
                }
            });
            if (roleAndVersion == RoleAndVersion.NON_EXISTENT) {
                return null;
            }
            return roleAndVersion;
        }
        catch (ExecutionException e) {
            this.logger.error("could not get or load value from cache for role [{}]", (Throwable)e, new Object[]{roleId});
            return null;
        }
    }

    void executeGetRoleRequest(String role, ActionListener<GetResponse> listener) {
        try {
            GetRequest request = (GetRequest)this.client.prepareGet(".security", ROLE_DOC_TYPE, role).request();
            this.client.get(request, listener);
        }
        catch (IndexNotFoundException e) {
            this.logger.trace("unable to retrieve role [{}] since security index does not exist", (Throwable)e, new Object[]{role});
            listener.onResponse((Object)new GetResponse(new GetResult(".security", ROLE_DOC_TYPE, role, -1L, false, null, null)));
        }
        catch (Exception e) {
            this.logger.error("unable to retrieve role", (Throwable)e, new Object[0]);
            listener.onFailure((Throwable)e);
        }
    }

    private void clearScollRequest(final String scrollId) {
        ClearScrollRequest clearScrollRequest = (ClearScrollRequest)this.client.prepareClearScroll().addScrollId(scrollId).request();
        this.client.clearScroll(clearScrollRequest, (ActionListener)new ActionListener<ClearScrollResponse>(){

            public void onResponse(ClearScrollResponse response) {
            }

            public void onFailure(Throwable t) {
                ESNativeRolesStore.this.logger.warn("failed to clear scroll [{}] after retrieving roles", t, new Object[]{scrollId});
            }
        });
    }

    public void reset() {
        State state = this.state();
        if (state != State.STOPPED && state != State.FAILED) {
            throw new IllegalStateException("can only reset if stopped!!!");
        }
        this.roleCache.invalidateAll();
        this.client = null;
        this.shieldIndexExists = false;
        this.state.set(State.INITIALIZED);
    }

    public void invalidateAll() {
        this.logger.debug("invalidating all roles in cache", new Object[0]);
        this.roleCache.invalidateAll();
    }

    public void invalidate(String role) {
        this.logger.debug("invalidating role [{}] in cache", new Object[]{role});
        this.roleCache.invalidate((Object)role);
    }

    private <Response> void clearRoleCache(final String role, final ActionListener<Response> listener, final Response response) {
        ClearRolesCacheRequest request = new ClearRolesCacheRequest().roles(role);
        this.shieldClient.clearRolesCache(request, new ActionListener<ClearRolesCacheResponse>(){

            public void onResponse(ClearRolesCacheResponse nodes) {
                if (nodes.hasFailures()) {
                    ArrayList<String> failedNodeIds = new ArrayList<String>();
                    for (ClearRolesCacheResponse.Node node : (ClearRolesCacheResponse.Node[])nodes.getNodes()) {
                        if (node.success()) continue;
                        failedNodeIds.add(node.id());
                    }
                    ESNativeRolesStore.this.logger.error("failed to clear roles cache for [{}] on nodes [{}]", new Object[]{role, failedNodeIds});
                }
                listener.onResponse(response);
            }

            public void onFailure(Throwable e) {
                ESNativeRolesStore.this.logger.error("unable to clear cache for role [{}]", e, new Object[]{role});
                ElasticsearchException exception = new ElasticsearchException("clearing the cache for [" + role + "] failed. please clear the role cache manually", e, new Object[0]);
                listener.onFailure((Throwable)exception);
            }
        });
    }

    public void clusterChanged(ClusterChangedEvent event) {
        boolean exists;
        boolean bl = exists = event.state().metaData().indices().get((Object)".security") != null;
        if (exists && event.state().routingTable().index(".security").allPrimaryShardsActive()) {
            this.logger.debug("security index [{}] all primary shards started, so polling can start", new Object[]{".security"});
            this.shieldIndexExists = true;
        } else {
            this.shieldIndexExists = false;
        }
    }

    public State state() {
        return this.state.get();
    }

    @Nullable
    private RoleDescriptor transformRole(GetResponse response) {
        if (!response.isExists()) {
            return null;
        }
        return this.transformRole(response.getId(), response.getSourceAsBytesRef());
    }

    @Nullable
    private RoleDescriptor transformRole(String name, BytesReference sourceBytes) {
        try {
            return RoleDescriptor.parse(name, sourceBytes);
        }
        catch (Exception e) {
            this.logger.error("error in the format of data for role [{}]", (Throwable)e, new Object[]{name});
            return null;
        }
    }

    private static class RoleAndVersion {
        private static final RoleAndVersion NON_EXISTENT = new RoleAndVersion();
        private final RoleDescriptor roleDescriptor;
        private final Permission.Global.Role role;
        private final long version;

        private RoleAndVersion() {
            this.roleDescriptor = null;
            this.role = null;
            this.version = Long.MIN_VALUE;
        }

        RoleAndVersion(RoleDescriptor roleDescriptor, long version) {
            Objects.requireNonNull(roleDescriptor);
            this.roleDescriptor = roleDescriptor;
            this.role = Permission.Global.Role.builder(roleDescriptor).build();
            this.version = version;
        }

        RoleDescriptor getRoleDescriptor() {
            return this.roleDescriptor;
        }

        Permission.Global.Role getRole() {
            return this.role;
        }

        long getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RoleAndVersion that = (RoleAndVersion)o;
            if (this.version != that.version) {
                return false;
            }
            return this.roleDescriptor.getName().equals(that.roleDescriptor.getName());
        }

        public int hashCode() {
            int result = this.roleDescriptor.hashCode();
            result = 31 * result + (int)(this.version ^ this.version >>> 32);
            return result;
        }
    }

    private class RolesStorePoller
    extends AbstractRunnable {
        private RolesStorePoller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRun() throws Exception {
            Client client = ESNativeRolesStore.this.client;
            if (this.isStopped()) {
                return;
            }
            if (!ESNativeRolesStore.this.shieldIndexExists) {
                ESNativeRolesStore.this.logger.trace("cannot poll for role changes since security index [{}] does not exist", new Object[]{".security"});
                return;
            }
            if (ESNativeRolesStore.this.roleCache.size() == 0L) {
                ESNativeRolesStore.this.logger.trace("role cache is empty. skipping execution of poller", new Object[0]);
                return;
            }
            ESNativeRolesStore.this.logger.trace("starting polling of roles index to check for changes", new Object[0]);
            SearchResponse response = null;
            HashSet existingKeys = new HashSet();
            HashSet negativeLookupKeys = new HashSet();
            for (Map.Entry entry : ESNativeRolesStore.this.roleCache.asMap().entrySet()) {
                existingKeys.add(entry.getKey());
                if (entry.getValue() != RoleAndVersion.NON_EXISTENT) continue;
                negativeLookupKeys.add(entry.getKey());
            }
            try {
                boolean keepScrolling;
                client.admin().indices().prepareRefresh(new String[]{".security"}).get();
                SearchRequest request = client.prepareSearch(new String[]{".security"}).setScroll(ESNativeRolesStore.this.scrollKeepAlive).setQuery((QueryBuilder)QueryBuilders.typeQuery((String)ESNativeRolesStore.ROLE_DOC_TYPE)).setSize(ESNativeRolesStore.this.scrollSize).setFetchSource(false).setVersion(true).request();
                response = (SearchResponse)client.search(request).get();
                boolean bl = keepScrolling = response.getHits().getHits().length > 0;
                while (keepScrolling) {
                    if (this.isStopped()) {
                        return;
                    }
                    for (SearchHit hit : response.getHits().getHits()) {
                        String roleName = hit.getId();
                        long version = hit.version();
                        boolean hadExisting = existingKeys.remove(roleName);
                        if (!hadExisting) {
                            ESNativeRolesStore.this.logger.trace("role [{}] wasn't in cache at start of polling. skipping checks", new Object[]{roleName});
                            continue;
                        }
                        RoleAndVersion existing = (RoleAndVersion)ESNativeRolesStore.this.roleCache.getIfPresent((Object)roleName);
                        if (existing == null) {
                            ESNativeRolesStore.this.logger.trace("role [{}] was in the cache at the start of polling but has been removed. skipping checks", new Object[]{roleName});
                            continue;
                        }
                        if (existing == RoleAndVersion.NON_EXISTENT) {
                            ESNativeRolesStore.this.roleCache.invalidate((Object)roleName);
                            continue;
                        }
                        if (version > existing.getVersion()) {
                            ESNativeRolesStore.this.logger.trace("removing role [{}] from cache with version [{}] since version [{}] is in index", new Object[]{roleName, existing.getVersion(), version});
                            ESNativeRolesStore.this.roleCache.invalidate((Object)roleName);
                            continue;
                        }
                        ESNativeRolesStore.this.logger.trace("role [{}] does not need to be updated. retrieved version [{}] existing version [{}]", new Object[]{roleName, version, existing.getVersion()});
                    }
                    keepScrolling = (response = (SearchResponse)client.prepareSearchScroll(response.getScrollId()).setScroll(ESNativeRolesStore.this.scrollKeepAlive).get()).getHits().getHits().length > 0;
                }
                existingKeys.removeAll(negativeLookupKeys);
                if (!existingKeys.isEmpty()) {
                    ESNativeRolesStore.this.logger.trace("removing roles {} from cache since they no longer exist in the index", new Object[]{existingKeys});
                    for (String roleName : existingKeys) {
                        ESNativeRolesStore.this.roleCache.invalidate((Object)roleName);
                    }
                }
            }
            catch (IndexNotFoundException e) {
                ESNativeRolesStore.this.logger.trace("security index does not exist", (Throwable)e, new Object[0]);
            }
            finally {
                if (response != null) {
                    ClearScrollRequest clearScrollRequest = (ClearScrollRequest)client.prepareClearScroll().addScrollId(response.getScrollId()).request();
                    client.clearScroll(clearScrollRequest).actionGet();
                }
            }
            ESNativeRolesStore.this.logger.trace("completed polling of roles index", new Object[0]);
        }

        public void onFailure(Throwable t) {
            ESNativeRolesStore.this.logger.error("error occurred while checking the native roles for changes", t, new Object[0]);
        }

        private boolean isStopped() {
            State state = ESNativeRolesStore.this.state();
            return state == State.STOPPED || state == State.STOPPING;
        }
    }

    public static enum State {
        INITIALIZED,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        FAILED;

    }
}

