/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authz;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.shield.support.Validation;
import org.elasticsearch.shield.support.XContentUtils;

public class RoleDescriptor
implements ToXContent {
    private final String name;
    private final String[] clusterPrivileges;
    private final IndicesPrivileges[] indicesPrivileges;
    private final String[] runAs;

    public RoleDescriptor(String name, @Nullable String[] clusterPrivileges, @Nullable IndicesPrivileges[] indicesPrivileges, @Nullable String[] runAs) {
        this.name = name;
        this.clusterPrivileges = clusterPrivileges != null ? clusterPrivileges : Strings.EMPTY_ARRAY;
        this.indicesPrivileges = indicesPrivileges != null ? indicesPrivileges : IndicesPrivileges.NONE;
        this.runAs = runAs != null ? runAs : Strings.EMPTY_ARRAY;
    }

    public String getName() {
        return this.name;
    }

    public String[] getClusterPrivileges() {
        return this.clusterPrivileges;
    }

    public IndicesPrivileges[] getIndicesPrivileges() {
        return this.indicesPrivileges;
    }

    public String[] getRunAs() {
        return this.runAs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Role[");
        sb.append("name=").append(this.name);
        sb.append(", cluster=[").append(Strings.arrayToCommaDelimitedString((Object[])this.clusterPrivileges));
        sb.append("], indicesPrivileges=[");
        for (IndicesPrivileges group : this.indicesPrivileges) {
            sb.append(group.toString()).append(",");
        }
        sb.append("], runAs=[").append(Strings.arrayToCommaDelimitedString((Object[])this.runAs));
        sb.append("]]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleDescriptor that = (RoleDescriptor)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!Arrays.equals(this.clusterPrivileges, that.clusterPrivileges)) {
            return false;
        }
        if (!Arrays.equals(this.indicesPrivileges, that.indicesPrivileges)) {
            return false;
        }
        return Arrays.equals(this.runAs, that.runAs);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + Arrays.hashCode(this.clusterPrivileges);
        result = 31 * result + Arrays.hashCode(this.indicesPrivileges);
        result = 31 * result + Arrays.hashCode(this.runAs);
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("cluster", (Object[])this.clusterPrivileges);
        builder.field("indices", (Object[])this.indicesPrivileges);
        if (this.runAs != null) {
            builder.field("run_as", this.runAs);
        }
        return builder.endObject();
    }

    public static RoleDescriptor readFrom(StreamInput in) throws IOException {
        String name = in.readString();
        String[] clusterPrivileges = in.readStringArray();
        int size = in.readVInt();
        IndicesPrivileges[] indicesPrivileges = new IndicesPrivileges[size];
        for (int i = 0; i < size; ++i) {
            indicesPrivileges[i] = IndicesPrivileges.createFrom(in);
        }
        String[] runAs = in.readStringArray();
        return new RoleDescriptor(name, clusterPrivileges, indicesPrivileges, runAs);
    }

    public static void writeTo(RoleDescriptor descriptor, StreamOutput out) throws IOException {
        out.writeString(descriptor.name);
        out.writeStringArray(descriptor.clusterPrivileges);
        out.writeVInt(descriptor.indicesPrivileges.length);
        for (IndicesPrivileges group : descriptor.indicesPrivileges) {
            group.writeTo(out);
        }
        out.writeStringArray(descriptor.runAs);
    }

    public static RoleDescriptor parse(String name, BytesReference source) throws Exception {
        assert (name != null);
        try (XContentParser parser = XContentHelper.createParser((BytesReference)source);){
            RoleDescriptor roleDescriptor = RoleDescriptor.parse(name, parser);
            return roleDescriptor;
        }
    }

    public static RoleDescriptor parse(String name, XContentParser parser) throws Exception {
        XContentParser.Token token;
        Validation.Error validationError = Validation.Roles.validateRoleName(name);
        if (validationError != null) {
            ValidationException ve = new ValidationException();
            ve.addValidationError(validationError.toString());
            throw ve;
        }
        XContentParser.Token token2 = token = parser.currentToken() == null ? parser.nextToken() : parser.currentToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("failed to parse role [{}]. expected an object but found [{}] instead", new Object[]{name, token});
        }
        String currentFieldName = null;
        IndicesPrivileges[] indicesPrivileges = null;
        String[] clusterPrivileges = null;
        String[] runAsUsers = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Fields.INDICES)) {
                indicesPrivileges = RoleDescriptor.parseIndices(name, parser);
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Fields.RUN_AS)) {
                runAsUsers = XContentUtils.readStringArray(parser, true);
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Fields.CLUSTER)) {
                clusterPrivileges = XContentUtils.readStringArray(parser, true);
                continue;
            }
            throw new ElasticsearchParseException("failed to parse role [{}]. unexpected field [{}]", new Object[]{name, currentFieldName});
        }
        return new RoleDescriptor(name, clusterPrivileges, indicesPrivileges, runAsUsers);
    }

    public static IndicesPrivileges[] parseIndices(String roleName, XContentParser parser) throws Exception {
        XContentParser.Token token;
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. expected field [{}] value to be an array, but found [{}] instead", new Object[]{roleName, parser.currentName(), parser.currentToken()});
        }
        ArrayList<IndicesPrivileges> privileges = new ArrayList<IndicesPrivileges>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            privileges.add(RoleDescriptor.parseIndex(roleName, parser));
        }
        return privileges.toArray(new IndicesPrivileges[privileges.size()]);
    }

    private static IndicesPrivileges parseIndex(String roleName, XContentParser parser) throws Exception {
        XContentParser.Token token = parser.currentToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. expected field [{}] value to be an array of objects, but found an array element of type [{}]", new Object[]{roleName, parser.currentName(), token});
        }
        String currentFieldName = null;
        String[] names = null;
        String query = null;
        String[] privileges = null;
        String[] fields = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Fields.NAMES)) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    names = new String[]{parser.text()};
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    names = XContentUtils.readStringArray(parser, false);
                    if (names.length != 0) continue;
                    throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. [{}] cannot be an empty array", new Object[]{roleName, currentFieldName});
                }
                throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. expected field [{}] value to be a string or an array of strings, but found [{}] instead", new Object[]{roleName, currentFieldName, token});
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Fields.QUERY)) {
                if (token == XContentParser.Token.START_OBJECT) {
                    XContentBuilder builder = JsonXContent.contentBuilder();
                    XContentHelper.copyCurrentStructure((XContentGenerator)builder.generator(), (XContentParser)parser);
                    query = builder.string();
                    continue;
                }
                query = parser.textOrNull();
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Fields.PRIVILEGES)) {
                privileges = XContentUtils.readStringArray(parser, false);
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Fields.FIELDS)) {
                fields = XContentUtils.readStringArray(parser, true);
                continue;
            }
            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. unexpected field [{}]", new Object[]{roleName, currentFieldName});
        }
        if (names == null) {
            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. missing required [{}] field", new Object[]{roleName, Fields.NAMES.getPreferredName()});
        }
        if (privileges == null) {
            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. missing required [{}] field", new Object[]{roleName, Fields.PRIVILEGES.getPreferredName()});
        }
        return IndicesPrivileges.builder().indices(names).privileges(privileges).fields(fields).query(query).build();
    }

    public static interface Fields {
        public static final ParseField CLUSTER = new ParseField("cluster", new String[0]);
        public static final ParseField INDICES = new ParseField("indices", new String[0]);
        public static final ParseField RUN_AS = new ParseField("run_as", new String[0]);
        public static final ParseField NAMES = new ParseField("names", new String[0]);
        public static final ParseField QUERY = new ParseField("query", new String[0]);
        public static final ParseField PRIVILEGES = new ParseField("privileges", new String[0]);
        public static final ParseField FIELDS = new ParseField("fields", new String[0]);
    }

    public static class IndicesPrivileges
    implements ToXContent,
    Streamable {
        private static final IndicesPrivileges[] NONE = new IndicesPrivileges[0];
        private String[] indices;
        private String[] privileges;
        private String[] fields;
        private BytesReference query;

        protected IndicesPrivileges() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public String[] getIndices() {
            return this.indices;
        }

        public String[] getPrivileges() {
            return this.privileges;
        }

        @Nullable
        public String[] getFields() {
            return this.fields;
        }

        @Nullable
        public BytesReference getQuery() {
            return this.query;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("IndicesPrivileges[");
            sb.append("indices=[").append(Strings.arrayToCommaDelimitedString((Object[])this.indices));
            sb.append("], privileges=[").append(Strings.arrayToCommaDelimitedString((Object[])this.privileges));
            sb.append("], fields=[").append(Strings.arrayToCommaDelimitedString((Object[])this.fields));
            if (this.query != null) {
                sb.append("], query=").append(this.query.toUtf8());
            }
            sb.append("]");
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndicesPrivileges that = (IndicesPrivileges)o;
            if (!Arrays.equals(this.indices, that.indices)) {
                return false;
            }
            if (!Arrays.equals(this.privileges, that.privileges)) {
                return false;
            }
            if (!Arrays.equals(this.fields, that.fields)) {
                return false;
            }
            return !(this.query == null ? that.query != null : !this.query.equals(that.query));
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.indices);
            result = 31 * result + Arrays.hashCode(this.privileges);
            result = 31 * result + Arrays.hashCode(this.fields);
            result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
            return result;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.array("names", this.indices);
            builder.array("privileges", this.privileges);
            if (this.fields != null) {
                builder.array("fields", this.fields);
            }
            if (this.query != null) {
                builder.field("query", this.query.toUtf8());
            }
            return builder.endObject();
        }

        public static IndicesPrivileges createFrom(StreamInput in) throws IOException {
            IndicesPrivileges ip = new IndicesPrivileges();
            ip.readFrom(in);
            return ip;
        }

        public void readFrom(StreamInput in) throws IOException {
            this.indices = in.readStringArray();
            this.privileges = in.readStringArray();
            this.fields = in.readBoolean() ? in.readStringArray() : null;
            if (in.readBoolean()) {
                this.query = new BytesArray(in.readByteArray());
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringArray(this.indices);
            out.writeStringArray(this.privileges);
            if (this.fields != null) {
                out.writeBoolean(true);
                out.writeStringArray(this.fields);
            } else {
                out.writeBoolean(false);
            }
            if (this.query != null) {
                out.writeBoolean(true);
                out.writeByteArray(this.query.array());
            } else {
                out.writeBoolean(false);
            }
        }

        static /* synthetic */ String[] access$202(IndicesPrivileges x0, String[] x1) {
            x0.indices = x1;
            return x1;
        }

        static /* synthetic */ String[] access$302(IndicesPrivileges x0, String[] x1) {
            x0.privileges = x1;
            return x1;
        }

        static /* synthetic */ String[] access$402(IndicesPrivileges x0, String[] x1) {
            x0.fields = x1;
            return x1;
        }

        public static class Builder {
            private IndicesPrivileges indicesPrivileges = new IndicesPrivileges();

            private Builder() {
            }

            public Builder indices(String ... indices) {
                IndicesPrivileges.access$202(this.indicesPrivileges, indices);
                return this;
            }

            public Builder privileges(String ... privileges) {
                IndicesPrivileges.access$302(this.indicesPrivileges, privileges);
                return this;
            }

            public Builder fields(String ... fields) {
                IndicesPrivileges.access$402(this.indicesPrivileges, fields);
                return this;
            }

            public Builder query(@Nullable String query) {
                return this.query((BytesReference)(query == null ? null : new BytesArray(query)));
            }

            public Builder query(@Nullable BytesReference query) {
                this.indicesPrivileges.query = query;
                return this;
            }

            public IndicesPrivileges build() {
                if (this.indicesPrivileges.indices == null || this.indicesPrivileges.indices.length == 0) {
                    throw new IllegalArgumentException("indices privileges must refer to at least one index name or index name pattern");
                }
                if (this.indicesPrivileges.privileges == null || this.indicesPrivileges.privileges.length == 0) {
                    throw new IllegalArgumentException("indices privileges must define at least one privilege");
                }
                return this.indicesPrivileges;
            }
        }
    }
}

