/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authz;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.shield.authz.Privilege;
import org.elasticsearch.shield.authz.RoleDescriptor;
import org.elasticsearch.shield.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.shield.support.AutomatonPredicate;
import org.elasticsearch.shield.support.Automatons;

public interface Permission {
    public boolean isEmpty();

    public static interface RunAs
    extends Permission {
        public boolean check(String var1);

        public static class Globals
        implements RunAs {
            private final List<Global> globals;

            public Globals(List<Global> globals) {
                this.globals = globals;
            }

            @Override
            public boolean check(String username) {
                if (this.globals == null) {
                    return false;
                }
                for (Global global : this.globals) {
                    if (!global.runAs().check(username)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean isEmpty() {
                if (this.globals == null || this.globals.isEmpty()) {
                    return true;
                }
                for (Global global : this.globals) {
                    if (global.isEmpty()) continue;
                    return false;
                }
                return true;
            }
        }

        public static class Core
        implements RunAs {
            public static final Core NONE = new Core(Privilege.General.NONE);
            private final Privilege.General privilege;
            private final Predicate<String> predicate;

            public Core(Privilege.General privilege) {
                this.privilege = privilege;
                this.predicate = privilege.predicate();
            }

            @Override
            public boolean check(String username) {
                return this.predicate.apply((Object)username);
            }

            @Override
            public boolean isEmpty() {
                return this == NONE;
            }
        }
    }

    public static interface Indices
    extends Permission,
    Iterable<Group> {
        public ImmutableMap<String, IndicesAccessControl.IndexAccessControl> authorize(String var1, Set<String> var2, MetaData var3);

        public Predicate<String> allowedIndicesMatcher(String var1);

        public static class Group {
            private final Privilege.Index privilege;
            private final Predicate<String> actionMatcher;
            private final String[] indices;
            private final Predicate<String> indexNameMatcher;
            private final List<String> fields;
            private final BytesReference query;

            public Group(Privilege.Index privilege, @Nullable List<String> fields, @Nullable BytesReference query, String ... indices) {
                assert (indices.length != 0);
                this.privilege = privilege;
                this.actionMatcher = privilege.predicate();
                this.indices = indices;
                this.indexNameMatcher = new AutomatonPredicate(Automatons.patterns(indices));
                this.fields = fields;
                this.query = query;
            }

            public Privilege.Index privilege() {
                return this.privilege;
            }

            public String[] indices() {
                return this.indices;
            }

            @Nullable
            public List<String> getFields() {
                return this.fields;
            }

            @Nullable
            public BytesReference getQuery() {
                return this.query;
            }

            public boolean indexNameMatch(String index) {
                return this.indexNameMatcher.apply((Object)index);
            }

            public boolean check(String action, String index) {
                assert (index != null);
                return this.actionMatcher.apply((Object)action) && this.indexNameMatcher.apply((Object)index);
            }
        }

        public static class Globals
        implements Indices {
            private final List<Global> globals;

            public Globals(List<Global> globals) {
                this.globals = globals;
            }

            @Override
            public Iterator<Group> iterator() {
                return this.globals == null || this.globals.isEmpty() ? Collections.emptyIterator() : new Iter(this.globals);
            }

            @Override
            public boolean isEmpty() {
                if (this.globals == null || this.globals.isEmpty()) {
                    return true;
                }
                for (Global global : this.globals) {
                    if (global.indices().isEmpty()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public ImmutableMap<String, IndicesAccessControl.IndexAccessControl> authorize(String action, Set<String> requestedIndicesOrAliases, MetaData metaData) {
                if (this.isEmpty()) {
                    return ImmutableMap.of();
                }
                HashMap<String, IndicesAccessControl.IndexAccessControl> indicesAccessControl = null;
                for (Global permission : this.globals) {
                    ImmutableMap<String, IndicesAccessControl.IndexAccessControl> temp = permission.indices().authorize(action, requestedIndicesOrAliases, metaData);
                    if (indicesAccessControl == null) {
                        indicesAccessControl = new HashMap<String, IndicesAccessControl.IndexAccessControl>((Map<String, IndicesAccessControl.IndexAccessControl>)temp);
                        continue;
                    }
                    for (Map.Entry entry : temp.entrySet()) {
                        IndicesAccessControl.IndexAccessControl existing = (IndicesAccessControl.IndexAccessControl)indicesAccessControl.get(entry.getKey());
                        if (existing != null) {
                            indicesAccessControl.put((String)entry.getKey(), existing.merge((IndicesAccessControl.IndexAccessControl)entry.getValue()));
                            continue;
                        }
                        indicesAccessControl.put((String)entry.getKey(), (IndicesAccessControl.IndexAccessControl)entry.getValue());
                    }
                }
                if (indicesAccessControl == null) {
                    return ImmutableMap.of();
                }
                return ImmutableMap.copyOf(indicesAccessControl);
            }

            @Override
            public Predicate<String> allowedIndicesMatcher(final String action) {
                if (this.isEmpty()) {
                    return Predicates.alwaysFalse();
                }
                return new Predicate<String>(){

                    public boolean apply(String index) {
                        for (Global permission : Globals.this.globals) {
                            if (!permission.indices().allowedIndicesMatcher(action).apply((Object)index)) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }

            static class Iter
            extends UnmodifiableIterator<Group> {
                private final Iterator<Global> globals;
                private Iterator<Group> current;

                Iter(List<Global> globals) {
                    this.globals = globals.iterator();
                    this.advance();
                }

                public boolean hasNext() {
                    return this.current != null && this.current.hasNext();
                }

                public Group next() {
                    Group group = this.current.next();
                    this.advance();
                    return group;
                }

                private void advance() {
                    if (this.current != null && this.current.hasNext()) {
                        return;
                    }
                    if (!this.globals.hasNext()) {
                        this.current = null;
                        return;
                    }
                    while (this.globals.hasNext()) {
                        Indices indices = this.globals.next().indices();
                        if (indices.isEmpty()) continue;
                        this.current = indices.iterator();
                        return;
                    }
                    this.current = null;
                }
            }
        }

        public static class Core
        implements Indices {
            public static final Core NONE = new Core(new Group[0]){

                @Override
                public Iterator<Group> iterator() {
                    return Collections.emptyIterator();
                }

                @Override
                public boolean isEmpty() {
                    return true;
                }
            };
            private final LoadingCache<String, Predicate<String>> allowedIndicesMatchersForAction = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Predicate<String>>(){

                public Predicate<String> load(String action) throws Exception {
                    ArrayList<String> indices = new ArrayList<String>();
                    for (Group group : Core.this.groups) {
                        if (!group.actionMatcher.apply((Object)action)) continue;
                        indices.addAll(Arrays.asList(group.indices));
                    }
                    return new AutomatonPredicate(Automatons.patterns(Collections.unmodifiableList(indices)));
                }
            });
            private final Group[] groups;

            public Core(Group ... groups) {
                this.groups = groups;
            }

            @Override
            public Iterator<Group> iterator() {
                return Iterators.forArray((Object[])this.groups);
            }

            public Group[] groups() {
                return this.groups;
            }

            @Override
            public boolean isEmpty() {
                return this.groups == null || this.groups.length == 0;
            }

            @Override
            public Predicate<String> allowedIndicesMatcher(String action) {
                return (Predicate)this.allowedIndicesMatchersForAction.getUnchecked((Object)action);
            }

            @Override
            public ImmutableMap<String, IndicesAccessControl.IndexAccessControl> authorize(String action, Set<String> requestedIndicesOrAliases, MetaData metaData) {
                SortedMap allAliasesAndIndices = metaData.getAliasAndIndexLookup();
                HashMap<String, ImmutableSet.Builder> fieldsBuilder = new HashMap<String, ImmutableSet.Builder>();
                HashMap<String, ImmutableSet.Builder> queryBuilder = new HashMap<String, ImmutableSet.Builder>();
                HashMap<String, Boolean> grantedBuilder = new HashMap<String, Boolean>();
                for (String indexOrAlias : requestedIndicesOrAliases) {
                    boolean granted = false;
                    HashSet<String> concreteIndices = new HashSet<String>();
                    AliasOrIndex aliasOrIndex = (AliasOrIndex)allAliasesAndIndices.get(indexOrAlias);
                    if (aliasOrIndex != null) {
                        for (IndexMetaData indexMetaData : aliasOrIndex.getIndices()) {
                            concreteIndices.add(indexMetaData.getIndex());
                        }
                    }
                    for (Group group : this.groups) {
                        if (!group.check(action, indexOrAlias)) continue;
                        granted = true;
                        for (String index : concreteIndices) {
                            if (group.getFields() != null) {
                                ImmutableSet.Builder roleFieldsBuilder = (ImmutableSet.Builder)fieldsBuilder.get(index);
                                if (roleFieldsBuilder == null) {
                                    roleFieldsBuilder = ImmutableSet.builder();
                                    fieldsBuilder.put(index, roleFieldsBuilder);
                                }
                                roleFieldsBuilder.addAll(group.getFields());
                            }
                            if (group.getQuery() == null) continue;
                            ImmutableSet.Builder roleQueriesBuilder = (ImmutableSet.Builder)queryBuilder.get(index);
                            if (roleQueriesBuilder == null) {
                                roleQueriesBuilder = ImmutableSet.builder();
                                queryBuilder.put(index, roleQueriesBuilder);
                            }
                            roleQueriesBuilder.add((Object)group.getQuery());
                        }
                    }
                    if (concreteIndices.isEmpty()) {
                        grantedBuilder.put(indexOrAlias, granted);
                        continue;
                    }
                    for (String concreteIndex : concreteIndices) {
                        grantedBuilder.put(concreteIndex, granted);
                    }
                }
                ImmutableMap.Builder indexPermissions = ImmutableMap.builder();
                for (Map.Entry entry : grantedBuilder.entrySet()) {
                    String index = (String)entry.getKey();
                    ImmutableSet.Builder roleQueriesBuilder = (ImmutableSet.Builder)queryBuilder.get(index);
                    ImmutableSet.Builder roleFieldsBuilder = (ImmutableSet.Builder)fieldsBuilder.get(index);
                    ImmutableSet roleFields = roleFieldsBuilder != null ? roleFieldsBuilder.build() : null;
                    ImmutableSet roleQueries = roleQueriesBuilder != null ? roleQueriesBuilder.build() : null;
                    indexPermissions.put((Object)index, (Object)new IndicesAccessControl.IndexAccessControl((Boolean)entry.getValue(), (ImmutableSet<String>)roleFields, (ImmutableSet<BytesReference>)roleQueries));
                }
                return indexPermissions.build();
            }
        }
    }

    public static interface Cluster
    extends Permission {
        public boolean check(String var1);

        public static class Globals
        implements Cluster {
            private final List<Global> globals;

            public Globals(List<Global> globals) {
                this.globals = globals;
            }

            @Override
            public boolean check(String action) {
                if (this.globals == null) {
                    return false;
                }
                for (Global global : this.globals) {
                    if (!global.cluster().check(action)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean isEmpty() {
                if (this.globals == null || this.globals.isEmpty()) {
                    return true;
                }
                for (Global global : this.globals) {
                    if (global.isEmpty()) continue;
                    return false;
                }
                return true;
            }
        }

        public static class Core
        implements Cluster {
            public static final Core NONE = new Core(Privilege.Cluster.NONE){

                @Override
                public boolean check(String action) {
                    return false;
                }

                @Override
                public boolean isEmpty() {
                    return true;
                }
            };
            private final Privilege.Cluster privilege;
            private final Predicate<String> predicate;

            private Core(Privilege.Cluster privilege) {
                this.privilege = privilege;
                this.predicate = privilege.predicate();
            }

            public Privilege.Cluster privilege() {
                return this.privilege;
            }

            @Override
            public boolean check(String action) {
                return this.predicate.apply((Object)action);
            }

            @Override
            public boolean isEmpty() {
                return false;
            }
        }
    }

    public static class Global
    implements Permission {
        public static final Global NONE = new Global(Cluster.Core.NONE, Indices.Core.NONE, RunAs.Core.NONE);
        private final Cluster cluster;
        private final Indices indices;
        private final RunAs runAs;

        Global(Cluster cluster, Indices indices, RunAs runAs) {
            this.cluster = cluster;
            this.indices = indices;
            this.runAs = runAs;
        }

        public Cluster cluster() {
            return this.cluster;
        }

        public Indices indices() {
            return this.indices;
        }

        public RunAs runAs() {
            return this.runAs;
        }

        @Override
        public boolean isEmpty() {
            return !(this.cluster != null && !this.cluster.isEmpty() || this.indices != null && !this.indices.isEmpty() || this.runAs != null && !this.runAs.isEmpty());
        }

        public IndicesAccessControl authorize(String action, Set<String> requestedIndicesOrAliases, MetaData metaData) {
            ImmutableMap<String, IndicesAccessControl.IndexAccessControl> indexPermissions = this.indices.authorize(action, requestedIndicesOrAliases, metaData);
            boolean granted = true;
            for (Map.Entry entry : indexPermissions.entrySet()) {
                if (((IndicesAccessControl.IndexAccessControl)entry.getValue()).isGranted()) continue;
                granted = false;
                break;
            }
            return new IndicesAccessControl(granted, indexPermissions);
        }

        static class Compound
        extends Global {
            public Compound(List<Global> globals) {
                super(new Cluster.Globals(globals), new Indices.Globals(globals), new RunAs.Globals(globals));
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private List<Global> globals = new ArrayList<Global>();

                private Builder() {
                }

                public Builder add(Global global) {
                    this.globals.add(global);
                    return this;
                }

                public Compound build() {
                    return new Compound(Collections.unmodifiableList(this.globals));
                }
            }
        }

        public static class Role
        extends Global {
            private final String name;

            private Role(String name, Cluster.Core cluster, Indices.Core indices, RunAs.Core runAs) {
                super(cluster, indices, runAs);
                this.name = name;
            }

            public String name() {
                return this.name;
            }

            @Override
            public Cluster.Core cluster() {
                return (Cluster.Core)super.cluster();
            }

            @Override
            public Indices.Core indices() {
                return (Indices.Core)super.indices();
            }

            @Override
            public RunAs.Core runAs() {
                return (RunAs.Core)super.runAs();
            }

            public static Builder builder(String name) {
                return new Builder(name);
            }

            public static Builder builder(RoleDescriptor rd) {
                return new Builder(rd);
            }

            public static class Builder {
                private final String name;
                private Cluster.Core cluster = Cluster.Core.NONE;
                private RunAs.Core runAs = RunAs.Core.NONE;
                private List<Indices.Group> groups = new ArrayList<Indices.Group>();

                private Builder(String name) {
                    this.name = name;
                }

                private Builder(RoleDescriptor rd) {
                    this.name = rd.getName();
                    if (rd.getClusterPrivileges().length == 0) {
                        this.cluster(Privilege.Cluster.NONE);
                    } else {
                        this.cluster(Privilege.Cluster.get(new Privilege.Name(rd.getClusterPrivileges())));
                    }
                    for (RoleDescriptor.IndicesPrivileges iGroup : rd.getIndicesPrivileges()) {
                        this.add(iGroup.getFields() == null ? null : Arrays.asList(iGroup.getFields()), iGroup.getQuery(), Privilege.Index.get(new Privilege.Name(iGroup.getPrivileges())), iGroup.getIndices());
                    }
                    String[] rdRunAs = rd.getRunAs();
                    if (rdRunAs != null && rdRunAs.length > 0) {
                        this.runAs(new Privilege.General(new Privilege.Name(rdRunAs), rdRunAs));
                    }
                }

                public Builder cluster(Privilege.Cluster privilege) {
                    this.cluster = new Cluster.Core(privilege);
                    return this;
                }

                public Builder runAs(Privilege.General privilege) {
                    this.runAs = new RunAs.Core(privilege);
                    return this;
                }

                public Builder add(Privilege.Index privilege, String ... indices) {
                    this.groups.add(new Indices.Group(privilege, null, null, indices));
                    return this;
                }

                public Builder add(List<String> fields, BytesReference query, Privilege.Index privilege, String ... indices) {
                    this.groups.add(new Indices.Group(privilege, fields, query, indices));
                    return this;
                }

                public Role build() {
                    Indices.Core indices = this.groups.isEmpty() ? Indices.Core.NONE : new Indices.Core(this.groups.toArray(new Indices.Group[this.groups.size()]));
                    return new Role(this.name, this.cluster, indices, this.runAs);
                }
            }
        }
    }
}

