/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.support;

import java.nio.CharBuffer;
import java.util.Arrays;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.shield.authc.support.CharArrays;

public class SecuredString
implements CharSequence {
    public static final SecuredString EMPTY = new SecuredString(new char[0]);
    private final char[] chars;
    private boolean cleared = false;

    public SecuredString(char[] chars) {
        this.chars = new char[chars.length];
        System.arraycopy(chars, 0, this.chars, 0, chars.length);
    }

    private SecuredString(char[] chars, int start, int end) {
        this.chars = new char[end - start];
        System.arraycopy(chars, start, this.chars, 0, this.chars.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this == EMPTY || o == EMPTY) {
            return false;
        }
        if (o instanceof SecuredString) {
            SecuredString that = (SecuredString)o;
            if (this.cleared != that.cleared) {
                return false;
            }
            return Arrays.equals(this.chars, that.chars);
        }
        if (o instanceof CharSequence) {
            CharSequence that = (CharSequence)o;
            if (this.cleared) {
                return false;
            }
            if (this.chars.length != that.length()) {
                return false;
            }
            for (int i = 0; i < this.chars.length; ++i) {
                if (this.chars[i] == that.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.chars);
        result = 31 * result + (this.cleared ? 1 : 0);
        return result;
    }

    public char[] internalChars() {
        this.throwIfCleared();
        return this.chars;
    }

    public char[] copyChars() {
        return Arrays.copyOf(this.chars, this.chars.length);
    }

    public byte[] utf8Bytes() {
        this.throwIfCleared();
        return CharArrays.toUtf8Bytes(this.chars);
    }

    @Override
    public int length() {
        this.throwIfCleared();
        return this.chars.length;
    }

    @Override
    public char charAt(int index) {
        this.throwIfCleared();
        return this.chars[index];
    }

    @Override
    public SecuredString subSequence(int start, int end) {
        this.throwIfCleared();
        return new SecuredString(this.chars, start, end);
    }

    public void clear() {
        this.cleared = true;
        Arrays.fill(this.chars, '\u0000');
    }

    public SecuredString concat(CharSequence toAppend) {
        this.throwIfCleared();
        CharBuffer buffer = CharBuffer.allocate(this.chars.length + toAppend.length());
        buffer.put(this.chars);
        for (int i = 0; i < toAppend.length(); ++i) {
            buffer.put(i + this.chars.length, toAppend.charAt(i));
        }
        return new SecuredString(buffer.array());
    }

    private void throwIfCleared() {
        if (this.cleared) {
            throw new ElasticsearchException("attempt to use cleared password", new Object[0]);
        }
    }

    public static boolean constantTimeEquals(String a, String b) {
        char[] aChars = a.toCharArray();
        char[] bChars = b.toCharArray();
        return SecuredString.constantTimeEquals(aChars, bChars);
    }

    public static boolean constantTimeEquals(SecuredString securedString, String string) {
        return SecuredString.constantTimeEquals(securedString.internalChars(), string.toCharArray());
    }

    public static boolean constantTimeEquals(SecuredString securedString, SecuredString otherString) {
        return SecuredString.constantTimeEquals(securedString.internalChars(), otherString.internalChars());
    }

    public static boolean constantTimeEquals(char[] a, char[] b) {
        if (a.length != b.length) {
            return false;
        }
        int equals = 0;
        for (int i = 0; i < a.length; ++i) {
            equals |= a[i] ^ b[i];
        }
        return equals == 0;
    }
}

