/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.ldap.support;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.util.ssl.HostNameSSLSocketVerifier;
import com.unboundid.util.ssl.SSLSocketVerifier;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSocketFactory;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.shield.authc.RealmConfig;
import org.elasticsearch.shield.authc.ldap.support.LdapLoadBalancing;
import org.elasticsearch.shield.authc.ldap.support.LdapSession;
import org.elasticsearch.shield.authc.support.SecuredString;
import org.elasticsearch.shield.ssl.ClientSSLService;

public abstract class SessionFactory {
    public static final String URLS_SETTING = "url";
    public static final String TIMEOUT_TCP_CONNECTION_SETTING = "timeout.tcp_connect";
    public static final String TIMEOUT_TCP_READ_SETTING = "timeout.tcp_read";
    public static final String TIMEOUT_LDAP_SETTING = "timeout.ldap_search";
    public static final String HOSTNAME_VERIFICATION_SETTING = "hostname_verification";
    public static final String FOLLOW_REFERRALS_SETTING = "follow_referrals";
    public static final TimeValue TIMEOUT_DEFAULT = TimeValue.timeValueSeconds((long)5L);
    private static final Pattern STARTS_WITH_LDAPS = Pattern.compile("^ldaps:.*", 2);
    private static final Pattern STARTS_WITH_LDAP = Pattern.compile("^ldap:.*", 2);
    protected final ESLogger logger;
    protected final ESLogger connectionLogger;
    protected final RealmConfig config;
    protected final TimeValue timeout;
    protected final ClientSSLService sslService;
    protected ServerSet serverSet;

    protected SessionFactory(RealmConfig config, ClientSSLService sslService) {
        this.config = config;
        this.logger = config.logger(this.getClass());
        this.connectionLogger = config.logger(this.getClass());
        TimeValue searchTimeout = config.settings().getAsTime(TIMEOUT_LDAP_SETTING, TIMEOUT_DEFAULT);
        if (searchTimeout.millis() < 1000L) {
            this.logger.warn("ldap_search timeout [{}] is less than the minimum supported search timeout of 1s. using 1s", new Object[]{searchTimeout.millis()});
            searchTimeout = TimeValue.timeValueSeconds((long)1L);
        }
        this.timeout = searchTimeout;
        this.sslService = sslService;
    }

    public final LdapSession session(String user, SecuredString password) throws Exception {
        if (this.serverSet == null) {
            throw new IllegalStateException("session factory is not initialized");
        }
        return this.getSession(user, password);
    }

    protected abstract LdapSession getSession(String var1, SecuredString var2) throws Exception;

    public boolean supportsUnauthenticatedSession() {
        return false;
    }

    public LdapSession unauthenticatedSession(String username) throws Exception {
        throw new UnsupportedOperationException("unauthenticated sessions are not supported");
    }

    public <T extends SessionFactory> T init() {
        this.serverSet = this.serverSet(this.config.settings(), this.sslService, this.ldapServers(this.config.settings()));
        return (T)this;
    }

    protected static LDAPConnectionOptions connectionOptions(Settings settings) {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setConnectTimeoutMillis(Ints.checkedCast((long)settings.getAsTime(TIMEOUT_TCP_CONNECTION_SETTING, TIMEOUT_DEFAULT).millis()));
        options.setFollowReferrals(settings.getAsBoolean(FOLLOW_REFERRALS_SETTING, Boolean.valueOf(true)).booleanValue());
        options.setResponseTimeoutMillis(settings.getAsTime(TIMEOUT_TCP_READ_SETTING, TIMEOUT_DEFAULT).millis());
        options.setAutoReconnect(true);
        options.setAllowConcurrentSocketFactoryUse(true);
        if (settings.getAsBoolean(HOSTNAME_VERIFICATION_SETTING, Boolean.valueOf(true)).booleanValue()) {
            options.setSSLSocketVerifier((SSLSocketVerifier)new HostNameSSLSocketVerifier(true));
        }
        return options;
    }

    protected LDAPServers ldapServers(Settings settings) {
        String[] ldapUrls = settings.getAsArray(URLS_SETTING);
        if (ldapUrls == null || ldapUrls.length == 0) {
            throw new IllegalArgumentException("missing required LDAP setting [url]");
        }
        return new LDAPServers(ldapUrls);
    }

    protected ServerSet serverSet(Settings settings, ClientSSLService clientSSLService, LDAPServers ldapServers) {
        SSLSocketFactory socketFactory = null;
        if (ldapServers.ssl()) {
            socketFactory = clientSSLService.sslSocketFactory();
            if (settings.getAsBoolean(HOSTNAME_VERIFICATION_SETTING, Boolean.valueOf(true)).booleanValue()) {
                this.logger.debug("using encryption for LDAP connections with hostname verification", new Object[0]);
            } else {
                this.logger.debug("using encryption for LDAP connections without hostname verification", new Object[0]);
            }
        }
        return LdapLoadBalancing.serverSet(ldapServers.addresses(), ldapServers.ports(), settings, socketFactory, SessionFactory.connectionOptions(settings));
    }

    ServerSet getServerSet() {
        return this.serverSet;
    }

    public static class LDAPServers {
        private final String[] addresses;
        private final int[] ports;
        private final boolean ssl;

        public LDAPServers(String[] urls) {
            this.ssl = this.secureUrls(urls);
            this.addresses = new String[urls.length];
            this.ports = new int[urls.length];
            for (int i = 0; i < urls.length; ++i) {
                try {
                    LDAPURL url = new LDAPURL(urls[i]);
                    this.addresses[i] = url.getHost();
                    this.ports[i] = url.getPort();
                    continue;
                }
                catch (LDAPException e) {
                    throw new IllegalArgumentException("unable to parse configured LDAP url [" + urls[i] + "]", e);
                }
            }
        }

        public String[] addresses() {
            return this.addresses;
        }

        public int[] ports() {
            return this.ports;
        }

        public boolean ssl() {
            return this.ssl;
        }

        private boolean secureUrls(String[] ldapUrls) {
            if (ldapUrls.length == 0) {
                return true;
            }
            boolean allSecure = Iterables.all(Arrays.asList(ldapUrls), (Predicate)Predicates.contains((Pattern)STARTS_WITH_LDAPS));
            boolean allClear = Iterables.all(Arrays.asList(ldapUrls), (Predicate)Predicates.contains((Pattern)STARTS_WITH_LDAP));
            if (!allSecure && !allClear) {
                throw new IllegalArgumentException("configured LDAP protocols are not all equal (ldaps://.. and ldap://..): [" + Strings.arrayToCommaDelimitedString((Object[])ldapUrls) + "]");
            }
            return allSecure;
        }
    }
}

