/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.ldap.support;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import javax.naming.ldap.Rdn;
import org.elasticsearch.common.logging.ESLogger;

public final class LdapUtils {
    public static final Filter OBJECT_CLASS_PRESENCE_FILTER = Filter.createPresenceFilter((String)"objectClass");

    private LdapUtils() {
    }

    public static DN dn(String dn) {
        try {
            return new DN(dn);
        }
        catch (LDAPException e) {
            throw new IllegalArgumentException("invalid DN [" + dn + "]", e);
        }
    }

    public static String relativeName(DN dn) {
        return dn.getRDNString().split("=")[1].trim();
    }

    public static String escapedRDNValue(String rdn) {
        return Rdn.escapeValue(rdn);
    }

    public static SearchResult search(LDAPInterface ldap, SearchRequest searchRequest, ESLogger logger) throws LDAPException {
        SearchResult results;
        try {
            results = ldap.search(searchRequest);
        }
        catch (LDAPSearchException e) {
            if (e.getResultCode().equals((Object)ResultCode.REFERRAL) && e.getSearchResult() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("a referral could not be followed for request [{}] so some results may not have been retrieved", (Throwable)e, new Object[]{searchRequest});
                }
                results = e.getSearchResult();
            }
            throw e;
        }
        return results;
    }

    public static SearchResultEntry searchForEntry(LDAPInterface ldap, SearchRequest searchRequest, ESLogger logger) throws LDAPException {
        SearchResultEntry entry;
        try {
            entry = ldap.searchForEntry(searchRequest);
        }
        catch (LDAPSearchException e) {
            if (e.getResultCode().equals((Object)ResultCode.REFERRAL) && e.getSearchResult() != null && e.getSearchResult().getEntryCount() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("a referral could not be followed for request [{}] so some results may not have been retrieved", (Throwable)e, new Object[]{searchRequest});
                }
                entry = (SearchResultEntry)e.getSearchResult().getSearchEntries().get(0);
            }
            throw e;
        }
        return entry;
    }

    public static Filter createFilter(String filterTemplate, String ... arguments) throws LDAPException {
        return Filter.create((String)new MessageFormat(filterTemplate, Locale.ROOT).format(LdapUtils.encodeFilterValues(arguments), new StringBuffer(), (FieldPosition)null).toString());
    }

    static String[] encodeFilterValues(String ... arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = Filter.encodeValue((String)arguments[i]);
        }
        return arguments;
    }
}

