/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.esusers;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.shield.ShieldPlugin;
import org.elasticsearch.shield.authc.RealmConfig;
import org.elasticsearch.shield.authc.support.Hasher;
import org.elasticsearch.shield.authc.support.RefreshListener;
import org.elasticsearch.shield.authc.support.SecuredString;
import org.elasticsearch.shield.support.NoOpLogger;
import org.elasticsearch.shield.support.ShieldFiles;
import org.elasticsearch.shield.support.Validation;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;

public class FileUserPasswdStore {
    private final ESLogger logger;
    private final Path file;
    final Hasher hasher = Hasher.BCRYPT;
    private volatile ImmutableMap<String, char[]> users;
    private CopyOnWriteArrayList<RefreshListener> listeners;

    public FileUserPasswdStore(RealmConfig config, ResourceWatcherService watcherService) {
        this(config, watcherService, null);
    }

    FileUserPasswdStore(RealmConfig config, ResourceWatcherService watcherService, RefreshListener listener) {
        this.logger = config.logger(FileUserPasswdStore.class);
        this.file = FileUserPasswdStore.resolveFile(config.settings(), config.env());
        this.users = FileUserPasswdStore.parseFileLenient(this.file, this.logger);
        if (this.users.isEmpty() && this.logger.isDebugEnabled()) {
            this.logger.debug("realm [esusers] has no users", new Object[0]);
        }
        FileWatcher watcher = new FileWatcher(this.file.getParent());
        watcher.addListener((Object)new FileListener());
        try {
            watcherService.add((ResourceWatcher)watcher, ResourceWatcherService.Frequency.HIGH);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to start watching users file [{}]", (Throwable)e, new Object[]{this.file.toAbsolutePath()});
        }
        this.listeners = new CopyOnWriteArrayList();
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void addListener(RefreshListener listener) {
        this.listeners.add(listener);
    }

    public int usersCount() {
        return this.users.size();
    }

    public boolean verifyPassword(String username, SecuredString password) {
        if (this.users == null) {
            return false;
        }
        char[] hash = (char[])this.users.get((Object)username);
        return hash != null && this.hasher.verify(password, hash);
    }

    public boolean userExists(String username) {
        return this.users != null && this.users.containsKey((Object)username);
    }

    public static Path resolveFile(Settings settings, Environment env) {
        String location = settings.get("files.users");
        if (location == null) {
            return ShieldPlugin.resolveConfigFile(env, "users");
        }
        return env.binFile().getParent().resolve(location);
    }

    static ImmutableMap<String, char[]> parseFileLenient(Path path, ESLogger logger) {
        try {
            return FileUserPasswdStore.parseFile(path, logger);
        }
        catch (Throwable t) {
            logger.error("failed to parse users file [{}]. skipping/removing all users...", t, new Object[]{path.toAbsolutePath()});
            return ImmutableMap.of();
        }
    }

    public static ImmutableMap<String, char[]> parseFile(Path path, @Nullable ESLogger logger) {
        List<String> lines;
        if (logger == null) {
            logger = NoOpLogger.INSTANCE;
        }
        logger.trace("reading users file [{}]...", new Object[]{path.toAbsolutePath()});
        if (!Files.exists(path, new LinkOption[0])) {
            return ImmutableMap.of();
        }
        try {
            lines = Files.readAllLines(path, Charsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("could not read users file [" + path.toAbsolutePath() + "]", ioe);
        }
        ImmutableMap.Builder users = ImmutableMap.builder();
        int lineNr = 0;
        for (String line : lines) {
            ++lineNr;
            if (line.startsWith("#")) continue;
            int i = (line = line.trim()).indexOf(":");
            if (i <= 0 || i == line.length() - 1) {
                logger.error("invalid entry in users file [{}], line [{}]. skipping...", new Object[]{path.toAbsolutePath(), lineNr});
                continue;
            }
            String username = line.substring(0, i);
            Validation.Error validationError = Validation.ESUsers.validateUsername(username);
            if (validationError != null) {
                logger.error("invalid username [{}] in users file [{}], skipping... ({})", new Object[]{username, path.toAbsolutePath(), validationError});
                continue;
            }
            String hash = line.substring(i + 1);
            users.put((Object)username, (Object)hash.toCharArray());
        }
        ImmutableMap usersMap = users.build();
        if (usersMap.isEmpty()) {
            logger.warn("no users found in users file [{}]. use bin/shield/esusers to add users and role mappings", new Object[]{path.toAbsolutePath()});
        }
        return usersMap;
    }

    public static void writeFile(Map<String, char[]> esUsers, Path path) {
        try (PrintWriter writer = new PrintWriter(ShieldFiles.openAtomicMoveWriter(path));){
            for (Map.Entry<String, char[]> entry : esUsers.entrySet()) {
                writer.printf(Locale.ROOT, "%s:%s%s", entry.getKey(), new String(entry.getValue()), System.lineSeparator());
            }
        }
        catch (IOException ioe) {
            throw new ElasticsearchException("could not write file [{}], please check file permissions", (Throwable)ioe, new Object[]{path.toAbsolutePath()});
        }
    }

    public void notifyRefresh() {
        for (RefreshListener listener : this.listeners) {
            listener.onRefresh();
        }
    }

    private class FileListener
    extends FileChangesListener {
        private FileListener() {
        }

        public void onFileCreated(Path file) {
            this.onFileChanged(file);
        }

        public void onFileDeleted(Path file) {
            this.onFileChanged(file);
        }

        public void onFileChanged(Path file) {
            if (file.equals(FileUserPasswdStore.this.file)) {
                FileUserPasswdStore.this.logger.info("users file [{}] changed. updating users... )", new Object[]{file.toAbsolutePath()});
                FileUserPasswdStore.this.users = FileUserPasswdStore.parseFileLenient(file, FileUserPasswdStore.this.logger);
                FileUserPasswdStore.this.notifyRefresh();
            }
        }
    }
}

