/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.esusers;

import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.authc.Realm;
import org.elasticsearch.shield.authc.RealmConfig;
import org.elasticsearch.shield.authc.esusers.FileUserPasswdStore;
import org.elasticsearch.shield.authc.esusers.FileUserRolesStore;
import org.elasticsearch.shield.authc.support.CachingUsernamePasswordRealm;
import org.elasticsearch.shield.authc.support.RefreshListener;
import org.elasticsearch.shield.authc.support.UsernamePasswordToken;
import org.elasticsearch.watcher.ResourceWatcherService;

public class FileRealm
extends CachingUsernamePasswordRealm {
    public static final String OLD_TYPE = "esusers";
    public static final String TYPE = "file";
    final FileUserPasswdStore userPasswdStore;
    final FileUserRolesStore userRolesStore;

    public FileRealm(RealmConfig config, FileUserPasswdStore userPasswdStore, FileUserRolesStore userRolesStore) {
        super(TYPE, config);
        Listener listener = new Listener();
        this.userPasswdStore = userPasswdStore;
        userPasswdStore.addListener(listener);
        this.userRolesStore = userRolesStore;
        userRolesStore.addListener(listener);
    }

    @Override
    protected User doAuthenticate(UsernamePasswordToken token) {
        if (!this.userPasswdStore.verifyPassword(token.principal(), token.credentials())) {
            return null;
        }
        String[] roles = this.userRolesStore.roles(token.principal());
        return new User(token.principal(), roles);
    }

    @Override
    public User doLookupUser(String username) {
        if (this.userPasswdStore.userExists(username)) {
            String[] roles = this.userRolesStore.roles(username);
            return new User(username, roles);
        }
        return null;
    }

    @Override
    public boolean userLookupSupported() {
        return true;
    }

    public static class Factory
    extends Realm.Factory<FileRealm> {
        private final Settings settings;
        private final Environment env;
        private final ResourceWatcherService watcherService;

        @Inject
        public Factory(Settings settings, Environment env, ResourceWatcherService watcherService) {
            super(FileRealm.TYPE, true);
            this.settings = settings;
            this.env = env;
            this.watcherService = watcherService;
        }

        @Override
        public FileRealm create(RealmConfig config) {
            return new FileRealm(config, new FileUserPasswdStore(config, this.watcherService), new FileUserRolesStore(config, this.watcherService));
        }

        @Override
        public FileRealm createDefault(String name) {
            RealmConfig config = new RealmConfig(name, Settings.EMPTY, this.settings, this.env);
            return this.create(config);
        }
    }

    class Listener
    implements RefreshListener {
        Listener() {
        }

        @Override
        public void onRefresh() {
            FileRealm.this.expireAll();
        }
    }
}

