/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.audit.index;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;

public enum IndexAuditLevel {
    ANONYMOUS_ACCESS_DENIED,
    AUTHENTICATION_FAILED,
    ACCESS_GRANTED,
    ACCESS_DENIED,
    TAMPERED_REQUEST,
    CONNECTION_GRANTED,
    CONNECTION_DENIED,
    SYSTEM_ACCESS_GRANTED,
    RUN_AS_GRANTED,
    RUN_AS_DENIED;


    static EnumSet<IndexAuditLevel> parse(String[] levels) {
        EnumSet<IndexAuditLevel> enumSet = EnumSet.noneOf(IndexAuditLevel.class);
        block26: for (String level : levels) {
            String lowerCaseLevel;
            switch (lowerCaseLevel = level.trim().toLowerCase(Locale.ROOT)) {
                case "_all": {
                    enumSet.addAll(Arrays.asList(IndexAuditLevel.values()));
                    continue block26;
                }
                case "anonymous_access_denied": {
                    enumSet.add(ANONYMOUS_ACCESS_DENIED);
                    continue block26;
                }
                case "authentication_failed": {
                    enumSet.add(AUTHENTICATION_FAILED);
                    continue block26;
                }
                case "access_granted": {
                    enumSet.add(ACCESS_GRANTED);
                    continue block26;
                }
                case "access_denied": {
                    enumSet.add(ACCESS_DENIED);
                    continue block26;
                }
                case "tampered_request": {
                    enumSet.add(TAMPERED_REQUEST);
                    continue block26;
                }
                case "connection_granted": {
                    enumSet.add(CONNECTION_GRANTED);
                    continue block26;
                }
                case "connection_denied": {
                    enumSet.add(CONNECTION_DENIED);
                    continue block26;
                }
                case "system_access_granted": {
                    enumSet.add(SYSTEM_ACCESS_GRANTED);
                    continue block26;
                }
                case "run_as_granted": {
                    enumSet.add(RUN_AS_GRANTED);
                    continue block26;
                }
                case "run_as_denied": {
                    enumSet.add(RUN_AS_DENIED);
                    continue block26;
                }
                default: {
                    throw new IllegalArgumentException("invalid event name specified [" + level + "]");
                }
            }
        }
        return enumSet;
    }

    public static EnumSet<IndexAuditLevel> parse(String[] includeLevels, String[] excludeLevels) {
        EnumSet<IndexAuditLevel> included = IndexAuditLevel.parse(includeLevels);
        EnumSet<IndexAuditLevel> excluded = IndexAuditLevel.parse(excludeLevels);
        included.removeAll(excluded);
        return included;
    }
}

