/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.audit;

import java.net.InetAddress;
import java.util.Set;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.audit.AuditTrail;
import org.elasticsearch.shield.authc.AuthenticationToken;
import org.elasticsearch.shield.transport.filter.ShieldIpFilterRule;
import org.elasticsearch.transport.TransportMessage;

public class AuditTrailService
extends AbstractComponent
implements AuditTrail {
    final AuditTrail[] auditTrails;

    @Override
    public String name() {
        return "service";
    }

    @Inject
    public AuditTrailService(Settings settings, Set<AuditTrail> auditTrails) {
        super(settings);
        this.auditTrails = auditTrails.toArray(new AuditTrail[auditTrails.size()]);
    }

    @Override
    public void anonymousAccessDenied(String action, TransportMessage<?> message) {
        for (AuditTrail auditTrail : this.auditTrails) {
            auditTrail.anonymousAccessDenied(action, message);
        }
    }

    @Override
    public void anonymousAccessDenied(RestRequest request) {
        for (AuditTrail auditTrail : this.auditTrails) {
            auditTrail.anonymousAccessDenied(request);
        }
    }

    @Override
    public void authenticationFailed(RestRequest request) {
        for (AuditTrail auditTrail : this.auditTrails) {
            auditTrail.authenticationFailed(request);
        }
    }

    @Override
    public void authenticationFailed(String action, TransportMessage<?> message) {
        for (AuditTrail auditTrail : this.auditTrails) {
            auditTrail.authenticationFailed(action, message);
        }
    }

    @Override
    public void authenticationFailed(AuthenticationToken token, String action, TransportMessage<?> message) {
        for (AuditTrail auditTrail : this.auditTrails) {
            auditTrail.authenticationFailed(token, action, message);
        }
    }

    @Override
    public void authenticationFailed(String realm, AuthenticationToken token, String action, TransportMessage<?> message) {
        for (AuditTrail auditTrail : this.auditTrails) {
            auditTrail.authenticationFailed(realm, token, action, message);
        }
    }

    @Override
    public void authenticationFailed(AuthenticationToken token, RestRequest request) {
        for (AuditTrail auditTrail : this.auditTrails) {
            auditTrail.authenticationFailed(token, request);
        }
    }

    @Override
    public void authenticationFailed(String realm, AuthenticationToken token, RestRequest request) {
        for (AuditTrail auditTrail : this.auditTrails) {
            auditTrail.authenticationFailed(realm, token, request);
        }
    }

    @Override
    public void accessGranted(User user, String action, TransportMessage<?> message) {
        for (AuditTrail auditTrail : this.auditTrails) {
            auditTrail.accessGranted(user, action, message);
        }
    }

    @Override
    public void accessDenied(User user, String action, TransportMessage<?> message) {
        for (AuditTrail auditTrail : this.auditTrails) {
            auditTrail.accessDenied(user, action, message);
        }
    }

    @Override
    public void tamperedRequest(String action, TransportMessage<?> message) {
        for (AuditTrail auditTrail : this.auditTrails) {
            auditTrail.tamperedRequest(action, message);
        }
    }

    @Override
    public void tamperedRequest(User user, String action, TransportMessage<?> request) {
        for (AuditTrail auditTrail : this.auditTrails) {
            auditTrail.tamperedRequest(user, action, request);
        }
    }

    @Override
    public void connectionGranted(InetAddress inetAddress, String profile, ShieldIpFilterRule rule) {
        for (AuditTrail auditTrail : this.auditTrails) {
            auditTrail.connectionGranted(inetAddress, profile, rule);
        }
    }

    @Override
    public void connectionDenied(InetAddress inetAddress, String profile, ShieldIpFilterRule rule) {
        for (AuditTrail auditTrail : this.auditTrails) {
            auditTrail.connectionDenied(inetAddress, profile, rule);
        }
    }

    @Override
    public void runAsGranted(User user, String action, TransportMessage<?> message) {
        for (AuditTrail auditTrail : this.auditTrails) {
            auditTrail.runAsGranted(user, action, message);
        }
    }

    @Override
    public void runAsDenied(User user, String action, TransportMessage<?> message) {
        for (AuditTrail auditTrail : this.auditTrails) {
            auditTrail.runAsDenied(user, action, message);
        }
    }
}

