/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action.user;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.action.user.GetUsersRequest;
import org.elasticsearch.shield.action.user.GetUsersResponse;
import org.elasticsearch.shield.authc.esnative.ESNativeUsersStore;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetUsersAction
extends HandledTransportAction<GetUsersRequest, GetUsersResponse> {
    private final ESNativeUsersStore usersStore;

    @Inject
    public TransportGetUsersAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ESNativeUsersStore usersStore, TransportService transportService) {
        super(settings, "cluster:admin/xpack/security/user/get", threadPool, transportService, actionFilters, indexNameExpressionResolver, GetUsersRequest.class);
        this.usersStore = usersStore;
    }

    protected void doExecute(final GetUsersRequest request, final ActionListener<GetUsersResponse> listener) {
        if (request.usernames().length == 1) {
            final String username = request.usernames()[0];
            this.usersStore.getUser(username, new ActionListener<User>(){

                public void onResponse(User user) {
                    if (user == null) {
                        listener.onResponse((Object)new GetUsersResponse(new User[0]));
                    } else {
                        listener.onResponse((Object)new GetUsersResponse(user));
                    }
                }

                public void onFailure(Throwable e) {
                    TransportGetUsersAction.this.logger.error("failed to retrieve user [{}]", e, new Object[]{username});
                    listener.onFailure(e);
                }
            });
        } else {
            this.usersStore.getUsers(request.usernames(), new ActionListener<List<User>>(){

                public void onResponse(List<User> users) {
                    listener.onResponse((Object)new GetUsersResponse(users));
                }

                public void onFailure(Throwable e) {
                    TransportGetUsersAction.this.logger.error("failed to retrieve user [{}]", e, new Object[]{Strings.arrayToDelimitedString((Object[])request.usernames(), (String)",")});
                    listener.onFailure(e);
                }
            });
        }
    }
}

