/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action.user;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DeleteUserRequest
extends ActionRequest<DeleteUserRequest> {
    private String username;
    private boolean refresh = true;

    public DeleteUserRequest() {
    }

    public DeleteUserRequest(String user) {
        this.username = user;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.username == null) {
            validationException = ValidateActions.addValidationError((String)"user is missing", validationException);
        }
        return validationException;
    }

    public String username() {
        return this.username;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public void username(String username) {
        this.username = username;
    }

    public void refresh(boolean refresh) {
        this.refresh = refresh;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.username = in.readString();
        this.refresh = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.username);
        out.writeBoolean(this.refresh);
    }
}

