/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action.role;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.action.role.PutRoleRequest;
import org.elasticsearch.shield.action.role.PutRoleResponse;
import org.elasticsearch.shield.authz.store.ESNativeRolesStore;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutRoleAction
extends HandledTransportAction<PutRoleRequest, PutRoleResponse> {
    private final ESNativeRolesStore rolesStore;

    @Inject
    public TransportPutRoleAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ESNativeRolesStore rolesStore, TransportService transportService) {
        super(settings, "cluster:admin/xpack/security/role/put", threadPool, transportService, actionFilters, indexNameExpressionResolver, PutRoleRequest.class);
        this.rolesStore = rolesStore;
    }

    protected void doExecute(final PutRoleRequest request, final ActionListener<PutRoleResponse> listener) {
        this.rolesStore.putRole(request, request.roleDescriptor(), new ActionListener<Boolean>(){

            public void onResponse(Boolean created) {
                if (created.booleanValue()) {
                    TransportPutRoleAction.this.logger.info("added role [{}]", new Object[]{request.name()});
                } else {
                    TransportPutRoleAction.this.logger.info("updated role [{}]", new Object[]{request.name()});
                }
                listener.onResponse((Object)new PutRoleResponse(created));
            }

            public void onFailure(Throwable t) {
                listener.onFailure(t);
            }
        });
    }
}

