/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action.role;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.action.role.DeleteRoleRequest;
import org.elasticsearch.shield.action.role.DeleteRoleResponse;
import org.elasticsearch.shield.authz.store.ESNativeRolesStore;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteRoleAction
extends HandledTransportAction<DeleteRoleRequest, DeleteRoleResponse> {
    private final ESNativeRolesStore rolesStore;

    @Inject
    public TransportDeleteRoleAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ESNativeRolesStore rolesStore, TransportService transportService) {
        super(settings, "cluster:admin/xpack/security/role/delete", threadPool, transportService, actionFilters, indexNameExpressionResolver, DeleteRoleRequest.class);
        this.rolesStore = rolesStore;
    }

    protected void doExecute(DeleteRoleRequest request, final ActionListener<DeleteRoleResponse> listener) {
        try {
            this.rolesStore.deleteRole(request, new ActionListener<Boolean>(){

                public void onResponse(Boolean found) {
                    listener.onResponse((Object)new DeleteRoleResponse(found));
                }

                public void onFailure(Throwable t) {
                    listener.onFailure(t);
                }
            });
        }
        catch (Exception e) {
            this.logger.error("failed to delete role [{}]", (Throwable)e, new Object[0]);
            listener.onFailure((Throwable)e);
        }
    }
}

