/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action.role;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.action.role.ClearRolesCacheRequest;
import org.elasticsearch.shield.action.role.ClearRolesCacheResponse;
import org.elasticsearch.shield.action.support.TransportNodesMasterCoordinatedAction;
import org.elasticsearch.shield.authz.store.ESNativeRolesStore;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClearRolesCacheAction
extends TransportNodesMasterCoordinatedAction<ClearRolesCacheRequest, ClearRolesCacheResponse, ClearRolesCacheRequest.Node, ClearRolesCacheResponse.Node> {
    private final ESNativeRolesStore rolesStore;
    private final ClusterName clusterName;

    @Inject
    public TransportClearRolesCacheAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, ESNativeRolesStore rolesStore, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/xpack/security/roles/cache/clear", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, ClearRolesCacheRequest.class, ClearRolesCacheRequest.Node.class);
        this.rolesStore = rolesStore;
        this.clusterName = clusterName;
    }

    @Override
    protected ClearRolesCacheResponse.Node nodeOperation(ClearRolesCacheRequest.Node request) {
        if (request.roles() == null || request.roles().length == 0) {
            this.rolesStore.invalidateAll();
        } else {
            for (String role : request.roles()) {
                this.rolesStore.invalidate(role);
            }
        }
        return new ClearRolesCacheResponse.Node(this.clusterService.localNode());
    }

    protected ClearRolesCacheResponse newResponse() {
        return new ClearRolesCacheResponse();
    }

    @Override
    protected ClearRolesCacheResponse.Node newNodeResponse() {
        return new ClearRolesCacheResponse.Node();
    }

    @Override
    protected ClearRolesCacheResponse.Node newNodeResponse(DiscoveryNode node, FailedNodeException failedNodeException) {
        return new ClearRolesCacheResponse.Node(node, failedNodeException);
    }

    @Override
    protected ClearRolesCacheResponse newResponse(AtomicReferenceArray<ClearRolesCacheResponse.Node> nodeResponses) {
        ArrayList<ClearRolesCacheResponse.Node> responses = new ArrayList<ClearRolesCacheResponse.Node>(nodeResponses.length());
        for (int i = 0; i < nodeResponses.length(); ++i) {
            ClearRolesCacheResponse.Node resp = nodeResponses.get(i);
            if (resp == null) {
                throw new IllegalArgumentException("node response is null");
            }
            responses.add(resp);
        }
        return new ClearRolesCacheResponse(this.clusterName, responses.toArray(new ClearRolesCacheResponse.Node[responses.size()]));
    }

    @Override
    protected ClearRolesCacheRequest.Node newNodeRequest(String nodeId, ClearRolesCacheRequest request) {
        return new ClearRolesCacheRequest.Node(request, nodeId);
    }
}

