/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action.role;

import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.shield.action.role.PutRoleAction;
import org.elasticsearch.shield.action.role.PutRoleRequest;
import org.elasticsearch.shield.action.role.PutRoleResponse;
import org.elasticsearch.shield.authz.RoleDescriptor;

public class PutRoleRequestBuilder
extends ActionRequestBuilder<PutRoleRequest, PutRoleResponse, PutRoleRequestBuilder> {
    public PutRoleRequestBuilder(ElasticsearchClient client) {
        this(client, PutRoleAction.INSTANCE);
    }

    public PutRoleRequestBuilder(ElasticsearchClient client, PutRoleAction action) {
        super(client, (Action)action, (ActionRequest)new PutRoleRequest());
    }

    public PutRoleRequestBuilder source(String name, BytesReference source) throws Exception {
        RoleDescriptor descriptor = RoleDescriptor.parse(name, source);
        assert (name.equals(descriptor.getName()));
        ((PutRoleRequest)this.request).name(name);
        ((PutRoleRequest)this.request).cluster(descriptor.getClusterPrivileges());
        ((PutRoleRequest)this.request).addIndex(descriptor.getIndicesPrivileges());
        ((PutRoleRequest)this.request).runAs(descriptor.getRunAs());
        return this;
    }

    public PutRoleRequestBuilder name(String name) {
        ((PutRoleRequest)this.request).name(name);
        return this;
    }

    public PutRoleRequestBuilder cluster(String ... cluster) {
        ((PutRoleRequest)this.request).cluster(cluster);
        return this;
    }

    public PutRoleRequestBuilder runAs(String ... runAsUsers) {
        ((PutRoleRequest)this.request).runAs(runAsUsers);
        return this;
    }

    public PutRoleRequestBuilder addIndices(String[] indices, String[] privileges, @Nullable String[] fields, @Nullable BytesReference query) {
        ((PutRoleRequest)this.request).addIndex(indices, privileges, fields, query);
        return this;
    }

    public PutRoleRequestBuilder refresh(boolean refresh) {
        ((PutRoleRequest)this.request).refresh(refresh);
        return this;
    }
}

