/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.settings.Validator;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.logging.support.LoggerMessageFormat;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpServerModule;
import org.elasticsearch.index.cache.IndexCacheModule;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestModule;
import org.elasticsearch.shield.InternalShieldUser;
import org.elasticsearch.shield.ShieldDisabledModule;
import org.elasticsearch.shield.ShieldModule;
import org.elasticsearch.shield.action.ShieldActionFilter;
import org.elasticsearch.shield.action.ShieldActionModule;
import org.elasticsearch.shield.action.realm.ClearRealmCacheAction;
import org.elasticsearch.shield.action.realm.TransportClearRealmCacheAction;
import org.elasticsearch.shield.action.role.ClearRolesCacheAction;
import org.elasticsearch.shield.action.role.DeleteRoleAction;
import org.elasticsearch.shield.action.role.GetRolesAction;
import org.elasticsearch.shield.action.role.PutRoleAction;
import org.elasticsearch.shield.action.role.TransportClearRolesCacheAction;
import org.elasticsearch.shield.action.role.TransportDeleteRoleAction;
import org.elasticsearch.shield.action.role.TransportGetRolesAction;
import org.elasticsearch.shield.action.role.TransportPutRoleAction;
import org.elasticsearch.shield.action.user.DeleteUserAction;
import org.elasticsearch.shield.action.user.GetUsersAction;
import org.elasticsearch.shield.action.user.PutUserAction;
import org.elasticsearch.shield.action.user.TransportDeleteUserAction;
import org.elasticsearch.shield.action.user.TransportGetUsersAction;
import org.elasticsearch.shield.action.user.TransportPutUserAction;
import org.elasticsearch.shield.audit.AuditTrailModule;
import org.elasticsearch.shield.audit.index.IndexNameResolver;
import org.elasticsearch.shield.audit.index.InternalAuditUser;
import org.elasticsearch.shield.audit.logfile.LoggingAuditTrail;
import org.elasticsearch.shield.authc.AuthenticationModule;
import org.elasticsearch.shield.authc.Realms;
import org.elasticsearch.shield.authc.support.SecuredString;
import org.elasticsearch.shield.authc.support.UsernamePasswordToken;
import org.elasticsearch.shield.authz.AuthorizationModule;
import org.elasticsearch.shield.authz.accesscontrol.AccessControlShardModule;
import org.elasticsearch.shield.authz.accesscontrol.OptOutQueryCache;
import org.elasticsearch.shield.authz.store.FileRolesStore;
import org.elasticsearch.shield.crypto.CryptoModule;
import org.elasticsearch.shield.crypto.InternalCryptoService;
import org.elasticsearch.shield.license.LicenseModule;
import org.elasticsearch.shield.license.ShieldLicensee;
import org.elasticsearch.shield.rest.ShieldRestModule;
import org.elasticsearch.shield.rest.action.RestAuthenticateAction;
import org.elasticsearch.shield.rest.action.RestShieldInfoAction;
import org.elasticsearch.shield.rest.action.realm.RestClearRealmCacheAction;
import org.elasticsearch.shield.rest.action.role.RestClearRolesCacheAction;
import org.elasticsearch.shield.rest.action.role.RestDeleteRoleAction;
import org.elasticsearch.shield.rest.action.role.RestGetRolesAction;
import org.elasticsearch.shield.rest.action.role.RestPutRoleAction;
import org.elasticsearch.shield.rest.action.user.RestDeleteUserAction;
import org.elasticsearch.shield.rest.action.user.RestGetUsersAction;
import org.elasticsearch.shield.rest.action.user.RestPutUserAction;
import org.elasticsearch.shield.ssl.SSLModule;
import org.elasticsearch.shield.transport.ShieldClientTransportService;
import org.elasticsearch.shield.transport.ShieldServerTransportService;
import org.elasticsearch.shield.transport.ShieldTransportModule;
import org.elasticsearch.shield.transport.filter.IPFilter;
import org.elasticsearch.shield.transport.netty.ShieldNettyHttpServerTransport;
import org.elasticsearch.shield.transport.netty.ShieldNettyTransport;
import org.elasticsearch.transport.TransportModule;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ShieldPlugin
extends Plugin {
    public static final String NAME = "shield";
    public static final String ENABLED_SETTING_NAME = "shield.enabled";
    public static final String OPT_OUT_QUERY_CACHE = "opt_out_cache";
    private static final boolean DEFAULT_ENABLED_SETTING = true;
    private static final ESLogger logger = Loggers.getLogger(ShieldPlugin.class);
    private final Settings settings;
    private final boolean enabled;
    private final boolean clientMode;
    private final boolean tribeNode;

    public ShieldPlugin(Settings settings) {
        this.settings = settings;
        this.enabled = ShieldPlugin.shieldEnabled(settings);
        this.clientMode = ShieldPlugin.clientMode(settings);
        boolean bl = this.tribeNode = !settings.getGroups("tribe", true).isEmpty();
        if (this.enabled && !this.clientMode) {
            ShieldPlugin.failIfShieldQueryCacheIsNotActive(settings, true);
            ShieldPlugin.validateAutoCreateIndex(settings);
        }
    }

    public String name() {
        return NAME;
    }

    public String description() {
        return "Elasticsearch Shield (security)";
    }

    public Collection<Module> nodeModules() {
        if (!this.enabled) {
            return Collections.singletonList(new ShieldDisabledModule(this.settings));
        }
        if (this.clientMode) {
            return Arrays.asList(new Module[]{new ShieldTransportModule(this.settings), new SSLModule(this.settings)});
        }
        return Arrays.asList(new Module[]{new ShieldModule(this.settings), new LicenseModule(this.settings, this.tribeNode), new CryptoModule(this.settings), new AuthenticationModule(this.settings), new AuthorizationModule(this.settings), new AuditTrailModule(this.settings), new ShieldRestModule(this.settings), new ShieldActionModule(this.settings), new ShieldTransportModule(this.settings), new SSLModule(this.settings)});
    }

    public Collection<Module> indexModules(Settings settings) {
        if (this.enabled && !this.clientMode) {
            ShieldPlugin.failIfShieldQueryCacheIsNotActive(settings, false);
        }
        return Collections.emptyList();
    }

    public Collection<Module> shardModules(Settings settings) {
        if (this.enabled && !this.clientMode) {
            ShieldPlugin.failIfShieldQueryCacheIsNotActive(settings, false);
            return Collections.singletonList(new AccessControlShardModule(settings));
        }
        return Collections.emptyList();
    }

    public Collection<Class<? extends LifecycleComponent>> nodeServices() {
        if (this.enabled && !this.clientMode) {
            ArrayList<Class<? extends LifecycleComponent>> list = new ArrayList<Class<? extends LifecycleComponent>>();
            if (AuditTrailModule.fileAuditLoggingEnabled(this.settings)) {
                list.add(LoggingAuditTrail.class);
            }
            if (!this.tribeNode) {
                list.add(ShieldLicensee.class);
            }
            list.add(InternalCryptoService.class);
            list.add(FileRolesStore.class);
            list.add(Realms.class);
            list.add(IPFilter.class);
            return list;
        }
        return Collections.emptyList();
    }

    public Settings additionalSettings() {
        if (!this.enabled) {
            return Settings.EMPTY;
        }
        Settings.Builder settingsBuilder = Settings.settingsBuilder();
        this.addUserSettings(settingsBuilder);
        this.addTribeSettings(settingsBuilder);
        this.addQueryCacheSettings(settingsBuilder);
        return settingsBuilder.build();
    }

    public void onModule(ClusterModule clusterDynamicSettingsModule) {
        clusterDynamicSettingsModule.registerClusterDynamicSetting("shield.transport.filter.*", Validator.EMPTY);
        clusterDynamicSettingsModule.registerClusterDynamicSetting("shield.http.filter.*", Validator.EMPTY);
        clusterDynamicSettingsModule.registerClusterDynamicSetting("transport.profiles.*", Validator.EMPTY);
        clusterDynamicSettingsModule.registerClusterDynamicSetting("shield.transport.filter.enabled", Validator.EMPTY);
        clusterDynamicSettingsModule.registerClusterDynamicSetting("shield.http.filter.enabled", Validator.EMPTY);
    }

    public void onModule(ActionModule module) {
        if (!this.enabled) {
            return;
        }
        if (!this.clientMode) {
            module.registerFilter(ShieldActionFilter.class);
        }
        module.registerAction((GenericAction)ClearRealmCacheAction.INSTANCE, TransportClearRealmCacheAction.class, new Class[0]);
        module.registerAction((GenericAction)ClearRolesCacheAction.INSTANCE, TransportClearRolesCacheAction.class, new Class[0]);
        module.registerAction((GenericAction)GetUsersAction.INSTANCE, TransportGetUsersAction.class, new Class[0]);
        module.registerAction((GenericAction)PutUserAction.INSTANCE, TransportPutUserAction.class, new Class[0]);
        module.registerAction((GenericAction)DeleteUserAction.INSTANCE, TransportDeleteUserAction.class, new Class[0]);
        module.registerAction((GenericAction)GetRolesAction.INSTANCE, TransportGetRolesAction.class, new Class[0]);
        module.registerAction((GenericAction)PutRoleAction.INSTANCE, TransportPutRoleAction.class, new Class[0]);
        module.registerAction((GenericAction)DeleteRoleAction.INSTANCE, TransportDeleteRoleAction.class, new Class[0]);
    }

    public void onModule(TransportModule module) {
        if (!this.enabled) {
            return;
        }
        module.setTransport(ShieldNettyTransport.class, NAME);
        if (this.clientMode) {
            module.setTransportService(ShieldClientTransportService.class, NAME);
        } else {
            module.setTransportService(ShieldServerTransportService.class, NAME);
        }
    }

    public void onModule(HttpServerModule module) {
        if (this.enabled && !this.clientMode) {
            module.setHttpServerTransport(ShieldNettyHttpServerTransport.class, NAME);
        }
    }

    public void onModule(RestModule module) {
        if (this.enabled && !this.clientMode) {
            module.addRestAction(RestAuthenticateAction.class);
            module.addRestAction(RestClearRealmCacheAction.class);
            module.addRestAction(RestClearRolesCacheAction.class);
            module.addRestAction(RestGetUsersAction.class);
            module.addRestAction(RestPutUserAction.class);
            module.addRestAction(RestDeleteUserAction.class);
            module.addRestAction(RestGetRolesAction.class);
            module.addRestAction(RestPutRoleAction.class);
            module.addRestAction(RestDeleteRoleAction.class);
        }
        module.addRestAction(RestShieldInfoAction.class);
    }

    public void onModule(AuthorizationModule module) {
        if (this.enabled) {
            module.registerReservedRole(InternalShieldUser.ROLE);
            module.registerReservedRole(InternalAuditUser.ROLE);
        }
    }

    public void onModule(IndexCacheModule module) {
        if (this.enabled && !this.clientMode) {
            module.registerQueryCache(OPT_OUT_QUERY_CACHE, OptOutQueryCache.class);
        }
    }

    private void addUserSettings(Settings.Builder settingsBuilder) {
        String authHeaderSettingName = "request.headers.Authorization";
        if (this.settings.get(authHeaderSettingName) != null) {
            return;
        }
        String userSetting = this.settings.get("shield.user");
        if (userSetting == null) {
            return;
        }
        int i = userSetting.indexOf(":");
        if (i < 0 || i == userSetting.length() - 1) {
            throw new IllegalArgumentException("invalid [shield.user] setting. must be in the form of \"<username>:<password>\"");
        }
        String username = userSetting.substring(0, i);
        String password = userSetting.substring(i + 1);
        settingsBuilder.put(authHeaderSettingName, UsernamePasswordToken.basicAuthHeaderValue(username, new SecuredString(password.toCharArray())));
    }

    private void addTribeSettings(Settings.Builder settingsBuilder) {
        Map tribesSettings = this.settings.getGroups("tribe", true);
        if (tribesSettings.isEmpty()) {
            return;
        }
        Map settingsMap = this.settings.getAsMap();
        for (Map.Entry tribeSettings : tribesSettings.entrySet()) {
            String tribePrefix = "tribe." + (String)tribeSettings.getKey() + ".";
            String[] existingMandatoryPlugins = ((Settings)tribeSettings.getValue()).getAsArray("plugin.mandatory", null);
            if (existingMandatoryPlugins == null) {
                settingsBuilder.putArray(tribePrefix + "plugin.mandatory", new String[]{NAME});
            } else if (!ShieldPlugin.isShieldMandatory(existingMandatoryPlugins)) {
                throw new IllegalStateException("when [plugin.mandatory] is explicitly configured, [shield] must be included in this list");
            }
            String tribeEnabledSetting = tribePrefix + ENABLED_SETTING_NAME;
            if (this.settings.get(tribeEnabledSetting) != null) {
                boolean enabled = ShieldPlugin.shieldEnabled((Settings)tribeSettings.getValue());
                if (!enabled) {
                    throw new IllegalStateException("tribe setting [" + tribeEnabledSetting + "] must be set to true but the value is [" + this.settings.get(tribeEnabledSetting) + "]");
                }
            } else {
                settingsBuilder.put(tribeEnabledSetting, true);
            }
            for (Map.Entry entry : settingsMap.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("shield.")) continue;
                settingsBuilder.put(tribePrefix + key, (String)entry.getValue());
            }
        }
        Map realmsSettings = this.settings.getGroups("shield.authc.realms", true);
        boolean hasNativeRealm = realmsSettings.isEmpty();
        if (!hasNativeRealm) {
            for (Map.Entry entry : realmsSettings.entrySet()) {
                Settings realmSettings = (Settings)entry.getValue();
                if (!"native".equals(realmSettings.get("type")) || !realmSettings.getAsBoolean("enabled", Boolean.valueOf(true)).booleanValue()) continue;
                hasNativeRealm = true;
                break;
            }
        }
        if (hasNativeRealm && !this.settings.get("tribe.on_conflict", "any").startsWith("prefer_")) {
            throw new IllegalArgumentException("use of native realm on tribe nodes requires setting [tribe.on_conflict] to specify the name of the tribe to prefer such as [prefer_t1] as the security index can exist in multiple tribes but only one can be used by the tribe node");
        }
    }

    private void addQueryCacheSettings(Settings.Builder settingsBuilder) {
        settingsBuilder.put("index.queries.cache.type", OPT_OUT_QUERY_CACHE);
    }

    private static boolean isShieldMandatory(String[] existingMandatoryPlugins) {
        for (String existingMandatoryPlugin : existingMandatoryPlugins) {
            if (!NAME.equals(existingMandatoryPlugin)) continue;
            return true;
        }
        return false;
    }

    public static Path configDir(Environment env) {
        return env.configFile().resolve(NAME);
    }

    public static Path resolveConfigFile(Environment env, String name) {
        return ShieldPlugin.configDir(env).resolve(name);
    }

    public static boolean clientMode(Settings settings) {
        return !"node".equals(settings.get("client.type"));
    }

    public static boolean shieldEnabled(Settings settings) {
        return settings.getAsBoolean(ENABLED_SETTING_NAME, Boolean.valueOf(true));
    }

    static void failIfShieldQueryCacheIsNotActive(Settings settings, boolean nodeSettings) {
        String queryCacheImplementation = nodeSettings ? settings.get("index.queries.cache.type", OPT_OUT_QUERY_CACHE) : settings.get("index.queries.cache.type");
        if (!OPT_OUT_QUERY_CACHE.equals(queryCacheImplementation) && !"none".equals(queryCacheImplementation)) {
            throw new IllegalStateException("shield does not support a user specified query cache. remove the setting [index.queries.cache.type] with value [" + queryCacheImplementation + "]");
        }
    }

    static void validateAutoCreateIndex(Settings settings) {
        String value = settings.get("action.auto_create_index");
        if (value == null) {
            return;
        }
        boolean indexAuditingEnabled = AuditTrailModule.indexAuditLoggingEnabled(settings);
        String auditIndex = indexAuditingEnabled ? ",.shield_audit_log*" : "";
        String errorMessage = LoggerMessageFormat.format((String)"the [action.auto_create_index] setting value [{}] is too restrictive. disable [action.auto_create_index] or set it to [{}{}]", (Object[])new Object[]{value, ".security", auditIndex});
        if (Booleans.isExplicitFalse((String)value)) {
            throw new IllegalArgumentException(errorMessage);
        }
        if (Booleans.isExplicitTrue((String)value)) {
            return;
        }
        String[] matches = Strings.commaDelimitedListToStringArray((String)value);
        ArrayList<String> indices = new ArrayList<String>();
        indices.add(".security");
        if (indexAuditingEnabled) {
            DateTime now = new DateTime(DateTimeZone.UTC);
            indices.add(IndexNameResolver.resolve(".shield_audit_log", now, IndexNameResolver.Rollover.DAILY));
            indices.add(IndexNameResolver.resolve(".shield_audit_log", now.plusDays(1), IndexNameResolver.Rollover.DAILY));
            indices.add(IndexNameResolver.resolve(".shield_audit_log", now.plusMonths(1), IndexNameResolver.Rollover.DAILY));
            indices.add(IndexNameResolver.resolve(".shield_audit_log", now.plusMonths(2), IndexNameResolver.Rollover.DAILY));
            indices.add(IndexNameResolver.resolve(".shield_audit_log", now.plusMonths(3), IndexNameResolver.Rollover.DAILY));
            indices.add(IndexNameResolver.resolve(".shield_audit_log", now.plusMonths(4), IndexNameResolver.Rollover.DAILY));
            indices.add(IndexNameResolver.resolve(".shield_audit_log", now.plusMonths(5), IndexNameResolver.Rollover.DAILY));
            indices.add(IndexNameResolver.resolve(".shield_audit_log", now.plusMonths(6), IndexNameResolver.Rollover.DAILY));
        }
        for (String index : indices) {
            boolean matched = false;
            for (String match : matches) {
                char c = match.charAt(0);
                if (c == '-') {
                    if (!Regex.simpleMatch((String)match.substring(1), (String)index)) continue;
                    throw new IllegalArgumentException(errorMessage);
                }
                if (c == '+') {
                    if (!Regex.simpleMatch((String)match.substring(1), (String)index)) continue;
                    matched = true;
                    break;
                }
                if (!Regex.simpleMatch((String)match, (String)index)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            throw new IllegalArgumentException(errorMessage);
        }
        if (indexAuditingEnabled) {
            logger.warn("the [action.auto_create_index] setting is configured to be restrictive [{}].  for the next 6 months audit indices are allowed to be created, but please make sure that any future history indices after 6 months with the pattern [.shield_audit_log*] are allowed to be created", new Object[]{value});
        }
    }
}

