/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield;

import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.shield.audit.AuditTrailModule;
import org.elasticsearch.shield.audit.index.IndexAuditTrail;
import org.elasticsearch.shield.authc.esnative.ESNativeUsersStore;
import org.elasticsearch.shield.authz.store.ESNativeRolesStore;
import org.elasticsearch.threadpool.ThreadPool;

public class ShieldLifecycleService
extends AbstractComponent
implements ClusterStateListener {
    private final Settings settings;
    private final ThreadPool threadPool;
    private final IndexAuditTrail indexAuditTrail;
    private final ESNativeUsersStore esUserStore;
    private final ESNativeRolesStore esRolesStore;

    @Inject
    public ShieldLifecycleService(Settings settings, ClusterService clusterService, ThreadPool threadPool, IndexAuditTrail indexAuditTrail, ESNativeUsersStore esUserStore, ESNativeRolesStore esRolesStore) {
        super(settings);
        this.settings = settings;
        this.threadPool = threadPool;
        this.indexAuditTrail = indexAuditTrail;
        this.esUserStore = esUserStore;
        this.esRolesStore = esRolesStore;
        clusterService.add((ClusterStateListener)this);
        clusterService.add((ClusterStateListener)esUserStore);
        clusterService.add((ClusterStateListener)esRolesStore);
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
                ShieldLifecycleService.this.stop();
            }

            public void beforeClose() {
                ShieldLifecycleService.this.close();
            }
        });
    }

    public void clusterChanged(ClusterChangedEvent event) {
        final boolean master = event.localNodeMaster();
        try {
            if (this.esUserStore.canStart(event.state(), master)) {
                this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

                    public void onFailure(Throwable throwable) {
                        ShieldLifecycleService.this.logger.error("failed to start native user store service", throwable, new Object[0]);
                        assert (false) : "shield lifecycle services startup failed";
                    }

                    public void doRun() {
                        ShieldLifecycleService.this.esUserStore.start();
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.error("failed to start native user store", (Throwable)e, new Object[0]);
        }
        try {
            if (this.esRolesStore.canStart(event.state(), master)) {
                this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

                    public void onFailure(Throwable throwable) {
                        ShieldLifecycleService.this.logger.error("failed to start native roles store services", throwable, new Object[0]);
                        assert (false) : "shield lifecycle services startup failed";
                    }

                    public void doRun() {
                        ShieldLifecycleService.this.esRolesStore.start();
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.error("failed to start native roles store", (Throwable)e, new Object[0]);
        }
        try {
            if (AuditTrailModule.indexAuditLoggingEnabled(this.settings) && this.indexAuditTrail.state() == IndexAuditTrail.State.INITIALIZED && this.indexAuditTrail.canStart(event, master)) {
                this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

                    public void onFailure(Throwable throwable) {
                        ShieldLifecycleService.this.logger.error("failed to start index audit trail services", throwable, new Object[0]);
                        assert (false) : "shield lifecycle services startup failed";
                    }

                    public void doRun() {
                        ShieldLifecycleService.this.indexAuditTrail.start(master);
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.error("failed to start index audit trail", (Throwable)e, new Object[0]);
        }
    }

    public void stop() {
        try {
            this.esUserStore.stop();
        }
        catch (Exception e) {
            this.logger.error("failed to stop native user module", (Throwable)e, new Object[0]);
        }
        try {
            this.esRolesStore.stop();
        }
        catch (Exception e) {
            this.logger.error("failed to stop native roles module", (Throwable)e, new Object[0]);
        }
        try {
            this.indexAuditTrail.stop();
        }
        catch (Exception e) {
            this.logger.error("failed to stop audit trail module", (Throwable)e, new Object[0]);
        }
    }

    public void close() {
        try {
            this.indexAuditTrail.close();
        }
        catch (Exception e) {
            this.logger.error("failed to close audit trail module", (Throwable)e, new Object[0]);
        }
    }
}

