/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.transport.netty;

import java.net.InetSocketAddress;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.elasticsearch.Version;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.shield.ShieldSettingsFilter;
import org.elasticsearch.shield.ssl.ClientSSLService;
import org.elasticsearch.shield.ssl.ServerSSLService;
import org.elasticsearch.shield.transport.SSLClientAuth;
import org.elasticsearch.shield.transport.SSLExceptionHelper;
import org.elasticsearch.shield.transport.filter.IPFilter;
import org.elasticsearch.shield.transport.netty.HandshakeWaitingHandler;
import org.elasticsearch.shield.transport.netty.IPFilterNettyUpstreamHandler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.netty.NettyTransport;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.ssl.SslHandler;

public class ShieldNettyTransport
extends NettyTransport {
    public static final String HOSTNAME_VERIFICATION_SETTING = "shield.ssl.hostname_verification";
    public static final String HOSTNAME_VERIFICATION_RESOLVE_NAME_SETTING = "shield.ssl.hostname_verification.resolve_name";
    public static final String TRANSPORT_SSL_SETTING = "shield.transport.ssl";
    public static final boolean TRANSPORT_SSL_DEFAULT = false;
    public static final String TRANSPORT_CLIENT_AUTH_SETTING = "shield.transport.ssl.client.auth";
    public static final SSLClientAuth TRANSPORT_CLIENT_AUTH_DEFAULT = SSLClientAuth.REQUIRED;
    public static final String TRANSPORT_PROFILE_SSL_SETTING = "shield.ssl";
    public static final String TRANSPORT_PROFILE_CLIENT_AUTH_SETTING = "shield.ssl.client.auth";
    private final ServerSSLService serverSslService;
    private final ClientSSLService clientSSLService;
    private final ShieldSettingsFilter settingsFilter;
    @Nullable
    private final IPFilter authenticator;
    private final boolean ssl;

    @Inject
    public ShieldNettyTransport(Settings settings, ThreadPool threadPool, NetworkService networkService, BigArrays bigArrays, Version version, @Nullable IPFilter authenticator, @Nullable ServerSSLService serverSSLService, ClientSSLService clientSSLService, ShieldSettingsFilter settingsFilter, NamedWriteableRegistry namedWriteableRegistry) {
        super(settings, threadPool, networkService, bigArrays, version, namedWriteableRegistry);
        this.authenticator = authenticator;
        this.ssl = settings.getAsBoolean(TRANSPORT_SSL_SETTING, Boolean.valueOf(false));
        this.serverSslService = serverSSLService;
        this.clientSSLService = clientSSLService;
        this.settingsFilter = settingsFilter;
    }

    public ChannelPipelineFactory configureClientChannelPipelineFactory() {
        return new SslClientChannelPipelineFactory(this);
    }

    public ChannelPipelineFactory configureServerChannelPipelineFactory(String name, Settings profileSettings) {
        return new SslServerChannelPipelineFactory(this, name, this.settings, profileSettings);
    }

    protected void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (!this.lifecycle.started()) {
            return;
        }
        Throwable t = e.getCause();
        if (SSLExceptionHelper.isNotSslRecordException(t)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("received plaintext traffic on a encrypted channel, closing connection {}", t, new Object[]{ctx.getChannel()});
            } else {
                this.logger.warn("received plaintext traffic on a encrypted channel, closing connection {}", new Object[]{ctx.getChannel()});
            }
            ctx.getChannel().close();
            this.disconnectFromNodeChannel(ctx.getChannel(), e.getCause());
        } else if (SSLExceptionHelper.isCloseDuringHandshakeException(t)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("connection {} closed during handshake", t, new Object[]{ctx.getChannel()});
            } else {
                this.logger.warn("connection {} closed during handshake", new Object[]{ctx.getChannel()});
            }
            ctx.getChannel().close();
            this.disconnectFromNodeChannel(ctx.getChannel(), e.getCause());
        } else {
            super.exceptionCaught(ctx, e);
        }
    }

    private class SslClientChannelPipelineFactory
    extends NettyTransport.ClientChannelPipelineFactory {
        private final Settings sslSettings;

        public SslClientChannelPipelineFactory(NettyTransport transport) {
            super(transport);
            Map groupSettings = ShieldNettyTransport.this.settings.getGroups("transport.profiles");
            this.sslSettings = groupSettings.containsKey("default") ? ((Settings)groupSettings.get("default")).getByPrefix("shield.") : Settings.EMPTY;
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = super.getPipeline();
            if (ShieldNettyTransport.this.ssl) {
                pipeline.addFirst("sslInitializer", (ChannelHandler)new ClientSslHandlerInitializer());
            }
            return pipeline;
        }

        private class ClientSslHandlerInitializer
        extends SimpleChannelHandler {
            private ClientSslHandlerInitializer() {
            }

            public void connectRequested(ChannelHandlerContext ctx, ChannelStateEvent e) {
                SSLEngine sslEngine;
                if (ShieldNettyTransport.this.settings.getAsBoolean(ShieldNettyTransport.HOSTNAME_VERIFICATION_SETTING, Boolean.valueOf(true)).booleanValue()) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)e.getValue();
                    sslEngine = ShieldNettyTransport.this.clientSSLService.createSSLEngine(SslClientChannelPipelineFactory.this.sslSettings, this.getHostname(inetSocketAddress), inetSocketAddress.getPort());
                    SSLParameters parameters = new SSLParameters();
                    parameters.setEndpointIdentificationAlgorithm("HTTPS");
                    sslEngine.setSSLParameters(parameters);
                } else {
                    sslEngine = ShieldNettyTransport.this.clientSSLService.createSSLEngine(SslClientChannelPipelineFactory.this.sslSettings);
                }
                sslEngine.setUseClientMode(true);
                ctx.getPipeline().replace((ChannelHandler)this, "ssl", (ChannelHandler)new SslHandler(sslEngine));
                ctx.getPipeline().addAfter("ssl", "handshake", (ChannelHandler)new HandshakeWaitingHandler(ShieldNettyTransport.this.logger));
                ctx.sendDownstream((ChannelEvent)e);
            }

            @SuppressForbidden(reason="need to use getHostName to resolve DNS name for SSL connections and hostname verification")
            private String getHostname(InetSocketAddress inetSocketAddress) {
                String hostname = ShieldNettyTransport.this.settings.getAsBoolean(ShieldNettyTransport.HOSTNAME_VERIFICATION_RESOLVE_NAME_SETTING, Boolean.valueOf(true)) != false ? inetSocketAddress.getHostName() : inetSocketAddress.getHostString();
                if (ShieldNettyTransport.this.logger.isTraceEnabled()) {
                    ShieldNettyTransport.this.logger.trace("resolved hostname [{}] for address [{}] to be used in ssl hostname verification", new Object[]{hostname, inetSocketAddress});
                }
                return hostname;
            }
        }
    }

    private class SslServerChannelPipelineFactory
    extends NettyTransport.ServerChannelPipelineFactory {
        private final Settings shieldProfileSettings;
        private final boolean profileSsl;
        private final SSLClientAuth clientAuth;

        public SslServerChannelPipelineFactory(NettyTransport nettyTransport, String name, Settings settings, Settings profileSettings) {
            super(nettyTransport, name, settings);
            ShieldNettyTransport.this.settingsFilter.filterOut("transport.profiles." + name + ".shield.*");
            this.profileSsl = profileSettings.getAsBoolean(ShieldNettyTransport.TRANSPORT_PROFILE_SSL_SETTING, Boolean.valueOf(ShieldNettyTransport.this.ssl));
            this.clientAuth = SSLClientAuth.parse(profileSettings.get(ShieldNettyTransport.TRANSPORT_PROFILE_CLIENT_AUTH_SETTING, settings.get(ShieldNettyTransport.TRANSPORT_CLIENT_AUTH_SETTING)), TRANSPORT_CLIENT_AUTH_DEFAULT);
            this.shieldProfileSettings = profileSettings.getByPrefix("shield.");
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = super.getPipeline();
            if (this.profileSsl) {
                SSLEngine serverEngine = ShieldNettyTransport.this.serverSslService.createSSLEngine(this.shieldProfileSettings);
                serverEngine.setUseClientMode(false);
                this.clientAuth.configure(serverEngine);
                pipeline.addFirst("ssl", (ChannelHandler)new SslHandler(serverEngine));
            }
            if (ShieldNettyTransport.this.authenticator != null) {
                pipeline.addFirst("ipfilter", (ChannelHandler)new IPFilterNettyUpstreamHandler(ShieldNettyTransport.this.authenticator, this.name));
            }
            return pipeline;
        }
    }
}

