/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.rest.action.user;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;
import org.elasticsearch.shield.action.user.PutUserRequestBuilder;
import org.elasticsearch.shield.action.user.PutUserResponse;
import org.elasticsearch.shield.client.ShieldClient;

public class RestPutUserAction
extends BaseRestHandler {
    @Inject
    public RestPutUserAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.POST, "/_shield/user/{username}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.PUT, "/_shield/user/{username}", (RestHandler)this);
    }

    protected void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        PutUserRequestBuilder requestBuilder = new ShieldClient((ElasticsearchClient)client).preparePutUser(request.param("username"), request.content());
        if (request.hasParam("refresh")) {
            requestBuilder.refresh(request.paramAsBoolean("refresh", true));
        }
        requestBuilder.execute((ActionListener)new RestBuilderListener<PutUserResponse>(channel){

            public RestResponse buildResponse(PutUserResponse putUserResponse, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(RestStatus.OK, builder.startObject().field("user", (ToXContent)putUserResponse).endObject());
            }
        });
    }
}

