/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.rest.action.role;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;
import org.elasticsearch.shield.action.role.PutRoleRequestBuilder;
import org.elasticsearch.shield.action.role.PutRoleResponse;
import org.elasticsearch.shield.client.ShieldClient;

public class RestPutRoleAction
extends BaseRestHandler {
    @Inject
    public RestPutRoleAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.POST, "/_shield/role/{name}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.PUT, "/_shield/role/{name}", (RestHandler)this);
    }

    protected void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        PutRoleRequestBuilder requestBuilder = new ShieldClient((ElasticsearchClient)client).preparePutRole(request.param("name"), request.content());
        if (request.hasParam("refresh")) {
            requestBuilder.refresh(request.paramAsBoolean("refresh", true));
        }
        requestBuilder.execute((ActionListener)new RestBuilderListener<PutRoleResponse>(channel){

            public RestResponse buildResponse(PutRoleResponse putRoleResponse, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(RestStatus.OK, builder.startObject().field("role", (ToXContent)putRoleResponse).endObject());
            }
        });
    }
}

