/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc;

import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.User;

public class AnonymousService {
    public static final String SETTING_AUTHORIZATION_EXCEPTION_ENABLED = "shield.authc.anonymous.authz_exception";
    static final String ANONYMOUS_USERNAME = "_es_anonymous_user";
    @Nullable
    private final User anonymousUser;
    private final boolean authzExceptionEnabled;

    @Inject
    public AnonymousService(Settings settings) {
        this.anonymousUser = AnonymousService.resolveAnonymousUser(settings);
        this.authzExceptionEnabled = settings.getAsBoolean(SETTING_AUTHORIZATION_EXCEPTION_ENABLED, Boolean.valueOf(true));
    }

    public boolean enabled() {
        return this.anonymousUser != null;
    }

    public boolean isAnonymous(User user) {
        if (this.enabled()) {
            return this.anonymousUser.equals(user);
        }
        return false;
    }

    public User anonymousUser() {
        return this.anonymousUser;
    }

    public boolean authorizationExceptionsEnabled() {
        return this.authzExceptionEnabled;
    }

    static User resolveAnonymousUser(Settings settings) {
        String[] roles = settings.getAsArray("shield.authc.anonymous.roles", null);
        if (roles == null) {
            return null;
        }
        String username = settings.get("shield.authc.anonymous.username", ANONYMOUS_USERNAME);
        return new User(username, roles);
    }
}

