/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.audit.logfile;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.shield.InternalShieldUser;
import org.elasticsearch.shield.InternalSystemUser;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.audit.AuditTrail;
import org.elasticsearch.shield.audit.AuditUtil;
import org.elasticsearch.shield.authc.AuthenticationToken;
import org.elasticsearch.shield.authz.Privilege;
import org.elasticsearch.shield.rest.RemoteHostHeader;
import org.elasticsearch.shield.transport.filter.ShieldIpFilterRule;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportMessage;

public class LoggingAuditTrail
extends AbstractLifecycleComponent<LoggingAuditTrail>
implements AuditTrail {
    public static final String NAME = "logfile";
    private final ESLogger logger;
    private final Transport transport;
    private String prefix;

    @Override
    public String name() {
        return NAME;
    }

    @Inject
    public LoggingAuditTrail(Settings settings, Transport transport) {
        this(settings, transport, Loggers.getLogger(LoggingAuditTrail.class));
    }

    LoggingAuditTrail(Settings settings, Transport transport, ESLogger logger) {
        this("", settings, transport, logger);
    }

    LoggingAuditTrail(String prefix, Settings settings, Transport transport, ESLogger logger) {
        super(settings);
        this.logger = logger;
        this.prefix = prefix;
        this.transport = transport;
    }

    protected void doStart() {
        if (this.transport.lifecycleState() == Lifecycle.State.STARTED) {
            this.prefix = LoggingAuditTrail.resolvePrefix(this.settings, this.transport);
        } else {
            this.transport.addLifecycleListener(new LifecycleListener(){

                public void afterStart() {
                    LoggingAuditTrail.this.prefix = LoggingAuditTrail.resolvePrefix(LoggingAuditTrail.this.settings, LoggingAuditTrail.this.transport);
                }
            });
        }
    }

    protected void doStop() {
    }

    protected void doClose() {
    }

    @Override
    public void anonymousAccessDenied(String action, TransportMessage<?> message) {
        String indices = LoggingAuditTrail.indicesString(message);
        if (indices != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{}[transport] [anonymous_access_denied]\t{}, action=[{}], indices=[{}], request=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), action, indices, message.getClass().getSimpleName()});
            } else {
                this.logger.warn("{}[transport] [anonymous_access_denied]\t{}, action=[{}], indices=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), action, indices});
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}[transport] [anonymous_access_denied]\t{}, action=[{}], request=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), action, message.getClass().getSimpleName()});
        } else {
            this.logger.warn("{}[transport] [anonymous_access_denied]\t{}, action=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), action});
        }
    }

    @Override
    public void anonymousAccessDenied(RestRequest request) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}[rest] [anonymous_access_denied]\t{}, uri=[{}], request_body=[{}]", new Object[]{this.prefix, LoggingAuditTrail.hostAttributes(request), request.uri(), AuditUtil.restRequestContent(request)});
        } else {
            this.logger.warn("{}[rest] [anonymous_access_denied]\t{}, uri=[{}]", new Object[]{this.prefix, LoggingAuditTrail.hostAttributes(request), request.uri()});
        }
    }

    @Override
    public void authenticationFailed(AuthenticationToken token, String action, TransportMessage<?> message) {
        String indices = LoggingAuditTrail.indicesString(message);
        if (indices != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{}[transport] [authentication_failed]\t{}, principal=[{}], action=[{}], indices=[{}], request=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), token.principal(), action, indices, message.getClass().getSimpleName()});
            } else {
                this.logger.error("{}[transport] [authentication_failed]\t{}, principal=[{}], action=[{}], indices=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), token.principal(), action, indices});
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}[transport] [authentication_failed]\t{}, principal=[{}], action=[{}], request=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), token.principal(), action, message.getClass().getSimpleName()});
        } else {
            this.logger.error("{}[transport] [authentication_failed]\t{}, principal=[{}], action=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), token.principal(), action});
        }
    }

    @Override
    public void authenticationFailed(RestRequest request) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}[rest] [authentication_failed]\t{}, uri=[{}], request_body=[{}]", new Object[]{this.prefix, LoggingAuditTrail.hostAttributes(request), request.uri(), AuditUtil.restRequestContent(request)});
        } else {
            this.logger.error("{}[rest] [authentication_failed]\t{}, uri=[{}]", new Object[]{this.prefix, LoggingAuditTrail.hostAttributes(request), request.uri()});
        }
    }

    @Override
    public void authenticationFailed(String action, TransportMessage<?> message) {
        String indices = LoggingAuditTrail.indicesString(message);
        if (indices != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{}[transport] [authentication_failed]\t{}, action=[{}], indices=[{}], request=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), action, indices, message.getClass().getSimpleName()});
            } else {
                this.logger.error("{}[transport] [authentication_failed]\t{}, action=[{}], indices=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), action, indices});
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}[transport] [authentication_failed]\t{}, action=[{}], request=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), action, message.getClass().getSimpleName()});
        } else {
            this.logger.error("{}[transport] [authentication_failed]\t{}, action=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), action});
        }
    }

    @Override
    public void authenticationFailed(AuthenticationToken token, RestRequest request) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}[rest] [authentication_failed]\t{}, principal=[{}], uri=[{}], request_body=[{}]", new Object[]{this.prefix, LoggingAuditTrail.hostAttributes(request), token.principal(), request.uri(), AuditUtil.restRequestContent(request)});
        } else {
            this.logger.error("{}[rest] [authentication_failed]\t{}, principal=[{}], uri=[{}]", new Object[]{this.prefix, LoggingAuditTrail.hostAttributes(request), token.principal(), request.uri()});
        }
    }

    @Override
    public void authenticationFailed(String realm, AuthenticationToken token, String action, TransportMessage<?> message) {
        if (this.logger.isTraceEnabled()) {
            String indices = LoggingAuditTrail.indicesString(message);
            if (indices != null) {
                this.logger.trace("{}[transport] [authentication_failed]\trealm=[{}], {}, principal=[{}], action=[{}], indices=[{}], request=[{}]", new Object[]{this.prefix, realm, LoggingAuditTrail.originAttributes(message, this.transport), token.principal(), action, indices, message.getClass().getSimpleName()});
            } else {
                this.logger.trace("{}[transport] [authentication_failed]\trealm=[{}], {}, principal=[{}], action=[{}], request=[{}]", new Object[]{this.prefix, realm, LoggingAuditTrail.originAttributes(message, this.transport), token.principal(), action, message.getClass().getSimpleName()});
            }
        }
    }

    @Override
    public void authenticationFailed(String realm, AuthenticationToken token, RestRequest request) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("{}[rest] [authentication_failed]\trealm=[{}], {}, principal=[{}], uri=[{}], request_body=[{}]", new Object[]{this.prefix, realm, LoggingAuditTrail.hostAttributes(request), token.principal(), request.uri(), AuditUtil.restRequestContent(request)});
        }
    }

    @Override
    public void accessGranted(User user, String action, TransportMessage<?> message) {
        String indices = LoggingAuditTrail.indicesString(message);
        if (InternalSystemUser.is(user) && Privilege.SYSTEM.predicate().apply((Object)action) || InternalShieldUser.is(user)) {
            if (this.logger.isTraceEnabled()) {
                if (indices != null) {
                    this.logger.trace("{}[transport] [access_granted]\t{}, {}, action=[{}], indices=[{}], request=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), LoggingAuditTrail.principal(user), action, indices, message.getClass().getSimpleName()});
                } else {
                    this.logger.trace("{}[transport] [access_granted]\t{}, {}, action=[{}], request=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), LoggingAuditTrail.principal(user), action, message.getClass().getSimpleName()});
                }
            }
            return;
        }
        if (indices != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{}[transport] [access_granted]\t{}, {}, action=[{}], indices=[{}], request=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), LoggingAuditTrail.principal(user), action, indices, message.getClass().getSimpleName()});
            } else {
                this.logger.info("{}[transport] [access_granted]\t{}, {}, action=[{}], indices=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), LoggingAuditTrail.principal(user), action, indices});
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}[transport] [access_granted]\t{}, {}, action=[{}], request=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), LoggingAuditTrail.principal(user), action, message.getClass().getSimpleName()});
        } else {
            this.logger.info("{}[transport] [access_granted]\t{}, {}, action=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), LoggingAuditTrail.principal(user), action});
        }
    }

    @Override
    public void accessDenied(User user, String action, TransportMessage<?> message) {
        String indices = LoggingAuditTrail.indicesString(message);
        if (indices != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{}[transport] [access_denied]\t{}, {}, action=[{}], indices=[{}], request=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), LoggingAuditTrail.principal(user), action, indices, message.getClass().getSimpleName()});
            } else {
                this.logger.error("{}[transport] [access_denied]\t{}, {}, action=[{}], indices=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), LoggingAuditTrail.principal(user), action, indices});
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}[transport] [access_denied]\t{}, {}, action=[{}], request=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), LoggingAuditTrail.principal(user), action, message.getClass().getSimpleName()});
        } else {
            this.logger.error("{}[transport] [access_denied]\t{}, {}, action=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), LoggingAuditTrail.principal(user), action});
        }
    }

    @Override
    public void tamperedRequest(String action, TransportMessage<?> message) {
        String indices = LoggingAuditTrail.indicesString(message);
        if (indices != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{}[transport] [tampered_request]\t{}, action=[{}], indices=[{}], request=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), action, indices, message.getClass().getSimpleName()});
            } else {
                this.logger.error("{}[transport] [tampered_request]\t{}, action=[{}], indices=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), action, indices});
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}[transport] [tampered_request]\t{}, action=[{}], request=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), action, message.getClass().getSimpleName()});
        } else {
            this.logger.error("{}[transport] [tampered_request]\t{}, action=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), action});
        }
    }

    @Override
    public void tamperedRequest(User user, String action, TransportMessage<?> request) {
        String indices = LoggingAuditTrail.indicesString(request);
        if (indices != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{}[transport] [tampered_request]\t{}, {}, action=[{}], indices=[{}], request=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(request, this.transport), LoggingAuditTrail.principal(user), action, indices, request.getClass().getSimpleName()});
            } else {
                this.logger.error("{}[transport] [tampered_request]\t{}, {}, action=[{}], indices=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(request, this.transport), LoggingAuditTrail.principal(user), action, indices});
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}[transport] [tampered_request]\t{}, {}, action=[{}], request=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(request, this.transport), LoggingAuditTrail.principal(user), action, request.getClass().getSimpleName()});
        } else {
            this.logger.error("{}[transport] [tampered_request]\t{}, {}, action=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(request, this.transport), LoggingAuditTrail.principal(user), action});
        }
    }

    @Override
    public void connectionGranted(InetAddress inetAddress, String profile, ShieldIpFilterRule rule) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("{}[ip_filter] [connection_granted]\torigin_address=[{}], transport_profile=[{}], rule=[{}]", new Object[]{this.prefix, NetworkAddress.formatAddress((InetAddress)inetAddress), profile, rule});
        }
    }

    @Override
    public void connectionDenied(InetAddress inetAddress, String profile, ShieldIpFilterRule rule) {
        this.logger.error("{}[ip_filter] [connection_denied]\torigin_address=[{}], transport_profile=[{}], rule=[{}]", new Object[]{this.prefix, NetworkAddress.formatAddress((InetAddress)inetAddress), profile, rule});
    }

    @Override
    public void runAsGranted(User user, String action, TransportMessage<?> message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}[transport] [run_as_granted]\t{}, principal=[{}], run_as_principal=[{}], action=[{}], request=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), user.principal(), user.runAs().principal(), action, message.getClass().getSimpleName()});
        } else {
            this.logger.info("{}[transport] [run_as_granted]\t{}, principal=[{}], run_as_principal=[{}], action=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), user.principal(), user.runAs().principal(), action});
        }
    }

    @Override
    public void runAsDenied(User user, String action, TransportMessage<?> message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}[transport] [run_as_denied]\t{}, principal=[{}], run_as_principal=[{}], action=[{}], request=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), user.principal(), user.runAs().principal(), action, message.getClass().getSimpleName()});
        } else {
            this.logger.info("{}[transport] [run_as_denied]\t{}, principal=[{}], run_as_principal=[{}], action=[{}]", new Object[]{this.prefix, LoggingAuditTrail.originAttributes(message, this.transport), user.principal(), user.runAs().principal(), action});
        }
    }

    private static String hostAttributes(RestRequest request) {
        SocketAddress socketAddress = request.getRemoteAddress();
        String formattedAddress = socketAddress instanceof InetSocketAddress ? NetworkAddress.formatAddress((InetAddress)((InetSocketAddress)socketAddress).getAddress()) : socketAddress.toString();
        return "origin_address=[" + formattedAddress + "]";
    }

    static String originAttributes(TransportMessage message, Transport transport) {
        StringBuilder builder = new StringBuilder();
        InetSocketAddress restAddress = RemoteHostHeader.restRemoteAddress(message);
        if (restAddress != null) {
            builder.append("origin_type=[rest], origin_address=[").append(NetworkAddress.formatAddress((InetAddress)restAddress.getAddress())).append("]");
            return builder.toString();
        }
        TransportAddress address = message.remoteAddress();
        if (address != null) {
            builder.append("origin_type=[transport], ");
            if (address instanceof InetSocketTransportAddress) {
                builder.append("origin_address=[").append(NetworkAddress.formatAddress((InetAddress)((InetSocketTransportAddress)address).address().getAddress())).append("]");
            } else {
                builder.append("origin_address=[").append(address).append("]");
            }
            return builder.toString();
        }
        return builder.append("origin_type=[local_node], origin_address=[").append(transport.boundAddress().publishAddress().getAddress()).append("]").toString();
    }

    static String resolvePrefix(Settings settings, Transport transport) {
        String name;
        String hostName;
        String address;
        StringBuilder builder = new StringBuilder();
        if (settings.getAsBoolean("shield.audit.logfile.prefix.emit_node_host_address", Boolean.valueOf(false)).booleanValue() && (address = transport.boundAddress().publishAddress().getAddress()) != null) {
            builder.append("[").append(address).append("] ");
        }
        if (settings.getAsBoolean("shield.audit.logfile.prefix.emit_node_host_name", Boolean.valueOf(false)).booleanValue() && (hostName = transport.boundAddress().publishAddress().getHost()) != null) {
            builder.append("[").append(hostName).append("] ");
        }
        if (settings.getAsBoolean("shield.audit.logfile.prefix.emit_node_name", Boolean.valueOf(true)).booleanValue() && (name = settings.get("name")) != null) {
            builder.append("[").append(name).append("] ");
        }
        return builder.toString();
    }

    static String indicesString(TransportMessage<?> message) {
        Object[] indices = AuditUtil.indices(message);
        return indices == null ? null : Strings.arrayToCommaDelimitedString((Object[])indices);
    }

    static String principal(User user) {
        StringBuilder builder = new StringBuilder("principal=[");
        if (user.runAs() != null) {
            builder.append(user.runAs().principal()).append("], run_by_principal=[");
        }
        return builder.append(user.principal()).append("]").toString();
    }
}

