/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action.user;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.action.user.DeleteUserRequest;
import org.elasticsearch.shield.action.user.DeleteUserResponse;
import org.elasticsearch.shield.authc.esnative.ESNativeUsersStore;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteUserAction
extends HandledTransportAction<DeleteUserRequest, DeleteUserResponse> {
    private final ESNativeUsersStore usersStore;

    @Inject
    public TransportDeleteUserAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ESNativeUsersStore usersStore, TransportService transportService) {
        super(settings, "cluster:admin/xpack/security/user/delete", threadPool, transportService, actionFilters, indexNameExpressionResolver, DeleteUserRequest.class);
        this.usersStore = usersStore;
    }

    protected void doExecute(DeleteUserRequest request, final ActionListener<DeleteUserResponse> listener) {
        try {
            this.usersStore.deleteUser(request, new ActionListener<Boolean>(){

                public void onResponse(Boolean found) {
                    listener.onResponse((Object)new DeleteUserResponse(found));
                }

                public void onFailure(Throwable e) {
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            this.logger.error("failed to delete user [{}]", (Throwable)e, new Object[0]);
            listener.onFailure((Throwable)e);
        }
    }
}

