/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action.role;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.action.role.GetRolesRequest;
import org.elasticsearch.shield.action.role.GetRolesResponse;
import org.elasticsearch.shield.authz.RoleDescriptor;
import org.elasticsearch.shield.authz.esnative.ESNativeRolesStore;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetRolesAction
extends HandledTransportAction<GetRolesRequest, GetRolesResponse> {
    private final ESNativeRolesStore rolesStore;

    @Inject
    public TransportGetRolesAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ESNativeRolesStore rolesStore, TransportService transportService) {
        super(settings, "cluster:admin/xpack/security/role/get", threadPool, transportService, actionFilters, indexNameExpressionResolver, GetRolesRequest.class);
        this.rolesStore = rolesStore;
    }

    protected void doExecute(final GetRolesRequest request, final ActionListener<GetRolesResponse> listener) {
        if (request.names().length == 1) {
            final String rolename = request.names()[0];
            this.rolesStore.getRoleDescriptor(rolename, new ActionListener<RoleDescriptor>(){

                public void onResponse(RoleDescriptor roleD) {
                    if (roleD == null) {
                        listener.onResponse((Object)new GetRolesResponse(new RoleDescriptor[0]));
                    } else {
                        listener.onResponse((Object)new GetRolesResponse(roleD));
                    }
                }

                public void onFailure(Throwable t) {
                    TransportGetRolesAction.this.logger.error("failed to retrieve role [{}]", t, new Object[]{rolename});
                    listener.onFailure(t);
                }
            });
        } else {
            this.rolesStore.getRoleDescriptors(request.names(), new ActionListener<List<RoleDescriptor>>(){

                public void onResponse(List<RoleDescriptor> roles) {
                    listener.onResponse((Object)new GetRolesResponse(roles.toArray(new RoleDescriptor[roles.size()])));
                }

                public void onFailure(Throwable t) {
                    TransportGetRolesAction.this.logger.error("failed to retrieve role [{}]", t, new Object[]{Strings.arrayToDelimitedString((Object[])request.names(), (String)",")});
                }
            });
        }
    }
}

