/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.ByteBufferStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.shield.InternalShieldUser;
import org.elasticsearch.shield.InternalSystemUser;
import org.elasticsearch.shield.audit.index.InternalAuditUser;

public class User
implements ToXContent {
    private final String username;
    private final String[] roles;
    private final User runAs;
    private final Map<String, Object> metadata;
    @Nullable
    private final String fullName;
    @Nullable
    private final String email;

    public User(String username, String ... roles) {
        this(username, roles, (String)null, (String)null, (Map<String, Object>)null);
    }

    public User(String username, String[] roles, User runAs) {
        this(username, roles, null, null, null, runAs);
    }

    public User(String username, String[] roles, String fullName, String email, Map<String, Object> metadata) {
        this.username = username;
        this.roles = roles == null ? Strings.EMPTY_ARRAY : roles;
        this.metadata = metadata != null ? Collections.unmodifiableMap(metadata) : Collections.emptyMap();
        this.fullName = fullName;
        this.email = email;
        this.runAs = null;
    }

    public User(String username, String[] roles, String fullName, String email, Map<String, Object> metadata, User runAs) {
        this.username = username;
        this.roles = roles == null ? Strings.EMPTY_ARRAY : roles;
        this.metadata = metadata != null ? Collections.unmodifiableMap(metadata) : Collections.emptyMap();
        this.fullName = fullName;
        this.email = email;
        assert (runAs == null || runAs.runAs() == null) : "the run_as user should not be a user that can run as";
        if (runAs == InternalSystemUser.INSTANCE) {
            throw new ElasticsearchSecurityException("invalid run_as user", new Object[0]);
        }
        this.runAs = runAs;
    }

    public String principal() {
        return this.username;
    }

    public String[] roles() {
        return this.roles;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public String fullName() {
        return this.fullName;
    }

    public String email() {
        return this.email;
    }

    public User runAs() {
        return this.runAs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("User[username=").append(this.username);
        sb.append(",roles=[").append(Strings.arrayToCommaDelimitedString((Object[])this.roles)).append("]");
        sb.append(",fullName=").append(this.fullName);
        sb.append(",email=").append(this.email);
        sb.append(",metadata=");
        User.append(sb, this.metadata);
        if (this.runAs != null) {
            sb.append(",runAs=[").append(this.runAs.toString()).append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        if (!this.username.equals(user.username)) {
            return false;
        }
        if (!Arrays.equals(this.roles, user.roles)) {
            return false;
        }
        if (this.runAs != null ? !this.runAs.equals(user.runAs) : user.runAs != null) {
            return false;
        }
        if (!this.metadata.equals(user.metadata)) {
            return false;
        }
        if (this.fullName != null ? !this.fullName.equals(user.fullName) : user.fullName != null) {
            return false;
        }
        return !(this.email == null ? user.email != null : !this.email.equals(user.email));
    }

    public int hashCode() {
        int result = this.username.hashCode();
        result = 31 * result + Arrays.hashCode(this.roles);
        result = 31 * result + (this.runAs != null ? this.runAs.hashCode() : 0);
        result = 31 * result + this.metadata.hashCode();
        result = 31 * result + (this.fullName != null ? this.fullName.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Fields.USERNAME.getPreferredName(), this.username);
        builder.array(Fields.ROLES.getPreferredName(), this.roles);
        builder.field(Fields.FULL_NAME.getPreferredName(), this.fullName);
        builder.field(Fields.EMAIL.getPreferredName(), this.email);
        builder.field(Fields.METADATA.getPreferredName(), this.metadata);
        return builder.endObject();
    }

    public static User readFrom(StreamInput input) throws IOException {
        String username;
        boolean canCheckAvailable = input instanceof ByteBufferStreamInput;
        if (input.readBoolean()) {
            String name;
            switch (name = input.readString()) {
                case "__es_system_user": {
                    return InternalSystemUser.INSTANCE;
                }
            }
            throw new IllegalStateException("invalid internal user");
        }
        switch (username = input.readString()) {
            case "__es_internal_user": {
                return InternalShieldUser.INSTANCE;
            }
            case "__indexing_audit_user": {
                return InternalAuditUser.INSTANCE;
            }
        }
        String[] roles = input.readStringArray();
        if (input.readBoolean()) {
            String runAsUsername = input.readString();
            String[] runAsRoles = input.readStringArray();
            if (!canCheckAvailable || input.available() > 0) {
                Map runAsMetadata = input.readMap();
                String runAsFullName = input.readOptionalString();
                String runAsEmail = input.readOptionalString();
                User runAs = new User(runAsUsername, runAsRoles, runAsFullName, runAsEmail, runAsMetadata);
                Map metadata = input.readMap();
                String fullName = input.readOptionalString();
                String email = input.readOptionalString();
                return new User(username, roles, fullName, email, metadata, runAs);
            }
            User runAs = new User(runAsUsername, runAsRoles);
            return new User(username, roles, runAs);
        }
        if (canCheckAvailable && input.available() == 0) {
            return new User(username, roles);
        }
        Map metadata = input.readMap();
        String fullName = input.readOptionalString();
        String email = input.readOptionalString();
        return new User(username, roles, fullName, email, metadata);
    }

    public static void writeTo(User user, StreamOutput output) throws IOException {
        if (InternalSystemUser.is(user)) {
            output.writeBoolean(true);
            output.writeString("__es_system_user");
        } else {
            output.writeBoolean(false);
            output.writeString(user.username);
            output.writeStringArray(user.roles);
            if (user.runAs == null) {
                output.writeBoolean(false);
            } else {
                output.writeBoolean(true);
                output.writeString(user.runAs.username);
                output.writeStringArray(user.runAs.roles);
                output.writeMap(user.runAs.metadata);
                output.writeOptionalString(user.runAs.fullName);
                output.writeOptionalString(user.runAs.email);
            }
            output.writeMap(user.metadata);
            output.writeOptionalString(user.fullName);
            output.writeOptionalString(user.email);
        }
    }

    public static void append(StringBuilder sb, Object object) {
        if (object == null) {
            sb.append((Object)null);
        }
        if (object instanceof Map) {
            sb.append("{");
            for (Map.Entry entry : ((Map)object).entrySet()) {
                sb.append((String)entry.getKey()).append("=");
                User.append(sb, entry.getValue());
            }
            sb.append("}");
        } else if (object instanceof Collection) {
            sb.append("[");
            boolean first = true;
            for (Object item : (Collection)object) {
                if (!first) {
                    sb.append(",");
                }
                User.append(sb, item);
                first = false;
            }
            sb.append("]");
        } else if (object.getClass().isArray()) {
            sb.append("[");
            for (int i = 0; i < Array.getLength(object); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                User.append(sb, Array.get(object, i));
            }
            sb.append("]");
        } else {
            sb.append(object);
        }
    }

    @Deprecated
    public class Simple
    extends User {
        public Simple(String username, String[] roles) {
            this(username, roles, null);
        }

        public Simple(String username, String[] roles, User runAs) {
            super(username, roles, runAs);
        }

        public final boolean isSystem() {
            return false;
        }
    }

    public static interface Fields {
        public static final ParseField USERNAME = new ParseField("username", new String[0]);
        public static final ParseField PASSWORD = new ParseField("password", new String[0]);
        public static final ParseField ROLES = new ParseField("roles", new String[0]);
        public static final ParseField FULL_NAME = new ParseField("full_name", new String[0]);
        public static final ParseField EMAIL = new ParseField("email", new String[0]);
        public static final ParseField METADATA = new ParseField("metadata", new String[0]);
    }
}

