/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.support;

import java.util.concurrent.ScheduledFuture;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.threadpool.ThreadPool;

public class SelfReschedulingRunnable
extends AbstractRunnable {
    private final AbstractRunnable runnable;
    private final ThreadPool threadPool;
    private final TimeValue interval;
    private final String executorName;
    private final ESLogger logger;
    private ScheduledFuture<?> scheduledFuture = null;
    private volatile boolean run = false;

    public SelfReschedulingRunnable(AbstractRunnable runnable, ThreadPool threadPool, TimeValue interval, String executorName, ESLogger logger) {
        this.runnable = runnable;
        this.threadPool = threadPool;
        this.interval = interval;
        this.executorName = executorName;
        this.logger = logger;
    }

    public synchronized void start() {
        if (this.run || this.scheduledFuture != null) {
            throw new IllegalStateException("start should not be called again before calling stop");
        }
        this.run = true;
        this.scheduledFuture = this.threadPool.schedule(this.interval, this.executorName, (Runnable)((Object)this));
    }

    public synchronized void onAfter() {
        if (this.run) {
            this.scheduledFuture = this.threadPool.schedule(this.interval, this.executorName, (Runnable)((Object)this));
        }
    }

    public void onFailure(Throwable t) {
        this.logger.warn("failed to run scheduled task", t, new Object[0]);
    }

    protected void doRun() throws Exception {
        if (this.run) {
            this.runnable.run();
        }
    }

    public synchronized void stop() {
        if (!this.run) {
            throw new IllegalStateException("stop called but not started or stop called twice");
        }
        this.run = false;
        FutureUtils.cancel(this.scheduledFuture);
        this.scheduledFuture = null;
    }

    ScheduledFuture<?> getScheduledFuture() {
        return this.scheduledFuture;
    }
}

