/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authz.accesscontrol;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConjunctionDISI;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.SparseFixedBitSet;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.support.LoggerMessageFormat;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.IndexSearcherWrapper;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardUtils;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.shield.authz.accesscontrol.DocumentSubsetReader;
import org.elasticsearch.shield.authz.accesscontrol.FieldSubsetReader;
import org.elasticsearch.shield.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.shield.authz.accesscontrol.RequestContext;
import org.elasticsearch.shield.license.ShieldLicenseState;
import org.elasticsearch.shield.support.Exceptions;

public final class ShieldIndexSearcherWrapper
extends AbstractIndexShardComponent
implements IndexSearcherWrapper {
    private final MapperService mapperService;
    private final Set<String> allowedMetaFields;
    private final IndexQueryParserService parserService;
    private final BitsetFilterCache bitsetFilterCache;
    private final ShieldLicenseState shieldLicenseState;
    private final IndicesLifecycle indicesLifecycle;
    private volatile boolean shardStarted = false;

    @Inject
    public ShieldIndexSearcherWrapper(ShardId shardId, IndexSettingsService indexSettingsService, IndexQueryParserService parserService, IndicesLifecycle indicesLifecycle, MapperService mapperService, BitsetFilterCache bitsetFilterCache, ShieldLicenseState shieldLicenseState) {
        super(shardId, indexSettingsService.getSettings());
        this.mapperService = mapperService;
        this.parserService = parserService;
        this.bitsetFilterCache = bitsetFilterCache;
        this.shieldLicenseState = shieldLicenseState;
        this.indicesLifecycle = indicesLifecycle;
        indicesLifecycle.addListener((IndicesLifecycle.Listener)new ShardLifecycleListener());
        HashSet<String> allowedMetaFields = new HashSet<String>();
        allowedMetaFields.addAll(Arrays.asList(MapperService.getAllMetaFields()));
        allowedMetaFields.add("_field_names");
        allowedMetaFields.add("_source");
        allowedMetaFields.add("_version");
        allowedMetaFields.remove("_all");
        this.allowedMetaFields = Collections.unmodifiableSet(allowedMetaFields);
    }

    public DirectoryReader wrap(DirectoryReader reader) {
        if (!this.shieldLicenseState.documentAndFieldLevelSecurityEnabled()) {
            return reader;
        }
        Set<String> allowedMetaFields = this.allowedMetaFields;
        try {
            RequestContext context = RequestContext.current();
            if (context == null) {
                if (!this.shardStarted) {
                    this.logger.trace("shard is not started and could not locate the current request, fls and dls will not be applied", new Object[0]);
                    return reader;
                }
                throw new IllegalStateException("can't locate the origin of the current request");
            }
            IndicesAccessControl indicesAccessControl = (IndicesAccessControl)context.getRequest().getFromContext((Object)"_indices_permissions");
            if (indicesAccessControl == null) {
                throw Exceptions.authorizationError("no indices permissions found", new Object[0]);
            }
            ShardId shardId = ShardUtils.extractShardId((DirectoryReader)reader);
            if (shardId == null) {
                throw new IllegalStateException(LoggerMessageFormat.format((String)"couldn't extract shardId from reader [{}]", (Object[])new Object[]{reader}));
            }
            IndicesAccessControl.IndexAccessControl permissions = indicesAccessControl.getIndexPermissions(shardId.getIndex());
            if (permissions == null) {
                return reader;
            }
            if (permissions.getQueries() != null) {
                BooleanQuery.Builder filter = new BooleanQuery.Builder();
                for (BytesReference bytesReference : permissions.getQueries()) {
                    ParsedQuery parsedQuery = this.parserService.parse(bytesReference);
                    filter.add(parsedQuery.query(), BooleanClause.Occur.SHOULD);
                }
                filter.setMinimumNumberShouldMatch(1);
                reader = DocumentSubsetReader.wrap(reader, this.bitsetFilterCache, (Query)new ConstantScoreQuery((Query)filter.build()));
            }
            if (permissions.getFields() != null) {
                HashSet<String> allowedFields = new HashSet<String>(allowedMetaFields);
                for (String field : permissions.getFields()) {
                    allowedFields.addAll(this.mapperService.simpleMatchToIndexNames(field));
                }
                this.resolveParentChildJoinFields(allowedFields);
                reader = FieldSubsetReader.wrap(reader, allowedFields);
            }
            return reader;
        }
        catch (IOException e) {
            this.logger.error("Unable to apply field level security", new Object[0]);
            throw ExceptionsHelper.convertToElastic((Throwable)e);
        }
    }

    public IndexSearcher wrap(EngineConfig engineConfig, IndexSearcher searcher) throws EngineException {
        if (!this.shieldLicenseState.documentAndFieldLevelSecurityEnabled()) {
            return searcher;
        }
        DirectoryReader directoryReader = (DirectoryReader)searcher.getIndexReader();
        if (directoryReader instanceof DocumentSubsetReader.DocumentSubsetDirectoryReader) {
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)directoryReader){

                protected void search(List<LeafReaderContext> leaves, Weight weight, Collector collector) throws IOException {
                    for (LeafReaderContext ctx : leaves) {
                        Scorer scorer;
                        LeafCollector leafCollector;
                        try {
                            leafCollector = collector.getLeafCollector(ctx);
                        }
                        catch (CollectionTerminatedException e) {
                            continue;
                        }
                        DocumentSubsetReader reader = (DocumentSubsetReader)ctx.reader();
                        BitSet roleQueryBits = reader.getRoleQueryBits();
                        if (roleQueryBits == null || (scorer = weight.scorer(ctx)) == null) continue;
                        try {
                            if (roleQueryBits instanceof SparseFixedBitSet) {
                                SparseFixedBitSet sparseFixedBitSet = (SparseFixedBitSet)roleQueryBits;
                                Bits realLiveDocs = reader.getWrappedLiveDocs();
                                ShieldIndexSearcherWrapper.intersectScorerAndRoleBits(scorer, sparseFixedBitSet, leafCollector, realLiveDocs);
                                continue;
                            }
                            BulkScorer bulkScorer = weight.bulkScorer(ctx);
                            Bits liveDocs = reader.getLiveDocs();
                            bulkScorer.score(leafCollector, liveDocs);
                        }
                        catch (CollectionTerminatedException collectionTerminatedException) {}
                    }
                }
            };
            indexSearcher.setQueryCache(engineConfig.getQueryCache());
            indexSearcher.setQueryCachingPolicy(engineConfig.getQueryCachingPolicy());
            indexSearcher.setSimilarity(engineConfig.getSimilarity());
            return indexSearcher;
        }
        return searcher;
    }

    public Set<String> getAllowedMetaFields() {
        return this.allowedMetaFields;
    }

    private void resolveParentChildJoinFields(Set<String> allowedFields) {
        for (DocumentMapper mapper : this.mapperService.docMappers(false)) {
            ParentFieldMapper parentFieldMapper = mapper.parentFieldMapper();
            if (!parentFieldMapper.active()) continue;
            String joinField = ParentFieldMapper.joinField((String)parentFieldMapper.type());
            allowedFields.add(joinField);
        }
    }

    static void intersectScorerAndRoleBits(Scorer scorer, SparseFixedBitSet roleBits, LeafCollector collector, Bits acceptDocs) throws IOException {
        ConjunctionDISI iterator = ConjunctionDISI.intersectIterators(Arrays.asList(new BitSetIterator((BitSet)roleBits, (long)roleBits.approximateCardinality()), scorer.iterator()));
        int docId = iterator.nextDoc();
        while (docId < Integer.MAX_VALUE) {
            if (acceptDocs == null || acceptDocs.get(docId)) {
                collector.collect(docId);
            }
            docId = iterator.nextDoc();
        }
    }

    private class ShardLifecycleListener
    extends IndicesLifecycle.Listener {
        private ShardLifecycleListener() {
        }

        public void afterIndexShardPostRecovery(IndexShard indexShard) {
            if (ShieldIndexSearcherWrapper.this.shardId.equals((Object)indexShard.shardId())) {
                ShieldIndexSearcherWrapper.this.shardStarted = true;
                ShieldIndexSearcherWrapper.this.indicesLifecycle.removeListener((IndicesLifecycle.Listener)this);
            }
        }

        public void afterIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
            if (shardId.equals((Object)indexShard.shardId())) {
                ShieldIndexSearcherWrapper.this.indicesLifecycle.removeListener((IndicesLifecycle.Listener)this);
            }
        }
    }
}

