/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authz.accesscontrol;

import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.IndexSearcherWrapper;
import org.elasticsearch.shield.authz.accesscontrol.ShieldIndexSearcherWrapper;
import org.elasticsearch.shield.support.AbstractShieldModule;

public class AccessControlShardModule
extends AbstractShieldModule.Node {
    public static final String DLS_FLS_ENABLED_SETTING = "shield.dls_fls.enabled";

    public AccessControlShardModule(Settings settings) {
        super(settings);
    }

    @Override
    protected void configureNode() {
        if (AccessControlShardModule.enabled(this.settings)) {
            Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), IndexSearcherWrapper.class);
            this.bind(ShieldIndexSearcherWrapper.class).asEagerSingleton();
            multibinder.addBinding().to(ShieldIndexSearcherWrapper.class);
        }
    }

    public static boolean enabled(Settings settings) {
        return settings.getAsBoolean(DLS_FLS_ENABLED_SETTING, Boolean.valueOf(true));
    }
}

