/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.ldap.support;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPInterface;
import java.io.Closeable;
import java.util.List;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.unit.TimeValue;

public class LdapSession
implements Closeable {
    protected final ESLogger logger;
    protected final LDAPInterface ldap;
    protected final String userDn;
    protected final GroupsResolver groupsResolver;
    protected final TimeValue timeout;

    public LdapSession(ESLogger logger, LDAPInterface connection, String userDn, GroupsResolver groupsResolver, TimeValue timeout) {
        this.logger = logger;
        this.ldap = connection;
        this.userDn = userDn;
        this.groupsResolver = groupsResolver;
        this.timeout = timeout;
    }

    @Override
    public void close() {
        if (this.ldap instanceof LDAPConnection) {
            ((LDAPConnection)this.ldap).close();
        }
    }

    public String userDn() {
        return this.userDn;
    }

    public List<String> groups() {
        return this.groupsResolver.resolve(this.ldap, this.userDn, this.timeout, this.logger);
    }

    public static interface GroupsResolver {
        public List<String> resolve(LDAPInterface var1, String var2, TimeValue var3, ESLogger var4);
    }
}

