/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.esnative;

import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.ObjectLongHashMap;
import com.carrotsearch.hppc.ObjectLongMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectLongCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.LatchedActionListener;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.shield.InternalShieldUser;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.action.realm.ClearRealmCacheRequest;
import org.elasticsearch.shield.action.realm.ClearRealmCacheResponse;
import org.elasticsearch.shield.action.user.DeleteUserRequest;
import org.elasticsearch.shield.action.user.PutUserRequest;
import org.elasticsearch.shield.authc.AuthenticationService;
import org.elasticsearch.shield.authc.esnative.UserAndPassword;
import org.elasticsearch.shield.authc.support.Hasher;
import org.elasticsearch.shield.authc.support.SecuredString;
import org.elasticsearch.shield.client.ShieldClient;
import org.elasticsearch.shield.support.ClientWithUser;
import org.elasticsearch.shield.support.SelfReschedulingRunnable;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteTransportException;

public class ESNativeUsersStore
extends AbstractComponent
implements ClusterStateListener {
    public static final String USER_DOC_TYPE = "user";
    private final ObjectLongHashMap<String> versionMap = new ObjectLongHashMap();
    private final Hasher hasher = Hasher.BCRYPT;
    private final List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private final AtomicReference<State> state = new AtomicReference<State>(State.INITIALIZED);
    private final Provider<Client> clientProvider;
    private final Provider<AuthenticationService> authProvider;
    private final ThreadPool threadPool;
    private SelfReschedulingRunnable userPoller;
    private Client client;
    private int scrollSize;
    private TimeValue scrollKeepAlive;
    private volatile boolean shieldIndexExists = false;

    @Inject
    public ESNativeUsersStore(Settings settings, Provider<Client> clientProvider, Provider<AuthenticationService> authProvider, ThreadPool threadPool) {
        super(settings);
        this.clientProvider = clientProvider;
        this.authProvider = authProvider;
        this.threadPool = threadPool;
    }

    public User getUser(String username) {
        if (this.state() != State.STARTED) {
            this.logger.trace("attempted to get user [{}] before service was started", new Object[]{username});
            return null;
        }
        UserAndPassword uap = this.getUserAndPassword(username);
        return uap == null ? null : uap.user();
    }

    public void getUser(final String username, final ActionListener<User> listener) {
        if (this.state() != State.STARTED) {
            this.logger.trace("attempted to get user [{}] before service was started", new Object[]{username});
            listener.onFailure((Throwable)new IllegalStateException("user cannot be retrieved as native user service has not been started"));
            return;
        }
        this.getUserAndPassword(username, new ActionListener<UserAndPassword>(){

            public void onResponse(UserAndPassword uap) {
                listener.onResponse((Object)(uap == null ? null : uap.user()));
            }

            public void onFailure(Throwable t) {
                if (t instanceof IndexNotFoundException) {
                    ESNativeUsersStore.this.logger.trace("failed to retrieve user [{}] since security index does not exist", new Object[]{username});
                } else {
                    ESNativeUsersStore.this.logger.debug("failed to retrieve user [{}]", t, new Object[]{username});
                }
                listener.onResponse(null);
            }
        });
    }

    public void getUsers(String[] usernames, final ActionListener<List<User>> listener) {
        if (this.state() != State.STARTED) {
            this.logger.trace("attempted to get users before service was started", new Object[0]);
            listener.onFailure((Throwable)new IllegalStateException("users cannot be retrieved as native user service has not been started"));
            return;
        }
        try {
            final ArrayList users = new ArrayList();
            Object query = usernames == null || usernames.length == 0 ? QueryBuilders.matchAllQuery() : QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.idsQuery((String[])new String[]{USER_DOC_TYPE}).addIds(usernames));
            SearchRequest request = this.client.prepareSearch(new String[]{".security"}).setScroll(this.scrollKeepAlive).setTypes(new String[]{USER_DOC_TYPE}).setQuery((QueryBuilder)query).setSize(this.scrollSize).setFetchSource(true).request();
            request.indicesOptions().ignoreUnavailable();
            this.client.search(request, (ActionListener)new ActionListener<SearchResponse>(){
                private SearchResponse lastResponse = null;

                public void onResponse(SearchResponse resp) {
                    boolean hasHits;
                    this.lastResponse = resp;
                    boolean bl = hasHits = resp.getHits().getHits().length > 0;
                    if (hasHits) {
                        for (SearchHit hit : resp.getHits().getHits()) {
                            UserAndPassword u = ESNativeUsersStore.this.transformUser(hit.getId(), hit.getSource());
                            if (u == null) continue;
                            users.add(u.user());
                        }
                        SearchScrollRequest scrollRequest = (SearchScrollRequest)ESNativeUsersStore.this.client.prepareSearchScroll(resp.getScrollId()).setScroll(ESNativeUsersStore.this.scrollKeepAlive).request();
                        ESNativeUsersStore.this.client.searchScroll(scrollRequest, (ActionListener)this);
                    } else {
                        if (resp.getScrollId() != null) {
                            ESNativeUsersStore.this.clearScrollResponse(resp.getScrollId());
                        }
                        listener.onResponse(Collections.unmodifiableList(users));
                    }
                }

                public void onFailure(Throwable t) {
                    if (this.lastResponse != null && this.lastResponse.getScrollId() != null) {
                        ESNativeUsersStore.this.clearScrollResponse(this.lastResponse.getScrollId());
                    }
                    if (t instanceof IndexNotFoundException) {
                        ESNativeUsersStore.this.logger.trace("could not retrieve users because security index does not exist", new Object[0]);
                        listener.onResponse(Collections.emptyList());
                    } else {
                        listener.onFailure(t);
                    }
                }
            });
        }
        catch (Exception e) {
            this.logger.error("unable to retrieve users {}", (Throwable)e, new Object[]{Arrays.toString(usernames)});
            listener.onFailure((Throwable)e);
        }
    }

    private UserAndPassword getUserAndPassword(final String username) {
        final AtomicReference<Object> userRef = new AtomicReference<Object>(null);
        CountDownLatch latch = new CountDownLatch(1);
        this.getUserAndPassword(username, (ActionListener<UserAndPassword>)new LatchedActionListener((ActionListener)new ActionListener<UserAndPassword>(){

            public void onResponse(UserAndPassword user) {
                userRef.set(user);
            }

            public void onFailure(Throwable t) {
                if (t instanceof IndexNotFoundException) {
                    ESNativeUsersStore.this.logger.trace("failed to retrieve user [{}] since security index does not exist", t, new Object[]{username});
                } else {
                    ESNativeUsersStore.this.logger.error("failed to retrieve user [{}]", t, new Object[]{username});
                }
            }
        }, latch));
        try {
            latch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.error("timed out retrieving user [{}]", new Object[]{username});
            return null;
        }
        return userRef.get();
    }

    private void getUserAndPassword(final String user, final ActionListener<UserAndPassword> listener) {
        try {
            GetRequest request = (GetRequest)this.client.prepareGet(".security", USER_DOC_TYPE, user).request();
            this.client.get(request, (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    listener.onResponse((Object)ESNativeUsersStore.this.transformUser(response.getId(), response.getSource()));
                }

                public void onFailure(Throwable t) {
                    if (t instanceof IndexNotFoundException) {
                        ESNativeUsersStore.this.logger.trace("could not retrieve user [{}] because security index does not exist", t, new Object[]{user});
                    } else {
                        ESNativeUsersStore.this.logger.error("failed to retrieve user [{}]", t, new Object[]{user});
                    }
                    listener.onResponse(null);
                }
            });
        }
        catch (IndexNotFoundException infe) {
            this.logger.trace("could not retrieve user [{}] because security index does not exist", new Object[]{user});
            listener.onResponse(null);
        }
        catch (Exception e) {
            this.logger.error("unable to retrieve user [{}]", (Throwable)e, new Object[]{user});
            listener.onFailure((Throwable)e);
        }
    }

    public void putUser(PutUserRequest request, ActionListener<Boolean> listener) {
        if (this.state() != State.STARTED) {
            listener.onFailure((Throwable)new IllegalStateException("user cannot be added as native user service has not been started"));
            return;
        }
        try {
            if (request.passwordHash() == null) {
                this.updateUserWithoutPassword(request, listener);
            } else {
                this.indexUser(request, listener);
            }
        }
        catch (Exception e) {
            this.logger.error("unable to put user [{}]", (Throwable)e, new Object[]{request.username()});
            listener.onFailure((Throwable)e);
        }
    }

    private void updateUserWithoutPassword(final PutUserRequest putUserRequest, final ActionListener<Boolean> listener) {
        assert (putUserRequest.passwordHash() == null);
        this.client.prepareUpdate(".security", USER_DOC_TYPE, putUserRequest.username()).setDoc(new Object[]{User.Fields.USERNAME.getPreferredName(), putUserRequest.username(), User.Fields.ROLES.getPreferredName(), putUserRequest.roles(), User.Fields.FULL_NAME.getPreferredName(), putUserRequest.fullName(), User.Fields.EMAIL.getPreferredName(), putUserRequest.email(), User.Fields.METADATA.getPreferredName(), putUserRequest.metadata()}).setRefresh(putUserRequest.refresh()).execute((ActionListener)new ActionListener<UpdateResponse>(){

            public void onResponse(UpdateResponse updateResponse) {
                assert (!updateResponse.isCreated());
                ESNativeUsersStore.this.clearRealmCache(putUserRequest.username(), listener, false);
            }

            public void onFailure(Throwable e) {
                Throwable cause = e;
                if (e instanceof RemoteTransportException && !((cause = ExceptionsHelper.unwrapCause((Throwable)e)) instanceof IndexNotFoundException) && !(cause instanceof DocumentMissingException)) {
                    listener.onFailure(e);
                    return;
                }
                ESNativeUsersStore.this.logger.debug("failed to update user document with username [{}]", cause, new Object[]{putUserRequest.username()});
                ValidationException validationException = new ValidationException();
                validationException.addValidationError("password must be specified unless you are updating an existing user");
                listener.onFailure((Throwable)validationException);
            }
        });
    }

    private void indexUser(final PutUserRequest putUserRequest, final ActionListener<Boolean> listener) {
        assert (putUserRequest.passwordHash() != null);
        this.client.prepareIndex(".security", USER_DOC_TYPE, putUserRequest.username()).setSource(new Object[]{User.Fields.USERNAME.getPreferredName(), putUserRequest.username(), User.Fields.PASSWORD.getPreferredName(), String.valueOf(putUserRequest.passwordHash()), User.Fields.ROLES.getPreferredName(), putUserRequest.roles(), User.Fields.FULL_NAME.getPreferredName(), putUserRequest.fullName(), User.Fields.EMAIL.getPreferredName(), putUserRequest.email(), User.Fields.METADATA.getPreferredName(), putUserRequest.metadata()}).setRefresh(putUserRequest.refresh()).execute((ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse indexResponse) {
                if (indexResponse.isCreated()) {
                    listener.onResponse((Object)indexResponse.isCreated());
                    return;
                }
                ESNativeUsersStore.this.clearRealmCache(putUserRequest.username(), listener, indexResponse.isCreated());
            }

            public void onFailure(Throwable e) {
                listener.onFailure(e);
            }
        });
    }

    public void deleteUser(final DeleteUserRequest deleteUserRequest, final ActionListener<Boolean> listener) {
        if (this.state() != State.STARTED) {
            listener.onFailure((Throwable)new IllegalStateException("user cannot be deleted as native user service has not been started"));
            return;
        }
        try {
            DeleteRequest request = (DeleteRequest)this.client.prepareDelete(".security", USER_DOC_TYPE, deleteUserRequest.username()).request();
            request.indicesOptions().ignoreUnavailable();
            request.refresh(deleteUserRequest.refresh());
            this.client.delete(request, (ActionListener)new ActionListener<DeleteResponse>(){

                public void onResponse(DeleteResponse deleteResponse) {
                    ESNativeUsersStore.this.clearRealmCache(deleteUserRequest.username(), listener, deleteResponse.isFound());
                }

                public void onFailure(Throwable e) {
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            this.logger.error("unable to remove user", (Throwable)e, new Object[0]);
            listener.onFailure((Throwable)e);
        }
    }

    public boolean canStart(ClusterState clusterState, boolean master) {
        if (this.state() != State.INITIALIZED) {
            return false;
        }
        if (clusterState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            this.logger.debug("native users store waiting until gateway has recovered from disk", new Object[0]);
            return false;
        }
        if (clusterState.metaData().templates().get((Object)"security-index-template") == null) {
            this.logger.debug("native users template [{}] does not exist, so service cannot start", new Object[]{"security-index-template"});
            return false;
        }
        IndexMetaData metaData = clusterState.metaData().index(".security");
        if (metaData == null) {
            this.logger.debug("security index [{}] does not exist, so service can start", new Object[]{".security"});
            return true;
        }
        if (clusterState.routingTable().index(".security").allPrimaryShardsActive()) {
            this.logger.debug("security index [{}] all primary shards started, so service can start", new Object[]{".security"});
            return true;
        }
        return false;
    }

    public void start() {
        block4: {
            try {
                if (!this.state.compareAndSet(State.INITIALIZED, State.STARTING)) break block4;
                this.client = new ClientWithUser((Client)this.clientProvider.get(), (AuthenticationService)this.authProvider.get(), InternalShieldUser.INSTANCE);
                this.scrollSize = this.settings.getAsInt("shield.authc.native.scroll.size", Integer.valueOf(1000));
                this.scrollKeepAlive = this.settings.getAsTime("shield.authc.native.scroll.keep_alive", TimeValue.timeValueSeconds((long)10L));
                UserStorePoller poller = new UserStorePoller();
                try {
                    poller.doRun();
                }
                catch (Exception e) {
                    this.logger.warn("failed to do initial poll of users", (Throwable)e, new Object[0]);
                }
                this.userPoller = new SelfReschedulingRunnable(poller, this.threadPool, this.settings.getAsTime("shield.authc.native.reload.interval", TimeValue.timeValueSeconds((long)30L)), "generic", this.logger);
                this.userPoller.start();
                this.state.set(State.STARTED);
            }
            catch (Exception e) {
                this.logger.error("failed to start native user store", (Throwable)e, new Object[0]);
                this.state.set(State.FAILED);
            }
        }
    }

    public void stop() {
        if (this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            try {
                this.userPoller.stop();
            }
            catch (Throwable t) {
                this.state.set(State.FAILED);
                throw t;
            }
            finally {
                this.state.set(State.STOPPED);
            }
        }
    }

    public User verifyPassword(String username, SecuredString password) {
        if (this.state() != State.STARTED) {
            this.logger.trace("attempted to verify user credentials for [{}] but service was not started", new Object[]{username});
            return null;
        }
        UserAndPassword user = this.getUserAndPassword(username);
        if (user == null || user.passwordHash() == null) {
            return null;
        }
        if (this.hasher.verify(password, user.passwordHash())) {
            return user.user();
        }
        return null;
    }

    public void addListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    private void clearScrollResponse(final String scrollId) {
        ClearScrollRequest clearScrollRequest = (ClearScrollRequest)this.client.prepareClearScroll().addScrollId(scrollId).request();
        this.client.clearScroll(clearScrollRequest, (ActionListener)new ActionListener<ClearScrollResponse>(){

            public void onResponse(ClearScrollResponse response) {
            }

            public void onFailure(Throwable t) {
                ESNativeUsersStore.this.logger.warn("failed to clear scroll [{}]", t, new Object[]{scrollId});
            }
        });
    }

    private <Response> void clearRealmCache(final String username, final ActionListener<Response> listener, final Response response) {
        ShieldClient shieldClient = new ShieldClient((ElasticsearchClient)this.client);
        ClearRealmCacheRequest request = (ClearRealmCacheRequest)shieldClient.prepareClearRealmCache().usernames(username).request();
        shieldClient.clearRealmCache(request, new ActionListener<ClearRealmCacheResponse>(){

            public void onResponse(ClearRealmCacheResponse nodes) {
                listener.onResponse(response);
            }

            public void onFailure(Throwable e) {
                ESNativeUsersStore.this.logger.error("unable to clear realm cache for user [{}]", e, new Object[]{username});
                ElasticsearchException exception = new ElasticsearchException("clearing the cache for [" + username + "] failed. please clear the realm cache manually", e, new Object[0]);
                listener.onFailure((Throwable)exception);
            }
        });
    }

    public void clusterChanged(ClusterChangedEvent event) {
        boolean exists;
        boolean bl = exists = event.state().metaData().indices().get((Object)".security") != null;
        if (exists && event.state().routingTable().index(".security").allPrimaryShardsActive()) {
            this.logger.debug("security index [{}] all primary shards started, so polling can start", new Object[]{".security"});
            this.shieldIndexExists = true;
        } else {
            this.shieldIndexExists = false;
        }
    }

    public State state() {
        return this.state.get();
    }

    public void reset() {
        State state = this.state();
        if (state != State.STOPPED && state != State.FAILED) {
            throw new IllegalStateException("can only reset if stopped!!!");
        }
        this.versionMap.clear();
        this.listeners.clear();
        this.client = null;
        this.shieldIndexExists = false;
        this.state.set(State.INITIALIZED);
    }

    @Nullable
    private UserAndPassword transformUser(String username, Map<String, Object> sourceMap) {
        if (sourceMap == null) {
            return null;
        }
        try {
            String password = (String)sourceMap.get(User.Fields.PASSWORD.getPreferredName());
            String[] roles = ((List)sourceMap.get(User.Fields.ROLES.getPreferredName())).toArray(Strings.EMPTY_ARRAY);
            String fullName = (String)sourceMap.get(User.Fields.FULL_NAME.getPreferredName());
            String email = (String)sourceMap.get(User.Fields.EMAIL.getPreferredName());
            Map metadata = (Map)sourceMap.get(User.Fields.METADATA.getPreferredName());
            return new UserAndPassword(new User(username, roles, fullName, email, metadata), password.toCharArray());
        }
        catch (Exception e) {
            this.logger.error("error in the format of data for user [{}]", (Throwable)e, new Object[]{username});
            return null;
        }
    }

    static interface ChangeListener {
        public void onUsersChanged(List<String> var1);
    }

    private class UserStorePoller
    extends AbstractRunnable {
        private UserStorePoller() {
        }

        public void doRun() {
            Client client = ESNativeUsersStore.this.client;
            if (this.isStopped()) {
                return;
            }
            if (!ESNativeUsersStore.this.shieldIndexExists) {
                ESNativeUsersStore.this.logger.trace("cannot poll for user changes since security index [{}] does not exist", new Object[]{".security"});
                return;
            }
            ESNativeUsersStore.this.logger.trace("starting polling of user index to check for changes", new Object[0]);
            ObjectHashSet knownUsers = new ObjectHashSet((ObjectContainer)ESNativeUsersStore.this.versionMap.keys());
            List<String> changedUsers = new ArrayList();
            ObjectLongMap<String> currentUsersMap = this.collectUsersAndVersions(client);
            for (ObjectLongCursor cursor : currentUsersMap) {
                String username = (String)cursor.key;
                long version = cursor.value;
                if (knownUsers.contains((Object)username)) {
                    long lastKnownVersion = ESNativeUsersStore.this.versionMap.get((Object)username);
                    if (version != lastKnownVersion) {
                        assert (version > lastKnownVersion);
                        ESNativeUsersStore.this.versionMap.put((Object)username, version);
                        changedUsers.add(username);
                    }
                    knownUsers.remove((Object)username);
                    continue;
                }
                ESNativeUsersStore.this.versionMap.put((Object)username, version);
            }
            if (this.isStopped()) {
                return;
            }
            Iterator userIter = knownUsers.iterator();
            while (userIter.hasNext()) {
                String user = (String)((ObjectCursor)userIter.next()).value;
                ESNativeUsersStore.this.versionMap.remove((Object)user);
                changedUsers.add(user);
            }
            if (changedUsers.isEmpty()) {
                return;
            }
            changedUsers = Collections.unmodifiableList(changedUsers);
            if (ESNativeUsersStore.this.logger.isDebugEnabled()) {
                ESNativeUsersStore.this.logger.debug("changes detected for users [{}]", new Object[]{changedUsers});
            }
            Throwable th = null;
            for (ChangeListener listener : ESNativeUsersStore.this.listeners) {
                try {
                    listener.onUsersChanged(changedUsers);
                }
                catch (Throwable t) {
                    th = ExceptionsHelper.useOrSuppress(th, (Throwable)t);
                }
            }
            ExceptionsHelper.reThrowIfNotNull(th);
        }

        public void onFailure(Throwable t) {
            ESNativeUsersStore.this.logger.error("error occurred while checking the native users for changes", t, new Object[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectLongMap<String> collectUsersAndVersions(Client client) {
            ObjectLongHashMap map = new ObjectLongHashMap();
            SearchResponse response = null;
            try {
                boolean keepScrolling;
                client.admin().indices().prepareRefresh(new String[]{".security"}).get();
                SearchRequest request = client.prepareSearch(new String[]{".security"}).setScroll(ESNativeUsersStore.this.scrollKeepAlive).setQuery((QueryBuilder)QueryBuilders.typeQuery((String)ESNativeUsersStore.USER_DOC_TYPE)).setSize(ESNativeUsersStore.this.scrollSize).setVersion(true).setFetchSource(false).request();
                response = (SearchResponse)client.search(request).actionGet();
                boolean bl = keepScrolling = response.getHits().getHits().length > 0;
                while (keepScrolling) {
                    if (this.isStopped()) {
                        ObjectLongHashMap objectLongHashMap = new ObjectLongHashMap();
                        return objectLongHashMap;
                    }
                    for (SearchHit hit : response.getHits().getHits()) {
                        String username = hit.id();
                        long version = hit.version();
                        map.put((Object)username, version);
                    }
                    SearchScrollRequest scrollRequest = (SearchScrollRequest)client.prepareSearchScroll(response.getScrollId()).setScroll(ESNativeUsersStore.this.scrollKeepAlive).request();
                    keepScrolling = (response = (SearchResponse)client.searchScroll(scrollRequest).actionGet()).getHits().getHits().length > 0;
                }
            }
            catch (IndexNotFoundException e) {
                ESNativeUsersStore.this.logger.trace("security index does not exist", (Throwable)e, new Object[0]);
            }
            finally {
                if (response != null) {
                    ClearScrollRequest clearScrollRequest = (ClearScrollRequest)client.prepareClearScroll().addScrollId(response.getScrollId()).request();
                    client.clearScroll(clearScrollRequest).actionGet();
                }
            }
            return map;
        }

        private boolean isStopped() {
            State state = ESNativeUsersStore.this.state();
            return state == State.STOPPED || state == State.STOPPING;
        }
    }

    public static enum State {
        INITIALIZED,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        FAILED;

    }
}

