/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.shield.ShieldSettingsFilter;
import org.elasticsearch.shield.authc.AuthenticationModule;
import org.elasticsearch.shield.authc.Realm;
import org.elasticsearch.shield.authc.RealmConfig;
import org.elasticsearch.shield.license.ShieldLicenseState;

public class Realms
extends AbstractLifecycleComponent<Realms>
implements Iterable<Realm> {
    private final Environment env;
    private final Map<String, Realm.Factory> factories;
    private final ShieldSettingsFilter settingsFilter;
    private final ShieldLicenseState shieldLicenseState;
    protected List<Realm> realms = Collections.emptyList();
    protected List<Realm> internalRealmsOnly = Collections.emptyList();

    @Inject
    public Realms(Settings settings, Environment env, Map<String, Realm.Factory> factories, ShieldSettingsFilter settingsFilter, ShieldLicenseState shieldLicenseState) {
        super(settings);
        this.env = env;
        this.factories = factories;
        this.settingsFilter = settingsFilter;
        this.shieldLicenseState = shieldLicenseState;
    }

    protected void doStart() throws ElasticsearchException {
        this.realms = this.initRealms();
        ArrayList<Realm> internalRealms = new ArrayList<Realm>();
        for (Realm realm : this.realms) {
            if (!AuthenticationModule.INTERNAL_REALM_TYPES.contains(realm.type())) continue;
            internalRealms.add(realm);
        }
        if (internalRealms.isEmpty()) {
            this.addInternalRealms(internalRealms);
        }
        this.internalRealmsOnly = Collections.unmodifiableList(internalRealms);
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
    }

    @Override
    public Iterator<Realm> iterator() {
        if (this.shieldLicenseState.customRealmsEnabled()) {
            return this.realms.iterator();
        }
        return this.internalRealmsOnly.iterator();
    }

    public Realm realm(String name) {
        for (Realm realm : this.realms) {
            if (!name.equals(realm.config.name)) continue;
            return realm;
        }
        return null;
    }

    public Realm.Factory realmFactory(String type) {
        return this.factories.get(type);
    }

    protected List<Realm> initRealms() {
        Settings realmsSettings = this.settings.getAsSettings("shield.authc.realms");
        HashSet internalTypes = Sets.newHashSet();
        ArrayList<Realm> realms = new ArrayList<Realm>();
        for (String name : realmsSettings.names()) {
            Settings realmSettings = realmsSettings.getAsSettings(name);
            String type = realmSettings.get("type");
            if (type == null) {
                throw new IllegalArgumentException("missing realm type for [" + name + "] realm");
            }
            Realm.Factory factory = this.factories.get(type);
            if (factory == null) {
                throw new IllegalArgumentException("unknown realm type [" + type + "] set for realm [" + name + "]");
            }
            factory.filterOutSensitiveSettings(name, this.settingsFilter);
            RealmConfig config = new RealmConfig(name, realmSettings, this.settings, this.env);
            if (!config.enabled()) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("realm [{}/{}] is disabled", new Object[]{type, name});
                continue;
            }
            if (factory.internal()) {
                if (internalTypes.contains(type)) {
                    throw new IllegalArgumentException("multiple [" + type + "] realms are configured. [" + type + "] is an internal realm and therefore there can only be one such realm configured");
                }
                internalTypes.add(type);
            }
            realms.add((Realm)factory.create(config));
        }
        if (!realms.isEmpty()) {
            Collections.sort(realms);
            return realms;
        }
        this.addInternalRealms(realms);
        return realms;
    }

    public static Settings fileRealmSettings(Settings settings) {
        Settings realmsSettings = settings.getAsSettings("shield.authc.realms");
        Settings result = null;
        for (String name : realmsSettings.names()) {
            Settings realmSettings = realmsSettings.getAsSettings(name);
            String type = realmSettings.get("type");
            if (type == null) {
                throw new IllegalArgumentException("missing realm type for [" + name + "] realm");
            }
            if (!Realms.isESUsersRealm(type)) continue;
            if (result != null) {
                throw new IllegalArgumentException("multiple [file/esusers]realms are configured. only one may be configured");
            }
            result = realmSettings;
        }
        return result != null ? result : Settings.EMPTY;
    }

    private static boolean isESUsersRealm(String realmType) {
        return "file".equals(realmType) || "esusers".equals(realmType);
    }

    private void addInternalRealms(List<Realm> realms) {
        Realm.Factory esUsersRealm;
        Realm.Factory indexRealmFactory = this.factories.get("native");
        if (indexRealmFactory != null) {
            realms.add((Realm)indexRealmFactory.createDefault("default_native"));
        }
        if ((esUsersRealm = this.factories.get("file")) != null) {
            realms.add((Realm)esUsersRealm.createDefault("default_file"));
        }
    }
}

