/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action.user;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.action.user.PutUserRequest;
import org.elasticsearch.shield.action.user.PutUserResponse;
import org.elasticsearch.shield.authc.esnative.ESNativeUsersStore;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutUserAction
extends HandledTransportAction<PutUserRequest, PutUserResponse> {
    private final ESNativeUsersStore usersStore;

    @Inject
    public TransportPutUserAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ESNativeUsersStore usersStore, TransportService transportService) {
        super(settings, "cluster:admin/xpack/security/user/put", threadPool, transportService, actionFilters, indexNameExpressionResolver, PutUserRequest.class);
        this.usersStore = usersStore;
    }

    protected void doExecute(final PutUserRequest request, final ActionListener<PutUserResponse> listener) {
        this.usersStore.putUser(request, new ActionListener<Boolean>(){

            public void onResponse(Boolean created) {
                if (created.booleanValue()) {
                    TransportPutUserAction.this.logger.info("added user [{}]", new Object[]{request.username()});
                } else {
                    TransportPutUserAction.this.logger.info("updated user [{}]", new Object[]{request.username()});
                }
                listener.onResponse((Object)new PutUserResponse(created));
            }

            public void onFailure(Throwable e) {
                TransportPutUserAction.this.logger.error("failed to put user [{}]", e, new Object[]{request.username()});
                listener.onFailure(e);
            }
        });
    }
}

