/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action.support;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public abstract class NodesResponse<NodeResponse extends Node>
extends BaseNodesResponse<NodeResponse>
implements ToXContent {
    public NodesResponse() {
    }

    public NodesResponse(ClusterName clusterName, NodeResponse[] nodes) {
        super(clusterName, nodes);
    }

    public boolean hasFailures() {
        boolean failureFound = false;
        for (Node node : (Node[])this.nodes) {
            if (node.success()) continue;
            failureFound = true;
            break;
        }
        return failureFound;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(((Node[])this.nodes).length);
        for (Node node : (Node[])this.nodes) {
            node.writeTo(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("cluster_name", this.getClusterName().value());
        builder.startObject("nodes");
        for (Node node : (Node[])this.getNodes()) {
            builder.startObject(node.getNode().id());
            builder.field("name", node.getNode().name());
            builder.startObject("status");
            builder.field("success", node.success());
            if (!node.success()) {
                node.failedNodeException.toXContent(builder, params);
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder.endObject();
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }

    public static abstract class Node
    extends BaseNodeResponse {
        protected FailedNodeException failedNodeException;

        public Node() {
        }

        public Node(DiscoveryNode node) {
            super(node);
        }

        public Node(DiscoveryNode node, FailedNodeException failure) {
            super(node);
            this.failedNodeException = failure;
        }

        public boolean success() {
            boolean success;
            boolean bl = success = this.failedNodeException == null;
            assert (success || this.getNode() != null);
            return success;
        }

        @Nullable
        public String id() {
            if (this.getNode() == null) {
                assert (this.failedNodeException == null);
                return null;
            }
            return this.getNode().id();
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            if (in.getVersion().onOrAfter(Version.V_2_3_0) && in.readBoolean()) {
                this.failedNodeException = new FailedNodeException(in);
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_2_3_0)) {
                if (this.failedNodeException == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    this.failedNodeException.writeTo(out);
                }
            }
        }
    }
}

