/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action.role;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.shield.authz.RoleDescriptor;

public class PutRoleRequest
extends ActionRequest<PutRoleRequest> {
    private String name;
    private String[] clusterPrivileges = Strings.EMPTY_ARRAY;
    private List<RoleDescriptor.IndicesPrivileges> indicesPrivileges = new ArrayList<RoleDescriptor.IndicesPrivileges>();
    private String[] runAs = Strings.EMPTY_ARRAY;
    private boolean refresh = true;

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.name == null) {
            validationException = ValidateActions.addValidationError((String)"role name is missing", validationException);
        }
        return validationException;
    }

    public void name(String name) {
        this.name = name;
    }

    public void cluster(String ... clusterPrivileges) {
        this.clusterPrivileges = clusterPrivileges;
    }

    void addIndex(RoleDescriptor.IndicesPrivileges ... privileges) {
        this.indicesPrivileges.addAll(Arrays.asList(privileges));
    }

    public void addIndex(String[] indices, String[] privileges, @Nullable String[] fields, @Nullable BytesReference query) {
        this.indicesPrivileges.add(RoleDescriptor.IndicesPrivileges.builder().indices(indices).privileges(privileges).fields(fields).query(query).build());
    }

    public void runAs(String ... usernames) {
        this.runAs = usernames;
    }

    public void refresh(boolean refresh) {
        this.refresh = refresh;
    }

    public String name() {
        return this.name;
    }

    public String[] cluster() {
        return this.clusterPrivileges;
    }

    public RoleDescriptor.IndicesPrivileges[] indices() {
        return this.indicesPrivileges.toArray(new RoleDescriptor.IndicesPrivileges[this.indicesPrivileges.size()]);
    }

    public String[] runAs() {
        return this.runAs;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.name = in.readString();
        this.clusterPrivileges = in.readStringArray();
        int indicesSize = in.readVInt();
        this.indicesPrivileges = new ArrayList<RoleDescriptor.IndicesPrivileges>(indicesSize);
        for (int i = 0; i < indicesSize; ++i) {
            this.indicesPrivileges.add(RoleDescriptor.IndicesPrivileges.createFrom(in));
        }
        this.runAs = in.readStringArray();
        this.refresh = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
        out.writeStringArray(this.clusterPrivileges);
        out.writeVInt(this.indicesPrivileges.size());
        for (RoleDescriptor.IndicesPrivileges index : this.indicesPrivileges) {
            index.writeTo(out);
        }
        out.writeStringArray(this.runAs);
        out.writeBoolean(this.refresh);
    }

    RoleDescriptor roleDescriptor() {
        return new RoleDescriptor(this.name, this.clusterPrivileges, this.indicesPrivileges.toArray(new RoleDescriptor.IndicesPrivileges[this.indicesPrivileges.size()]), this.runAs);
    }
}

