/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action.realm;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.action.realm.ClearRealmCacheRequest;
import org.elasticsearch.shield.action.realm.ClearRealmCacheResponse;
import org.elasticsearch.shield.action.support.TransportNodesMasterCoordinatedAction;
import org.elasticsearch.shield.authc.Realm;
import org.elasticsearch.shield.authc.Realms;
import org.elasticsearch.shield.authc.support.CachingRealm;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClearRealmCacheAction
extends TransportNodesMasterCoordinatedAction<ClearRealmCacheRequest, ClearRealmCacheResponse, ClearRealmCacheRequest.Node, ClearRealmCacheResponse.Node> {
    private final Realms realms;
    private final ClusterName clusterName;

    @Inject
    public TransportClearRealmCacheAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Realms realms, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/shield/realm/cache/clear", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, ClearRealmCacheRequest.class, ClearRealmCacheRequest.Node.class);
        this.realms = realms;
        this.clusterName = clusterName;
    }

    @Override
    protected ClearRealmCacheResponse.Node nodeOperation(ClearRealmCacheRequest.Node nodeRequest) throws ElasticsearchException {
        if (nodeRequest.realms == null || nodeRequest.realms.length == 0) {
            for (Realm realm : this.realms) {
                this.clearCache(realm, nodeRequest.usernames);
            }
            return new ClearRealmCacheResponse.Node(this.clusterService.localNode());
        }
        for (String realmName : nodeRequest.realms) {
            Realm realm = this.realms.realm(realmName);
            if (realm == null) {
                throw new IllegalArgumentException("could not find active realm [" + realmName + "]");
            }
            this.clearCache(realm, nodeRequest.usernames);
        }
        return new ClearRealmCacheResponse.Node(this.clusterService.localNode());
    }

    protected ClearRealmCacheResponse newResponse() {
        return new ClearRealmCacheResponse();
    }

    @Override
    protected ClearRealmCacheResponse newResponse(AtomicReferenceArray<ClearRealmCacheResponse.Node> responses) {
        ArrayList<ClearRealmCacheResponse.Node> nodes = new ArrayList<ClearRealmCacheResponse.Node>();
        for (int i = 0; i < responses.length(); ++i) {
            ClearRealmCacheResponse.Node resp = responses.get(i);
            if (resp == null) {
                throw new IllegalArgumentException("node response is null");
            }
            nodes.add(resp);
        }
        return new ClearRealmCacheResponse(this.clusterName, nodes.toArray(new ClearRealmCacheResponse.Node[nodes.size()]));
    }

    @Override
    protected ClearRealmCacheRequest.Node newNodeRequest(String nodeId, ClearRealmCacheRequest request) {
        return new ClearRealmCacheRequest.Node(request, nodeId);
    }

    @Override
    protected ClearRealmCacheResponse.Node newNodeResponse() {
        return new ClearRealmCacheResponse.Node();
    }

    @Override
    protected ClearRealmCacheResponse.Node newNodeResponse(DiscoveryNode node, FailedNodeException failedNodeException) {
        return new ClearRealmCacheResponse.Node(node, failedNodeException);
    }

    private void clearCache(Realm realm, String[] usernames) {
        if (!(realm instanceof CachingRealm)) {
            return;
        }
        CachingRealm cachingRealm = (CachingRealm)((Object)realm);
        if (usernames != null && usernames.length != 0) {
            for (String username : usernames) {
                cachingRealm.expire(username);
            }
        } else {
            cachingRealm.expireAll();
        }
    }
}

