/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.transport.filter;

import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.collect.HppcMaps;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.shield.audit.AuditTrail;
import org.elasticsearch.shield.license.ShieldLicenseState;
import org.elasticsearch.shield.transport.filter.ShieldIpFilterRule;
import org.elasticsearch.transport.Transport;

public class IPFilter
extends AbstractLifecycleComponent<IPFilter> {
    public static final String HTTP_PROFILE_NAME = ".http";
    public static final String IP_FILTER_ENABLED_SETTING = "shield.transport.filter.enabled";
    public static final String IP_FILTER_ENABLED_HTTP_SETTING = "shield.http.filter.enabled";
    public static final ShieldIpFilterRule DEFAULT_PROFILE_ACCEPT_ALL = new ShieldIpFilterRule(true, "default:accept_all"){

        @Override
        public boolean contains(InetAddress inetAddress) {
            return true;
        }

        @Override
        public boolean isAllowRule() {
            return true;
        }

        @Override
        public boolean isDenyRule() {
            return false;
        }
    };
    private final LifecycleListener parseSettingsListener = new LifecycleListener(){

        public void afterStart() {
            IPFilter.this.rules = IPFilter.this.parseSettings(IPFilter.this.settings);
        }
    };
    private NodeSettingsService nodeSettingsService;
    private final AuditTrail auditTrail;
    private final Transport transport;
    private final ShieldLicenseState licenseState;
    private final boolean alwaysAllowBoundAddresses;
    private Map<String, ShieldIpFilterRule[]> rules = Collections.EMPTY_MAP;
    private HttpServerTransport httpServerTransport = null;

    @Inject
    public IPFilter(Settings settings, AuditTrail auditTrail, NodeSettingsService nodeSettingsService, Transport transport, ShieldLicenseState licenseState) {
        super(settings);
        this.nodeSettingsService = nodeSettingsService;
        this.auditTrail = auditTrail;
        this.transport = transport;
        this.licenseState = licenseState;
        this.alwaysAllowBoundAddresses = settings.getAsBoolean("shield.filter.always_allow_bound_address", Boolean.valueOf(true));
    }

    protected void doStart() throws ElasticsearchException {
        this.nodeSettingsService.addListener((NodeSettingsService.Listener)new ApplySettings(this.settings));
        if (this.transport.lifecycleState() == Lifecycle.State.STARTED) {
            this.rules = this.parseSettings(this.settings);
        } else {
            this.transport.addLifecycleListener(this.parseSettingsListener);
        }
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
    }

    @Inject(optional=true)
    public void setHttpServerTransport(@Nullable HttpServerTransport httpServerTransport) {
        if (httpServerTransport == null) {
            return;
        }
        this.httpServerTransport = httpServerTransport;
        if (httpServerTransport.lifecycleState() == Lifecycle.State.STARTED) {
            this.rules = this.parseSettings(this.settings);
        } else {
            httpServerTransport.addLifecycleListener(this.parseSettingsListener);
        }
    }

    public boolean accept(String profile, InetAddress peerAddress) {
        if (!this.licenseState.securityEnabled()) {
            return true;
        }
        if (!this.rules.containsKey(profile)) {
            return true;
        }
        for (ShieldIpFilterRule rule : this.rules.get(profile)) {
            if (!rule.contains(peerAddress)) continue;
            boolean isAllowed = rule.isAllowRule();
            if (isAllowed) {
                this.auditTrail.connectionGranted(peerAddress, profile, rule);
            } else {
                this.auditTrail.connectionDenied(peerAddress, profile, rule);
            }
            return isAllowed;
        }
        this.auditTrail.connectionGranted(peerAddress, profile, DEFAULT_PROFILE_ACCEPT_ALL);
        return true;
    }

    private Map<String, ShieldIpFilterRule[]> parseSettings(Settings settings) {
        TransportAddress[] localAddresses;
        boolean isIpFilterEnabled = settings.getAsBoolean(IP_FILTER_ENABLED_SETTING, Boolean.valueOf(true));
        boolean isHttpFilterEnabled = settings.getAsBoolean(IP_FILTER_ENABLED_HTTP_SETTING, Boolean.valueOf(isIpFilterEnabled));
        if (!isIpFilterEnabled && !isHttpFilterEnabled) {
            return Collections.EMPTY_MAP;
        }
        HashMap profileRules = Maps.newHashMap();
        if (isHttpFilterEnabled && this.httpServerTransport != null && this.httpServerTransport.lifecycleState() == Lifecycle.State.STARTED) {
            localAddresses = this.httpServerTransport.boundAddress().boundAddresses();
            String[] httpAllowed = settings.getAsArray("shield.http.filter.allow", settings.getAsArray("transport.profiles.default.shield.filter.allow", settings.getAsArray("shield.transport.filter.allow")));
            String[] httpDenied = settings.getAsArray("shield.http.filter.deny", settings.getAsArray("transport.profiles.default.shield.filter.deny", settings.getAsArray("shield.transport.filter.deny")));
            profileRules.put(HTTP_PROFILE_NAME, this.createRules(httpAllowed, httpDenied, localAddresses));
        }
        if (isIpFilterEnabled && this.transport.lifecycleState() == Lifecycle.State.STARTED) {
            localAddresses = this.transport.boundAddress().boundAddresses();
            String[] allowed = settings.getAsArray("shield.transport.filter.allow");
            String[] denied = settings.getAsArray("shield.transport.filter.deny");
            profileRules.put("default", this.createRules(allowed, denied, localAddresses));
            Map groupedSettings = settings.getGroups("transport.profiles.");
            for (Map.Entry entry : groupedSettings.entrySet()) {
                String profile = (String)entry.getKey();
                BoundTransportAddress profileBoundTransportAddress = (BoundTransportAddress)this.transport.profileBoundAddresses().get(profile);
                if (profileBoundTransportAddress == null) {
                    this.logger.warn("skipping ip filter rules for profile [{}] since the profile is not bound to any addresses", new Object[]{profile});
                    continue;
                }
                Settings profileSettings = ((Settings)entry.getValue()).getByPrefix("shield.filter.");
                profileRules.put(profile, this.createRules(profileSettings.getAsArray("allow"), profileSettings.getAsArray("deny"), profileBoundTransportAddress.boundAddresses()));
            }
        }
        this.logger.debug("loaded ip filtering profiles: {}", new Object[]{profileRules.keySet()});
        return ImmutableMap.copyOf((Map)profileRules);
    }

    private ShieldIpFilterRule[] createRules(String[] allow, String[] deny, TransportAddress[] boundAddresses) {
        ArrayList<ShieldIpFilterRule> rules = new ArrayList<ShieldIpFilterRule>();
        if (this.alwaysAllowBoundAddresses) {
            assert (boundAddresses != null && boundAddresses.length > 0);
            rules.add(new ShieldIpFilterRule(true, boundAddresses));
        }
        for (String value : allow) {
            rules.add(new ShieldIpFilterRule(true, value));
        }
        for (String value : deny) {
            rules.add(new ShieldIpFilterRule(false, value));
        }
        return rules.toArray(new ShieldIpFilterRule[rules.size()]);
    }

    private class ApplySettings
    implements NodeSettingsService.Listener {
        String[] allowed;
        String[] denied;
        String[] httpAllowed;
        String[] httpDenied;
        ObjectObjectHashMap<String, String[]> profileAllowed;
        ObjectObjectHashMap<String, String[]> profileDenied;
        private boolean enabled;
        private boolean httpEnabled;

        public ApplySettings(Settings settings) {
            this.loadValuesFromSettings(settings);
        }

        private void loadValuesFromSettings(Settings settings) {
            this.enabled = settings.getAsBoolean(IPFilter.IP_FILTER_ENABLED_SETTING, Boolean.valueOf(this.enabled));
            this.httpEnabled = settings.getAsBoolean(IPFilter.IP_FILTER_ENABLED_HTTP_SETTING, Boolean.valueOf(this.httpEnabled));
            this.allowed = settings.getAsArray("shield.transport.filter.allow", this.allowed);
            this.denied = settings.getAsArray("shield.transport.filter.deny", this.denied);
            this.httpAllowed = settings.getAsArray("shield.http.filter.allow", this.httpAllowed);
            this.httpDenied = settings.getAsArray("shield.http.filter.deny", this.httpDenied);
            if (settings.getGroups("transport.profiles.").size() == 0) {
                this.profileAllowed = HppcMaps.newMap((int)0);
                this.profileDenied = HppcMaps.newMap((int)0);
            }
            this.profileAllowed = HppcMaps.newNoNullKeysMap((int)settings.getGroups("transport.profiles.").size());
            this.profileDenied = HppcMaps.newNoNullKeysMap((int)settings.getGroups("transport.profiles.").size());
            for (Map.Entry entry : settings.getGroups("transport.profiles.").entrySet()) {
                this.profileAllowed.put(entry.getKey(), (Object)((Settings)entry.getValue()).getAsArray("shield.filter.allow"));
                this.profileDenied.put(entry.getKey(), (Object)((Settings)entry.getValue()).getAsArray("shield.filter.deny"));
            }
        }

        public void onRefreshSettings(Settings settings) {
            if (this.ipFilterSettingsInvolved(settings) && this.settingsChanged(settings)) {
                IPFilter.this.rules = IPFilter.this.parseSettings(settings);
                this.loadValuesFromSettings(settings);
            }
        }

        private boolean settingsChanged(Settings settings) {
            if (!(this.enabled == settings.getAsBoolean(IPFilter.IP_FILTER_ENABLED_SETTING, Boolean.valueOf(this.enabled)) && this.httpEnabled == settings.getAsBoolean(IPFilter.IP_FILTER_ENABLED_HTTP_SETTING, Boolean.valueOf(this.httpEnabled)) && Arrays.equals(this.allowed, settings.getAsArray("shield.transport.filter.allow")) && Arrays.equals(this.denied, settings.getAsArray("shield.transport.filter.deny")) && Arrays.equals(this.httpAllowed, settings.getAsArray("shield.http.filter.allow")) && Arrays.equals(this.httpDenied, settings.getAsArray("shield.http.filter.deny")))) {
                return true;
            }
            ObjectObjectHashMap newProfileAllowed = HppcMaps.newNoNullKeysMap((int)settings.getGroups("transport.profiles.").size());
            ObjectObjectHashMap newProfileDenied = HppcMaps.newNoNullKeysMap((int)settings.getGroups("transport.profiles.").size());
            for (Map.Entry entry : settings.getGroups("transport.profiles.").entrySet()) {
                newProfileAllowed.put(entry.getKey(), (Object)((Settings)entry.getValue()).getAsArray("shield.filter.allow"));
                newProfileDenied.put(entry.getKey(), (Object)((Settings)entry.getValue()).getAsArray("shield.filter.deny"));
            }
            boolean allowedProfileChanged = !newProfileAllowed.equals(this.profileAllowed);
            boolean deniedProfileChanged = !newProfileDenied.equals(this.profileDenied);
            return allowedProfileChanged || deniedProfileChanged;
        }

        private boolean ipFilterSettingsInvolved(Settings settings) {
            boolean containsStaticIpFilterSettings;
            boolean bl = containsStaticIpFilterSettings = settings.get("shield.transport.filter.allow") != null || settings.get("shield.transport.filter.deny") != null || settings.get("shield.http.filter.allow") != null || settings.get("shield.http.filter.deny") != null || settings.get(IPFilter.IP_FILTER_ENABLED_SETTING) != null || settings.get(IPFilter.IP_FILTER_ENABLED_HTTP_SETTING) != null;
            if (containsStaticIpFilterSettings) {
                return true;
            }
            for (Map.Entry entry : settings.getGroups("transport.profiles.").entrySet()) {
                if (((Settings)entry.getValue()).get("shield.filter.allow") == null && ((Settings)entry.getValue()).get("shield.filter.deny") == null) continue;
                return true;
            }
            return false;
        }
    }
}

