/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.transport;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.action.ShieldActionMapper;
import org.elasticsearch.shield.authc.AuthenticationService;
import org.elasticsearch.shield.authz.AuthorizationService;
import org.elasticsearch.shield.authz.accesscontrol.RequestContext;
import org.elasticsearch.shield.license.ShieldLicenseState;
import org.elasticsearch.shield.transport.ClientTransportFilter;
import org.elasticsearch.shield.transport.SSLClientAuth;
import org.elasticsearch.shield.transport.ServerTransportFilter;
import org.elasticsearch.shield.transport.netty.ShieldNettyTransport;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class ShieldServerTransportService
extends TransportService {
    public static final String SETTING_NAME = "shield.type";
    protected final AuthenticationService authcService;
    protected final AuthorizationService authzService;
    protected final ShieldActionMapper actionMapper;
    protected final ClientTransportFilter clientFilter;
    protected final ShieldLicenseState licenseState;
    protected final Map<String, ServerTransportFilter> profileFilters;

    @Inject
    public ShieldServerTransportService(Settings settings, Transport transport, ThreadPool threadPool, AuthenticationService authcService, AuthorizationService authzService, ShieldActionMapper actionMapper, ClientTransportFilter clientTransportFilter, ShieldLicenseState licenseState) {
        super(settings, transport, threadPool);
        this.authcService = authcService;
        this.authzService = authzService;
        this.actionMapper = actionMapper;
        this.clientFilter = clientTransportFilter;
        this.licenseState = licenseState;
        this.profileFilters = this.initializeProfileFilters();
    }

    public <T extends TransportResponse> void sendRequest(DiscoveryNode node, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        try {
            this.clientFilter.outbound(action, request);
            super.sendRequest(node, action, request, options, handler);
        }
        catch (Throwable t) {
            handler.handleException(new TransportException("failed sending request", t));
        }
    }

    public <Request extends TransportRequest> void registerRequestHandler(String action, Class<Request> request, String executor, boolean forceExecution, TransportRequestHandler<Request> handler) {
        ProfileSecuredRequestHandler<Request> wrappedHandler = new ProfileSecuredRequestHandler<Request>(action, handler, this.profileFilters, this.licenseState);
        super.registerRequestHandler(action, request, executor, forceExecution, wrappedHandler);
    }

    public <Request extends TransportRequest> void registerRequestHandler(String action, Callable<Request> requestFactory, String executor, TransportRequestHandler<Request> handler) {
        ProfileSecuredRequestHandler<Request> wrappedHandler = new ProfileSecuredRequestHandler<Request>(action, handler, this.profileFilters, this.licenseState);
        super.registerRequestHandler(action, requestFactory, executor, wrappedHandler);
    }

    protected Map<String, ServerTransportFilter> initializeProfileFilters() {
        if (!(this.transport instanceof ShieldNettyTransport)) {
            return Collections.singletonMap("default", new ServerTransportFilter.NodeProfile(this.authcService, this.authzService, this.actionMapper, false));
        }
        Map profileSettingsMap = this.settings.getGroups("transport.profiles.", true);
        HashMap profileFilters = Maps.newHashMapWithExpectedSize((int)(profileSettingsMap.size() + 1));
        block6: for (Map.Entry entry : profileSettingsMap.entrySet()) {
            String type;
            Settings profileSettings = (Settings)entry.getValue();
            boolean profileSsl = profileSettings.getAsBoolean("shield.ssl", this.settings.getAsBoolean("shield.transport.ssl", Boolean.valueOf(false)));
            boolean clientAuth = SSLClientAuth.parse(profileSettings.get("shield.ssl.client.auth", this.settings.get("shield.transport.ssl.client.auth")), ShieldNettyTransport.TRANSPORT_CLIENT_AUTH_DEFAULT).enabled();
            boolean extractClientCert = profileSsl && clientAuth;
            switch (type = ((Settings)entry.getValue()).get(SETTING_NAME, "node")) {
                case "client": {
                    profileFilters.put(entry.getKey(), new ServerTransportFilter.ClientProfile(this.authcService, this.authzService, this.actionMapper, extractClientCert));
                    continue block6;
                }
            }
            profileFilters.put(entry.getKey(), new ServerTransportFilter.NodeProfile(this.authcService, this.authzService, this.actionMapper, extractClientCert));
        }
        if (!profileFilters.containsKey("default")) {
            boolean profileSsl = this.settings.getAsBoolean("shield.transport.ssl", Boolean.valueOf(false));
            boolean clientAuth = SSLClientAuth.parse(this.settings.get("shield.transport.ssl.client.auth"), ShieldNettyTransport.TRANSPORT_CLIENT_AUTH_DEFAULT).enabled();
            boolean extractClientCert = profileSsl && clientAuth;
            profileFilters.put("default", new ServerTransportFilter.NodeProfile(this.authcService, this.authzService, this.actionMapper, extractClientCert));
        }
        return Collections.unmodifiableMap(profileFilters);
    }

    ServerTransportFilter transportFilter(String profile) {
        return this.profileFilters.get(profile);
    }

    public static class ProfileSecuredRequestHandler<T extends TransportRequest>
    implements TransportRequestHandler<T> {
        protected final String action;
        protected final TransportRequestHandler<T> handler;
        private final Map<String, ServerTransportFilter> profileFilters;
        private final ShieldLicenseState licenseState;

        public ProfileSecuredRequestHandler(String action, TransportRequestHandler<T> handler, Map<String, ServerTransportFilter> profileFilters, ShieldLicenseState licenseState) {
            this.action = action;
            this.handler = handler;
            this.profileFilters = profileFilters;
            this.licenseState = licenseState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(T request, TransportChannel channel) throws Exception {
            try {
                if (this.licenseState.securityEnabled()) {
                    String profile = channel.getProfileName();
                    ServerTransportFilter filter = this.profileFilters.get(profile);
                    if (filter == null) {
                        if (".direct".equals(profile)) {
                            filter = this.profileFilters.get("default");
                        } else {
                            throw new IllegalStateException("transport profile [" + profile + "] is not associated with a transport filter");
                        }
                    }
                    assert (filter != null);
                    filter.inbound(this.action, (TransportRequest)request, channel);
                }
                RequestContext context = new RequestContext((TransportRequest)request);
                RequestContext.setCurrent(context);
                this.handler.messageReceived(request, channel);
            }
            catch (Throwable t) {
                channel.sendResponse(t);
            }
            finally {
                RequestContext.removeCurrent();
            }
        }
    }
}

