/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.transport;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.action.ShieldActionMapper;
import org.elasticsearch.shield.authc.AuthenticationService;
import org.elasticsearch.shield.authz.AuthorizationService;
import org.elasticsearch.shield.support.Exceptions;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.netty.NettyTransportChannel;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.ssl.SslHandler;

public interface ServerTransportFilter {
    public void inbound(String var1, TransportRequest var2, TransportChannel var3) throws IOException;

    public static class ClientProfile
    extends NodeProfile {
        public ClientProfile(AuthenticationService authcService, AuthorizationService authzService, ShieldActionMapper actionMapper, boolean extractClientCert) {
            super(authcService, authzService, actionMapper, extractClientCert);
        }

        @Override
        public void inbound(String action, TransportRequest request, TransportChannel transportChannel) throws IOException {
            boolean isInternalOrShardAction;
            boolean bl = isInternalOrShardAction = action.startsWith("internal:") || action.endsWith("]");
            if (isInternalOrShardAction) {
                throw Exceptions.authenticationError("executing internal/shard actions is considered malicious and forbidden", new Object[0]);
            }
            super.inbound(action, request, transportChannel);
        }
    }

    public static class NodeProfile
    implements ServerTransportFilter {
        private static final ESLogger logger = Loggers.getLogger(NodeProfile.class);
        private final AuthenticationService authcService;
        private final AuthorizationService authzService;
        private final ShieldActionMapper actionMapper;
        private final boolean extractClientCert;

        public NodeProfile(AuthenticationService authcService, AuthorizationService authzService, ShieldActionMapper actionMapper, boolean extractClientCert) {
            this.authcService = authcService;
            this.authzService = authzService;
            this.actionMapper = actionMapper;
            this.extractClientCert = extractClientCert;
        }

        @Override
        public void inbound(String action, TransportRequest request, TransportChannel transportChannel) throws IOException {
            String shieldAction;
            block6: {
                shieldAction = this.actionMapper.action(action, request);
                if (this.extractClientCert && transportChannel instanceof NettyTransportChannel) {
                    Channel channel = ((NettyTransportChannel)transportChannel).getChannel();
                    SslHandler sslHandler = (SslHandler)channel.getPipeline().get(SslHandler.class);
                    assert (sslHandler != null);
                    try {
                        Certificate[] certs = sslHandler.getEngine().getSession().getPeerCertificates();
                        if (certs instanceof X509Certificate[]) {
                            request.putInContext((Object)"__SHIELD_CLIENT_CERTIFICATE", (Object)certs);
                        }
                    }
                    catch (SSLPeerUnverifiedException e) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("SSL Peer did not present a certificate on channel [{}]", (Throwable)e, new Object[]{channel});
                        }
                        if (!logger.isDebugEnabled()) break block6;
                        logger.debug("SSL Peer did not present a certificate on channel [{}]", new Object[]{channel});
                    }
                }
            }
            User user = this.authcService.authenticate(shieldAction, (TransportMessage)request, null);
            this.authzService.authorize(user, shieldAction, request);
        }
    }
}

