/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.support;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicAutomata;
import dk.brics.automaton.BasicOperations;
import dk.brics.automaton.MinimizationOperations;
import dk.brics.automaton.RegExp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public final class Automatons {
    static final char WILDCARD_STRING = '*';
    static final char WILDCARD_CHAR = '?';
    static final char WILDCARD_ESCAPE = '\\';

    private Automatons() {
    }

    public static Automaton patterns(String ... patterns) {
        return Automatons.patterns(Arrays.asList(patterns));
    }

    public static Automaton patterns(Collection<String> patterns) {
        if (patterns.isEmpty()) {
            return BasicAutomata.makeEmpty();
        }
        Automaton automaton = null;
        for (String pattern : patterns) {
            if (automaton == null) {
                automaton = Automatons.pattern(pattern);
                continue;
            }
            automaton = BasicOperations.union((Automaton)automaton, (Automaton)Automatons.pattern(pattern));
        }
        MinimizationOperations.minimize(automaton);
        return automaton;
    }

    static Automaton pattern(String pattern) {
        if (pattern.startsWith("/")) {
            if (pattern.length() == 1 || !pattern.endsWith("/")) {
                throw new IllegalArgumentException("invalid pattern [" + pattern + "]. patterns starting with '/' " + "indicate regular expression pattern and therefore must also end with '/'." + " other patterns (those that do not start with '/') will be treated as simple wildcard patterns");
            }
            String regex = pattern.substring(1, pattern.length() - 1);
            return new RegExp(regex).toAutomaton();
        }
        return Automatons.wildcard(pattern);
    }

    static Automaton wildcard(String text) {
        int length;
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        block5: for (int i = 0; i < text.length(); i += length) {
            char c = text.charAt(i);
            length = 1;
            switch (c) {
                case '*': {
                    automata.add(BasicAutomata.makeAnyString());
                    continue block5;
                }
                case '?': {
                    automata.add(BasicAutomata.makeAnyChar());
                    continue block5;
                }
                case '\\': {
                    if (i + length < text.length()) {
                        char nextChar = text.charAt(i + length);
                        ++length;
                        automata.add(BasicAutomata.makeChar((char)nextChar));
                        continue block5;
                    }
                }
                default: {
                    automata.add(BasicAutomata.makeChar((char)c));
                }
            }
        }
        return BasicOperations.concatenate(automata);
    }

    public static Automaton unionAndDeterminize(Automaton a1, Automaton a2) {
        Automaton res = BasicOperations.union((Automaton)a1, (Automaton)a2);
        res.determinize();
        return res;
    }

    public static Automaton minusAndDeterminize(Automaton a1, Automaton a2) {
        Automaton res = BasicOperations.minus((Automaton)a1, (Automaton)a2);
        res.determinize();
        return res;
    }
}

