/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.ssl;

import java.nio.file.Path;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.shield.ssl.AbstractSSLService;

@SuppressForbidden(reason="we don't have the environment to resolve files from when running in a transport client")
public class ClientSSLService
extends AbstractSSLService {
    @Inject
    public ClientSSLService(Settings settings) {
        super(settings, null);
    }

    @Inject(optional=true)
    public void setEnvironment(Environment environment) {
        this.env = environment;
    }

    @Override
    protected AbstractSSLService.SSLSettings sslSettings(Settings customSettings) {
        AbstractSSLService.SSLSettings sslSettings = new AbstractSSLService.SSLSettings(customSettings, this.settings);
        if (sslSettings.keyStorePath != null && sslSettings.keyStorePassword == null) {
            throw new IllegalArgumentException("no keystore password configured");
        }
        if (sslSettings.trustStorePath != null && sslSettings.trustStorePassword == null) {
            throw new IllegalArgumentException("no truststore password configured");
        }
        return sslSettings;
    }

    @Override
    protected Path resolvePath(String location) {
        if (this.env == null) {
            return PathUtils.get((String)Strings.cleanPath((String)location), (String[])new String[0]);
        }
        return super.resolvePath(location);
    }
}

