/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.support;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.authc.RealmConfig;
import org.elasticsearch.shield.authc.support.CachingRealm;
import org.elasticsearch.shield.authc.support.Hasher;
import org.elasticsearch.shield.authc.support.SecuredString;
import org.elasticsearch.shield.authc.support.UsernamePasswordRealm;
import org.elasticsearch.shield.authc.support.UsernamePasswordToken;
import org.elasticsearch.shield.support.Exceptions;

public abstract class CachingUsernamePasswordRealm
extends UsernamePasswordRealm
implements CachingRealm {
    public static final String CACHE_HASH_ALGO_SETTING = "cache.hash_algo";
    public static final String CACHE_TTL_SETTING = "cache.ttl";
    public static final String CACHE_MAX_USERS_SETTING = "cache.max_users";
    private static final TimeValue DEFAULT_TTL = TimeValue.timeValueMinutes((long)20L);
    private static final int DEFAULT_MAX_USERS = 100000;
    private final Cache<String, UserWithHash> cache;
    final Hasher hasher;

    protected CachingUsernamePasswordRealm(String type, RealmConfig config) {
        super(type, config);
        this.hasher = Hasher.resolve(config.settings().get(CACHE_HASH_ALGO_SETTING, null), Hasher.SSHA256);
        TimeValue ttl = config.settings().getAsTime(CACHE_TTL_SETTING, DEFAULT_TTL);
        this.cache = ttl.millis() > 0L ? CacheBuilder.newBuilder().expireAfterWrite(ttl.getMillis(), TimeUnit.MILLISECONDS).maximumSize((long)config.settings().getAsInt(CACHE_MAX_USERS_SETTING, Integer.valueOf(100000)).intValue()).build() : null;
    }

    @Override
    public final void expire(String username) {
        if (this.cache != null) {
            this.cache.invalidate((Object)username);
        }
    }

    @Override
    public final void expireAll() {
        if (this.cache != null) {
            this.cache.invalidateAll();
        }
    }

    @Override
    public final User authenticate(UsernamePasswordToken token) {
        if (this.cache == null) {
            return this.doAuthenticate(token);
        }
        try {
            UserWithHash userWithHash = (UserWithHash)this.cache.getIfPresent((Object)token.principal());
            if (userWithHash == null) {
                User user;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("user not found in cache, proceeding with normal authentication", new Object[0]);
                }
                if ((user = this.doAuthenticate(token)) == null) {
                    return null;
                }
                userWithHash = new UserWithHash(user, token.credentials(), this.hasher);
                this.cache.put((Object)token.principal(), (Object)userWithHash);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("authenticated user [{}], with roles [{}]", new Object[]{token.principal(), user.roles()});
                }
                return user;
            }
            boolean hadHash = userWithHash.hasHash();
            if (hadHash && userWithHash.verify(token.credentials())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("authenticated user [{}], with roles [{}]", new Object[]{token.principal(), userWithHash.user.roles()});
                }
                return userWithHash.user;
            }
            this.cache.invalidate((Object)token.principal());
            User user = this.doAuthenticate(token);
            if (user == null) {
                return null;
            }
            userWithHash = new UserWithHash(user, token.credentials(), this.hasher);
            this.cache.put((Object)token.principal(), (Object)userWithHash);
            if (this.logger.isDebugEnabled()) {
                if (hadHash) {
                    this.logger.debug("cached user's password changed. authenticated user [{}], with roles [{}]", new Object[]{token.principal(), userWithHash.user.roles()});
                } else {
                    this.logger.debug("cached user came from a lookup and could not be used for authentication. authenticated user [{}], with roles [{}]", new Object[]{token.principal(), userWithHash.user.roles()});
                }
            }
            return userWithHash.user;
        }
        catch (Exception ee) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("realm [" + this.type() + "] could not authenticate [" + token.principal() + "]", (Throwable)ee, new Object[0]);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("realm [" + this.type() + "] could not authenticate [" + token.principal() + "]", new Object[0]);
            }
            return null;
        }
    }

    @Override
    public final User lookupUser(final String username) {
        if (!this.userLookupSupported()) {
            return null;
        }
        Callable<UserWithHash> callback = new Callable<UserWithHash>(){

            @Override
            public UserWithHash call() throws Exception {
                User user;
                if (CachingUsernamePasswordRealm.this.logger.isDebugEnabled()) {
                    CachingUsernamePasswordRealm.this.logger.debug("user not found in cache, proceeding with normal lookup", new Object[0]);
                }
                if ((user = CachingUsernamePasswordRealm.this.doLookupUser(username)) == null) {
                    throw Exceptions.authenticationError("could not lookup [{}]", username);
                }
                return new UserWithHash(user, null, null);
            }
        };
        try {
            UserWithHash userWithHash = (UserWithHash)this.cache.get((Object)username, (Callable)callback);
            return userWithHash.user;
        }
        catch (UncheckedExecutionException | ExecutionException ee) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("realm [" + this.name() + "] could not lookup [" + username + "]", ee, new Object[0]);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("realm [" + this.name() + "] could not authenticate [" + username + "]", new Object[0]);
            }
            return null;
        }
    }

    protected abstract User doAuthenticate(UsernamePasswordToken var1);

    protected abstract User doLookupUser(String var1);

    private static class UserWithHash {
        User user;
        char[] hash;
        Hasher hasher;

        public UserWithHash(User user, SecuredString password, Hasher hasher) {
            this.user = user;
            this.hash = password == null ? null : hasher.hash(password);
            this.hasher = hasher;
        }

        public boolean verify(SecuredString password) {
            return this.hash != null && this.hasher.verify(password, this.hash);
        }

        public boolean hasHash() {
            return this.hash != null;
        }
    }
}

