/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.ldap.support;

import java.util.List;
import java.util.Set;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.authc.RealmConfig;
import org.elasticsearch.shield.authc.ldap.support.LdapSession;
import org.elasticsearch.shield.authc.ldap.support.SessionFactory;
import org.elasticsearch.shield.authc.support.CachingUsernamePasswordRealm;
import org.elasticsearch.shield.authc.support.DnRoleMapper;
import org.elasticsearch.shield.authc.support.RefreshListener;
import org.elasticsearch.shield.authc.support.UsernamePasswordRealm;
import org.elasticsearch.shield.authc.support.UsernamePasswordToken;

public abstract class AbstractLdapRealm
extends CachingUsernamePasswordRealm {
    protected final SessionFactory sessionFactory;
    protected final DnRoleMapper roleMapper;

    protected AbstractLdapRealm(String type, RealmConfig config, SessionFactory sessionFactory, DnRoleMapper roleMapper) {
        super(type, config);
        this.sessionFactory = sessionFactory;
        this.roleMapper = roleMapper;
        roleMapper.addListener(new Listener());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected User doAuthenticate(UsernamePasswordToken token) {
        try (LdapSession session = this.sessionFactory.session(token.principal(), token.credentials());){
            User user = this.createUser(token.principal(), session);
            return user;
        }
        catch (Exception e) {
            this.logException("authentication", e, token.principal());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public User doLookupUser(String username) {
        if (!this.sessionFactory.supportsUnauthenticatedSession()) return null;
        try (LdapSession session = this.sessionFactory.unauthenticatedSession(username);){
            User user = this.createUser(username, session);
            return user;
        }
        catch (Exception e) {
            this.logException("lookup", e, username);
        }
        return null;
    }

    @Override
    public boolean userLookupSupported() {
        return this.sessionFactory.supportsUnauthenticatedSession();
    }

    private void logException(String action, Exception e, String principal) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} failed for user [{}]", (Throwable)e, new Object[]{action, principal});
        } else {
            String causeMessage;
            String string = causeMessage = e.getCause() == null ? null : e.getCause().getMessage();
            if (causeMessage == null) {
                this.logger.warn("{} failed for user [{}]: {}", new Object[]{action, principal, e.getMessage()});
            } else {
                this.logger.warn("{} failed for user [{}]: {}\ncause: {}: {}", new Object[]{action, principal, e.getMessage(), e.getCause().getClass().getName(), causeMessage});
            }
        }
    }

    private User createUser(String principal, LdapSession session) {
        List<String> groupDNs = session.groups();
        Set<String> roles = this.roleMapper.resolveRoles(session.userDn(), groupDNs);
        return new User.Simple(principal, roles.toArray(new String[roles.size()]));
    }

    public static abstract class Factory<R extends AbstractLdapRealm>
    extends UsernamePasswordRealm.Factory<R> {
        public Factory(String type) {
            super(type, false);
        }

        @Override
        public final R createDefault(String name) {
            return null;
        }
    }

    class Listener
    implements RefreshListener {
        Listener() {
        }

        @Override
        public void onRefresh() {
            AbstractLdapRealm.this.expireAll();
        }
    }
}

