/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.ldap;

import com.google.common.primitives.Ints;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.LinkedList;
import java.util.List;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.shield.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.shield.authc.ldap.support.LdapSession;
import org.elasticsearch.shield.authc.ldap.support.LdapUtils;
import org.elasticsearch.shield.support.Exceptions;

class SearchGroupsResolver
implements LdapSession.GroupsResolver {
    private static final String GROUP_SEARCH_DEFAULT_FILTER = "(&(|(objectclass=groupOfNames)(objectclass=groupOfUniqueNames)(objectclass=group))(|(uniqueMember={0})(member={0})))";
    private final String baseDn;
    private final String filter;
    private final String userAttribute;
    private final LdapSearchScope scope;

    public SearchGroupsResolver(Settings settings) {
        this.baseDn = settings.get("base_dn");
        if (this.baseDn == null) {
            throw new IllegalArgumentException("base_dn must be specified");
        }
        this.filter = settings.get("filter", GROUP_SEARCH_DEFAULT_FILTER);
        this.userAttribute = settings.get("user_attribute");
        this.scope = LdapSearchScope.resolve(settings.get("scope"), LdapSearchScope.SUB_TREE);
    }

    @Override
    public List<String> resolve(LDAPInterface connection, String userDn, TimeValue timeout, ESLogger logger) {
        LinkedList<String> groups = new LinkedList<String>();
        String userId = this.userAttribute != null ? this.readUserAttribute(connection, userDn, timeout, logger) : userDn;
        try {
            SearchRequest searchRequest = new SearchRequest(this.baseDn, this.scope.scope(), LdapUtils.createFilter(this.filter, userId), Strings.EMPTY_ARRAY);
            searchRequest.setTimeLimitSeconds(Ints.checkedCast((long)timeout.seconds()));
            SearchResult results = LdapUtils.search(connection, searchRequest, logger);
            for (SearchResultEntry entry : results.getSearchEntries()) {
                groups.add(entry.getDN());
            }
        }
        catch (LDAPException e) {
            throw Exceptions.authenticationError("could not search for LDAP groups for DN [{}]", e, userDn);
        }
        return groups;
    }

    String readUserAttribute(LDAPInterface connection, String userDn, TimeValue timeout, ESLogger logger) {
        try {
            SearchRequest request = new SearchRequest(userDn, SearchScope.BASE, LdapUtils.OBJECT_CLASS_PRESENCE_FILTER, new String[]{this.userAttribute});
            request.setTimeLimitSeconds(Ints.checkedCast((long)timeout.seconds()));
            SearchResultEntry results = LdapUtils.searchForEntry(connection, request, logger);
            Attribute attribute = results.getAttribute(this.userAttribute);
            if (attribute == null) {
                throw Exceptions.authenticationError("no results returned for DN [{}] attribute [{}]", userDn, this.userAttribute);
            }
            return attribute.getValue();
        }
        catch (LDAPException e) {
            throw Exceptions.authenticationError("could not retrieve attribute [{}] for DN [{}]", e, this.userAttribute, userDn);
        }
    }
}

