/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.ldap;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.ShieldSettingsFilter;
import org.elasticsearch.shield.authc.RealmConfig;
import org.elasticsearch.shield.authc.ldap.LdapSessionFactory;
import org.elasticsearch.shield.authc.ldap.LdapUserSearchSessionFactory;
import org.elasticsearch.shield.authc.ldap.support.AbstractLdapRealm;
import org.elasticsearch.shield.authc.ldap.support.SessionFactory;
import org.elasticsearch.shield.authc.support.DnRoleMapper;
import org.elasticsearch.shield.ssl.ClientSSLService;
import org.elasticsearch.watcher.ResourceWatcherService;

public class LdapRealm
extends AbstractLdapRealm {
    public static final String TYPE = "ldap";

    public LdapRealm(RealmConfig config, SessionFactory ldap, DnRoleMapper roleMapper) {
        super(TYPE, config, ldap, roleMapper);
    }

    public static class Factory
    extends AbstractLdapRealm.Factory<LdapRealm> {
        private final ResourceWatcherService watcherService;
        private final ClientSSLService clientSSLService;

        @Inject
        public Factory(ResourceWatcherService watcherService, ClientSSLService clientSSLService) {
            super(LdapRealm.TYPE);
            this.watcherService = watcherService;
            this.clientSSLService = clientSSLService;
        }

        @Override
        public void filterOutSensitiveSettings(String realmName, ShieldSettingsFilter filter) {
            LdapUserSearchSessionFactory.filterOutSensitiveSettings(realmName, filter);
        }

        @Override
        public LdapRealm create(RealmConfig config) {
            try {
                SessionFactory sessionFactory = Factory.sessionFactory(config, this.clientSSLService);
                DnRoleMapper roleMapper = new DnRoleMapper(LdapRealm.TYPE, config, this.watcherService, null);
                return new LdapRealm(config, sessionFactory, roleMapper);
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to create realm [{}/{}]", (Throwable)e, new Object[]{LdapRealm.TYPE, config.name()});
            }
        }

        static SessionFactory sessionFactory(RealmConfig config, ClientSSLService clientSSLService) throws IOException {
            Settings searchSettings = config.settings().getAsSettings("user_search");
            if (!searchSettings.names().isEmpty()) {
                if (config.settings().getAsArray("user_dn_templates").length > 0) {
                    throw new IllegalArgumentException("settings were found for both user search and user template modes of operation. Please remove the settings for the\nmode you do not wish to use. For more details refer to the ldap authentication section of the Shield guide.");
                }
                return new LdapUserSearchSessionFactory(config, clientSSLService);
            }
            return new LdapSessionFactory(config, clientSSLService);
        }
    }
}

