/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.activedirectory;

import com.google.common.primitives.Ints;
import com.unboundid.ldap.sdk.FailoverServerSet;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.ServerSet;
import java.io.IOException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.ShieldSettingsFilter;
import org.elasticsearch.shield.authc.RealmConfig;
import org.elasticsearch.shield.authc.activedirectory.ActiveDirectoryGroupsResolver;
import org.elasticsearch.shield.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.shield.authc.ldap.support.LdapSession;
import org.elasticsearch.shield.authc.ldap.support.LdapUtils;
import org.elasticsearch.shield.authc.ldap.support.SessionFactory;
import org.elasticsearch.shield.authc.support.SecuredString;
import org.elasticsearch.shield.ssl.ClientSSLService;
import org.elasticsearch.shield.support.Exceptions;

public class ActiveDirectorySessionFactory
extends SessionFactory {
    public static final String AD_DOMAIN_NAME_SETTING = "domain_name";
    public static final String AD_GROUP_SEARCH_BASEDN_SETTING = "group_search.base_dn";
    public static final String AD_GROUP_SEARCH_SCOPE_SETTING = "group_search.scope";
    public static final String AD_USER_SEARCH_BASEDN_SETTING = "user_search.base_dn";
    public static final String AD_USER_SEARCH_FILTER_SETTING = "user_search.filter";
    public static final String AD_USER_SEARCH_SCOPE_SETTING = "user_search.scope";
    private final String userSearchDN;
    private final String domainName;
    private final String userSearchFilter;
    private final LdapSearchScope userSearchScope;
    private final LdapSession.GroupsResolver groupResolver;
    private final ServerSet ldapServerSet;

    public ActiveDirectorySessionFactory(RealmConfig config, ClientSSLService sslService) {
        super(config);
        Settings settings = config.settings();
        this.domainName = settings.get(AD_DOMAIN_NAME_SETTING);
        if (this.domainName == null) {
            throw new IllegalArgumentException("missing [domain_name] setting for active directory");
        }
        String domainDN = this.buildDnFromDomain(this.domainName);
        this.userSearchDN = settings.get(AD_USER_SEARCH_BASEDN_SETTING, domainDN);
        this.userSearchScope = LdapSearchScope.resolve(settings.get(AD_USER_SEARCH_SCOPE_SETTING), LdapSearchScope.SUB_TREE);
        this.userSearchFilter = settings.get(AD_USER_SEARCH_FILTER_SETTING, "(&(objectClass=user)(|(sAMAccountName={0})(userPrincipalName={0}@" + this.domainName + ")))");
        this.ldapServerSet = this.serverSet(config.settings(), sslService);
        this.groupResolver = new ActiveDirectoryGroupsResolver(settings.getAsSettings("group_search"), domainDN);
    }

    static void filterOutSensitiveSettings(String realmName, ShieldSettingsFilter filter) {
        filter.filterOut("shield.authc.realms." + realmName + "." + "hostname_verification");
    }

    ServerSet serverSet(Settings settings, ClientSSLService clientSSLService) {
        SSLSocketFactory socketFactory;
        String[] ldapUrls = settings.getAsArray("url", new String[]{"ldap://" + this.domainName + ":389"});
        SessionFactory.LDAPServers servers = new SessionFactory.LDAPServers(ldapUrls);
        LDAPConnectionOptions options = ActiveDirectorySessionFactory.connectionOptions(settings);
        if (servers.ssl()) {
            socketFactory = clientSSLService.sslSocketFactory();
            if (settings.getAsBoolean("hostname_verification", Boolean.valueOf(true)).booleanValue()) {
                this.logger.debug("using encryption for LDAP connections with hostname verification", new Object[0]);
            } else {
                this.logger.debug("using encryption for LDAP connections without hostname verification", new Object[0]);
            }
        } else {
            socketFactory = null;
        }
        FailoverServerSet serverSet = new FailoverServerSet(servers.addresses(), servers.ports(), (SocketFactory)socketFactory, options);
        serverSet.setReOrderOnFailover(true);
        return serverSet;
    }

    @Override
    public LdapSession session(String userName, SecuredString password) throws Exception {
        LDAPConnection connection;
        try {
            connection = this.ldapServerSet.getConnection();
        }
        catch (LDAPException e) {
            throw new IOException("failed to connect to any active directory servers", e);
        }
        String userPrincipal = userName + "@" + this.domainName;
        try {
            connection.bind(userPrincipal, new String(password.internalChars()));
            SearchRequest searchRequest = new SearchRequest(this.userSearchDN, this.userSearchScope.scope(), LdapUtils.createFilter(this.userSearchFilter, userName), Strings.EMPTY_ARRAY);
            searchRequest.setTimeLimitSeconds(Ints.checkedCast((long)this.timeout.seconds()));
            SearchResult results = LdapUtils.search((LDAPInterface)connection, searchRequest, this.logger);
            int numResults = results.getEntryCount();
            if (numResults > 1) {
                throw new IllegalStateException("search for user [" + userName + "] by principle name yielded multiple results");
            }
            if (numResults < 1) {
                throw new IllegalStateException("search for user [" + userName + "] by principle name yielded no results");
            }
            String dn = ((SearchResultEntry)results.getSearchEntries().get(0)).getDN();
            return new LdapSession(this.connectionLogger, (LDAPInterface)connection, dn, this.groupResolver, this.timeout);
        }
        catch (LDAPException e) {
            connection.close();
            throw Exceptions.authenticationError("unable to authenticate user [{}] to active directory domain [{}]", e, userName, this.domainName);
        }
    }

    String buildDnFromDomain(String domain) {
        return "DC=" + domain.replace(".", ",DC=");
    }
}

