/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc;

import java.io.IOException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.Base64;
import org.elasticsearch.common.ContextAndHeaderHolder;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.audit.AuditTrail;
import org.elasticsearch.shield.authc.AnonymousService;
import org.elasticsearch.shield.authc.AuthenticationFailureHandler;
import org.elasticsearch.shield.authc.AuthenticationService;
import org.elasticsearch.shield.authc.AuthenticationToken;
import org.elasticsearch.shield.authc.Realm;
import org.elasticsearch.shield.authc.Realms;
import org.elasticsearch.shield.crypto.CryptoService;
import org.elasticsearch.shield.support.Exceptions;
import org.elasticsearch.transport.TransportMessage;

public class InternalAuthenticationService
extends AbstractComponent
implements AuthenticationService {
    public static final String SETTING_SIGN_USER_HEADER = "shield.authc.sign_user_header";
    public static final String SETTING_RUN_AS_ENABLED = "shield.authc.run_as.enabled";
    public static final String RUN_AS_USER_HEADER = "es-shield-runas-user";
    static final String TOKEN_KEY = "_shield_token";
    public static final String USER_KEY = "_shield_user";
    private final Realms realms;
    private final AuditTrail auditTrail;
    private final CryptoService cryptoService;
    private final AnonymousService anonymousService;
    private final AuthenticationFailureHandler failureHandler;
    private final boolean signUserHeader;
    private final boolean runAsEnabled;

    @Inject
    public InternalAuthenticationService(Settings settings, Realms realms, AuditTrail auditTrail, CryptoService cryptoService, AnonymousService anonymousService, AuthenticationFailureHandler failureHandler) {
        super(settings);
        this.realms = realms;
        this.auditTrail = auditTrail;
        this.cryptoService = cryptoService;
        this.anonymousService = anonymousService;
        this.failureHandler = failureHandler;
        this.signUserHeader = settings.getAsBoolean(SETTING_SIGN_USER_HEADER, Boolean.valueOf(true));
        this.runAsEnabled = settings.getAsBoolean(SETTING_RUN_AS_ENABLED, Boolean.valueOf(true));
    }

    @Override
    public User authenticate(RestRequest request) throws ElasticsearchSecurityException {
        String runAsUsername;
        AuthenticationToken token;
        User user = this.getUserFromContext((ContextAndHeaderHolder)request);
        if (user != null) {
            return user;
        }
        try {
            token = this.token(request);
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("failed to extract token from request", (Throwable)e, new Object[0]);
            } else {
                this.logger.warn("failed to extract token from request: {}", new Object[]{e.getMessage()});
            }
            this.auditTrail.authenticationFailed(request);
            throw this.failureHandler.exceptionProcessingRequest(request, e);
        }
        if (token == null) {
            if (this.anonymousService.enabled()) {
                request.putInContext((Object)USER_KEY, (Object)this.anonymousService.anonymousUser());
                return this.anonymousService.anonymousUser();
            }
            this.auditTrail.anonymousAccessDenied(request);
            throw this.failureHandler.missingToken(request);
        }
        try {
            user = this.authenticate(request, token);
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("authentication of request failed for principal [{}], uri [{}]", (Throwable)e, new Object[]{token.principal(), request.uri()});
            }
            this.auditTrail.authenticationFailed(token, request);
            throw this.failureHandler.exceptionProcessingRequest(request, e);
        }
        if (user == null) {
            throw this.failureHandler.unsuccessfulAuthentication(request, token);
        }
        if (this.runAsEnabled && (runAsUsername = request.header(RUN_AS_USER_HEADER)) != null) {
            User runAsUser;
            if (runAsUsername.isEmpty()) {
                this.logger.warn("user [{}] attempted to runAs with an empty username", new Object[]{user.principal()});
                this.auditTrail.authenticationFailed(token, request);
                throw this.failureHandler.unsuccessfulAuthentication(request, token);
            }
            try {
                runAsUser = this.lookupUser(runAsUsername);
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("lookup of run as user failed for principal [{}], uri [{}], run as username [{}]", (Throwable)e, new Object[]{token.principal(), request.uri(), runAsUsername});
                }
                this.auditTrail.authenticationFailed(token, request);
                throw this.failureHandler.exceptionProcessingRequest(request, e);
            }
            try {
                user = runAsUser != null ? new User.Simple(user.principal(), user.roles(), runAsUser) : new User.Simple(user.principal(), user.roles(), new User.Simple(runAsUsername, null));
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("user creation failed for principal [{}], uri [{}], run as username [{}]", (Throwable)e, new Object[]{token.principal(), request.uri(), runAsUsername});
                }
                this.auditTrail.authenticationFailed(token, request);
                throw this.failureHandler.exceptionProcessingRequest(request, e);
            }
        }
        request.putInContext((Object)USER_KEY, (Object)user);
        return user;
    }

    @Override
    public User authenticate(String action, TransportMessage message, User fallbackUser) throws IOException {
        User user = this.getUserFromContext((ContextAndHeaderHolder)message);
        if (user != null) {
            return user;
        }
        String header = (String)message.getHeader(USER_KEY);
        if (header != null) {
            if (this.signUserHeader) {
                try {
                    header = this.cryptoService.unsignAndVerify(header);
                }
                catch (Exception e) {
                    this.auditTrail.tamperedRequest(action, message);
                    throw e;
                }
            }
            user = InternalAuthenticationService.decodeUser(header);
        }
        if (user == null) {
            user = this.authenticateWithRealms(action, message, fallbackUser);
            header = this.signUserHeader ? this.cryptoService.sign(InternalAuthenticationService.encodeUser(user, this.logger)) : InternalAuthenticationService.encodeUser(user, this.logger);
            message.putHeader(USER_KEY, (Object)header);
        }
        message.putInContext((Object)USER_KEY, (Object)user);
        return user;
    }

    @Override
    public void attachUserHeaderIfMissing(ContextAndHeaderHolder message, User user) throws IOException {
        if (message.hasHeader(USER_KEY)) {
            return;
        }
        User userFromContext = (User)message.getFromContext((Object)USER_KEY);
        if (userFromContext != null) {
            String userHeader = this.signUserHeader ? this.cryptoService.sign(InternalAuthenticationService.encodeUser(userFromContext, this.logger)) : InternalAuthenticationService.encodeUser(userFromContext, this.logger);
            message.putHeader(USER_KEY, (Object)userHeader);
            return;
        }
        message.putInContext((Object)USER_KEY, (Object)user);
        String userHeader = this.signUserHeader ? this.cryptoService.sign(InternalAuthenticationService.encodeUser(user, this.logger)) : InternalAuthenticationService.encodeUser(user, this.logger);
        message.putHeader(USER_KEY, (Object)userHeader);
    }

    User getUserFromContext(ContextAndHeaderHolder message) {
        User user = (User)message.getFromContext((Object)USER_KEY);
        if (user != null) {
            return user;
        }
        return null;
    }

    static User decodeUser(String text) {
        try {
            byte[] bytes = Base64.decode((String)text);
            StreamInput input = StreamInput.wrap((byte[])bytes);
            return User.readFrom(input);
        }
        catch (IOException ioe) {
            throw Exceptions.authenticationError("could not read authenticated user", ioe, new Object[0]);
        }
    }

    static String encodeUser(User user, ESLogger logger) {
        try {
            BytesStreamOutput output = new BytesStreamOutput();
            User.writeTo(user, (StreamOutput)output);
            byte[] bytes = output.bytes().toBytes();
            return Base64.encodeBytes((byte[])bytes);
        }
        catch (IOException ioe) {
            if (logger != null) {
                logger.error("could not encode authenticated user in message header... falling back to token headers", (Throwable)ioe, new Object[0]);
            }
            return null;
        }
    }

    User authenticateWithRealms(String action, TransportMessage<?> message, User fallbackUser) throws ElasticsearchSecurityException {
        String runAsUsername;
        User user;
        AuthenticationToken token;
        try {
            token = this.token(action, message);
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("failed to extract token from transport message", (Throwable)e, new Object[0]);
            } else {
                this.logger.warn("failed to extract token from transport message: ", new Object[]{e.getMessage()});
            }
            this.auditTrail.authenticationFailed(action, message);
            throw this.failureHandler.exceptionProcessingRequest(message, e);
        }
        if (token == null) {
            if (fallbackUser != null) {
                return fallbackUser;
            }
            if (this.anonymousService.enabled()) {
                return this.anonymousService.anonymousUser();
            }
            this.auditTrail.anonymousAccessDenied(action, message);
            throw this.failureHandler.missingToken(message, action);
        }
        try {
            user = this.authenticate(message, token, action);
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("authentication of transport message failed for principal [{}], action [{}]", (Throwable)e, new Object[]{token.principal(), action});
            }
            this.auditTrail.authenticationFailed(token, action, message);
            throw this.failureHandler.exceptionProcessingRequest(message, e);
        }
        if (user == null) {
            throw this.failureHandler.unsuccessfulAuthentication(message, token, action);
        }
        if (this.runAsEnabled && (runAsUsername = (String)message.getHeader(RUN_AS_USER_HEADER)) != null) {
            User runAsUser;
            if (runAsUsername.isEmpty()) {
                this.logger.warn("user [{}] attempted to runAs with an empty username", new Object[]{user.principal()});
                this.auditTrail.authenticationFailed(token, action, message);
                throw this.failureHandler.unsuccessfulAuthentication(message, token, action);
            }
            try {
                runAsUser = this.lookupUser(runAsUsername);
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("lookup of run as user failed for principal [{}], action [{}], run as username [{}]", (Throwable)e, new Object[]{token.principal(), action, runAsUsername});
                }
                this.auditTrail.authenticationFailed(token, action, message);
                throw this.failureHandler.exceptionProcessingRequest(message, e);
            }
            try {
                user = runAsUser != null ? new User.Simple(user.principal(), user.roles(), runAsUser) : new User.Simple(user.principal(), user.roles(), new User.Simple(runAsUsername, null));
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("user creation failed for principal [{}], action [{}], run as username [{}]", (Throwable)e, new Object[]{token.principal(), action, runAsUsername});
                }
                this.auditTrail.authenticationFailed(token, action, message);
                throw this.failureHandler.exceptionProcessingRequest(message, e);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    User authenticate(TransportMessage<?> message, AuthenticationToken token, String action) throws ElasticsearchSecurityException {
        assert (token != null) : "cannot authenticate null tokens";
        try {
            for (Realm realm : this.realms) {
                if (!realm.supports(token)) continue;
                User user = realm.authenticate(token);
                if (user != null) {
                    User user2 = user;
                    return user2;
                }
                this.auditTrail.authenticationFailed(realm.type(), token, action, message);
            }
            this.auditTrail.authenticationFailed(token, action, message);
            User user = null;
            return user;
        }
        finally {
            token.clearCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    User authenticate(RestRequest request, AuthenticationToken token) throws ElasticsearchSecurityException {
        assert (token != null) : "cannot authenticate null tokens";
        try {
            for (Realm realm : this.realms) {
                if (!realm.supports(token)) continue;
                User user = realm.authenticate(token);
                if (user != null) {
                    User user2 = user;
                    return user2;
                }
                this.auditTrail.authenticationFailed(realm.type(), token, request);
            }
            this.auditTrail.authenticationFailed(token, request);
            User user = null;
            return user;
        }
        finally {
            token.clearCredentials();
        }
    }

    AuthenticationToken token(RestRequest request) throws ElasticsearchSecurityException {
        for (Realm realm : this.realms) {
            Object token = realm.token(request);
            if (token == null) continue;
            request.putInContext((Object)TOKEN_KEY, token);
            return token;
        }
        return null;
    }

    AuthenticationToken token(String action, TransportMessage<?> message) {
        AuthenticationToken token = (AuthenticationToken)message.getFromContext((Object)TOKEN_KEY);
        if (token != null) {
            return token;
        }
        for (Realm realm : this.realms) {
            token = realm.token(message);
            if (token == null) continue;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("realm [{}] resolved authentication token [{}] from transport request with action [{}]", new Object[]{realm, token.principal(), action});
            }
            message.putInContext((Object)TOKEN_KEY, (Object)token);
            return token;
        }
        return null;
    }

    User lookupUser(String username) {
        for (Realm realm : this.realms) {
            User user;
            if (!realm.userLookupSupported() || (user = realm.lookupUser(username)) == null) continue;
            return user;
        }
        return null;
    }
}

